/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.util;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.DefaultDuplocatorState;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.ExternalizableDuplocatorState;
import com.intellij.dupLocator.MultilanguageDuplocatorSettings;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.SiblingNodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplocatorUtil {
    private DuplocatorUtil() {
    }

    public static boolean isIgnoredNode(PsiElement element) {
        if (element instanceof PsiWhiteSpace || element instanceof PsiErrorElement || element instanceof PsiComment) {
            return true;
        }
        if (!(element instanceof LeafElement)) {
            return false;
        }
        if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)element.getText())) {
            return true;
        }
        EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(element);
        if (descriptorProvider == null) {
            return false;
        }
        IElementType elementType = ((LeafElement)element).getElementType();
        return descriptorProvider.getIgnoredTokens().contains(elementType);
    }

    public static PsiElement getOnlyChild(PsiElement element, @NotNull NodeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/dupLocator/util/DuplocatorUtil", "getOnlyChild"));
        }
        FilteringNodeIterator it = new FilteringNodeIterator(new SiblingNodeIterator(element.getFirstChild()), filter);
        PsiElement child = it.current();
        if (child != null) {
            it.advance();
            if (!it.hasNext()) {
                return child;
            }
        }
        return element;
    }

    public static boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
        if (element == null || elementToMatchWith == null) {
            return false;
        }
        if (element.getClass() == elementToMatchWith.getClass()) {
            return false;
        }
        return element.getFirstChild() == null && element.getTextLength() == 0 && !(element instanceof LeafElement);
    }

    @Nullable
    public static PsiElement skipNodeIfNeccessary(PsiElement element, EquivalenceDescriptor descriptor, NodeFilter filter) {
        EquivalenceDescriptorProvider provider;
        if (element == null) {
            return null;
        }
        if (descriptor == null && (provider = EquivalenceDescriptorProvider.getInstance(element)) != null) {
            descriptor = provider.buildDescriptor(element);
        }
        if (descriptor != null) {
            PsiElement onlyChild = DuplocatorUtil.getOnlyChildFromDescriptor(descriptor, filter);
            return onlyChild != null ? onlyChild : element;
        }
        return DuplocatorUtil.getOnlyChild(element, filter);
    }

    @Nullable
    private static PsiElement getOnlyChildFromDescriptor(EquivalenceDescriptor equivalenceDescriptor, NodeFilter filter) {
        PsiElement[] codeBlock;
        if (!equivalenceDescriptor.getConstants().isEmpty()) {
            return null;
        }
        List<SingleChildDescriptor> singleChildren = equivalenceDescriptor.getSingleChildDescriptors();
        List<MultiChildDescriptor> multiChildren = equivalenceDescriptor.getMultiChildDescriptors();
        List<PsiElement[]> codeBlocks = equivalenceDescriptor.getCodeBlocks();
        if (singleChildren.size() + multiChildren.size() + codeBlocks.size() != 1) {
            return null;
        }
        if (!singleChildren.isEmpty()) {
            SingleChildDescriptor descriptor = singleChildren.get(0);
            PsiElement child = descriptor.getElement();
            if (child != null) {
                SingleChildDescriptor.MyType type = descriptor.getType();
                if (type == SingleChildDescriptor.MyType.DEFAULT) {
                    return child;
                }
                if (type == SingleChildDescriptor.MyType.CHILDREN || type == SingleChildDescriptor.MyType.CHILDREN_IN_ANY_ORDER) {
                    return DuplocatorUtil.getOnlyChild(child, filter);
                }
            }
        } else if (!multiChildren.isEmpty()) {
            MultiChildDescriptor descriptor = multiChildren.get(0);
            PsiElement[] children = descriptor.getElements();
            if (children != null && children.length == 1 && descriptor.getType() != MultiChildDescriptor.MyType.OPTIONALLY) {
                return children[0];
            }
        } else if (!codeBlocks.isEmpty() && (codeBlock = codeBlocks.get(0)) != null && codeBlock.length == 1) {
            return codeBlock[0];
        }
        return null;
    }

    public static boolean match(@NotNull EquivalenceDescriptor descriptor1, @NotNull EquivalenceDescriptor descriptor2, @NotNull AbstractMatchingVisitor g, @NotNull Set<PsiElementRole> skippedRoles, @Nullable DuplicatesProfile profile) {
        Object childDescriptor2;
        Object childDescriptor1;
        int i;
        if (descriptor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor1", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor2", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (skippedRoles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedRoles", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (descriptor1.getSingleChildDescriptors().size() != descriptor2.getSingleChildDescriptors().size()) {
            return false;
        }
        if (descriptor1.getMultiChildDescriptors().size() != descriptor2.getMultiChildDescriptors().size()) {
            return false;
        }
        if (descriptor1.getCodeBlocks().size() != descriptor2.getCodeBlocks().size()) {
            return false;
        }
        if (descriptor1.getConstants().size() != descriptor2.getConstants().size()) {
            return false;
        }
        int n = descriptor1.getConstants().size();
        for (i = 0; i < n; ++i) {
            childDescriptor1 = descriptor1.getConstants().get(i);
            if (Comparing.equal((Object)childDescriptor1, (Object)(childDescriptor2 = descriptor2.getConstants().get(i)))) continue;
            return false;
        }
        n = descriptor1.getSingleChildDescriptors().size();
        for (i = 0; i < n; ++i) {
            childDescriptor1 = descriptor1.getSingleChildDescriptors().get(i);
            if (DuplocatorUtil.match((SingleChildDescriptor)childDescriptor1, (SingleChildDescriptor)(childDescriptor2 = descriptor2.getSingleChildDescriptors().get(i)), g, skippedRoles, profile)) continue;
            return false;
        }
        n = descriptor1.getMultiChildDescriptors().size();
        for (i = 0; i < n; ++i) {
            childDescriptor1 = descriptor1.getMultiChildDescriptors().get(i);
            if (DuplocatorUtil.match((MultiChildDescriptor)childDescriptor1, (MultiChildDescriptor)(childDescriptor2 = descriptor2.getMultiChildDescriptors().get(i)), g)) continue;
            return false;
        }
        n = descriptor1.getCodeBlocks().size();
        for (i = 0; i < n; ++i) {
            PsiElement[] codeBlock2;
            PsiElement[] codeBlock1 = descriptor1.getCodeBlocks().get(i);
            if (g.matchSequentially(codeBlock1, codeBlock2 = descriptor2.getCodeBlocks().get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean match(@NotNull SingleChildDescriptor childDescriptor1, @NotNull SingleChildDescriptor childDescriptor2, @NotNull AbstractMatchingVisitor g, @NotNull Set<PsiElementRole> skippedRoles, @Nullable DuplicatesProfile duplicatesProfile) {
        if (childDescriptor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childDescriptor1", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (childDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childDescriptor2", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (skippedRoles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedRoles", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (childDescriptor1.getType() != childDescriptor2.getType()) {
            return false;
        }
        PsiElement element1 = childDescriptor1.getElement();
        PsiElement element2 = childDescriptor2.getElement();
        if (duplicatesProfile != null) {
            PsiElementRole role2;
            PsiElementRole role1 = element1 != null ? duplicatesProfile.getRole(element1) : null;
            PsiElementRole psiElementRole = role2 = element2 != null ? duplicatesProfile.getRole(element2) : null;
            if (role1 == role2 && skippedRoles.contains((Object)role1)) {
                return true;
            }
        }
        switch (childDescriptor1.getType()) {
            case DEFAULT: {
                return g.match(element1, element2);
            }
            case OPTIONALLY_IN_PATTERN: 
            case OPTIONALLY: {
                return g.matchOptionally(element1, element2);
            }
            case CHILDREN: {
                return g.matchSons(element1, element2);
            }
            case CHILDREN_OPTIONALLY_IN_PATTERN: 
            case CHILDREN_OPTIONALLY: {
                return g.matchSonsOptionally(element1, element2);
            }
            case CHILDREN_IN_ANY_ORDER: {
                return g.matchSonsInAnyOrder(element1, element2);
            }
        }
        return false;
    }

    private static boolean match(@NotNull MultiChildDescriptor childDescriptor1, @NotNull MultiChildDescriptor childDescriptor2, @NotNull AbstractMatchingVisitor g) {
        if (childDescriptor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childDescriptor1", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (childDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childDescriptor2", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/dupLocator/util/DuplocatorUtil", "match"));
        }
        if (childDescriptor1.getType() != childDescriptor2.getType()) {
            return false;
        }
        PsiElement[] elements1 = childDescriptor1.getElements();
        PsiElement[] elements2 = childDescriptor2.getElements();
        switch (childDescriptor1.getType()) {
            case DEFAULT: {
                return g.matchSequentially(elements1, elements2);
            }
            case OPTIONALLY_IN_PATTERN: 
            case OPTIONALLY: {
                return g.matchOptionally(elements1, elements2);
            }
            case IN_ANY_ORDER: {
                return g.matchInAnyOrder(elements1, elements2);
            }
        }
        return false;
    }

    @Nullable
    public static DuplocatorState getDuplocatorState(PsiFragment frag) {
        Language language = frag.getLanguage();
        if (language == null) {
            return null;
        }
        DuplicatesProfile profile = DuplicatesProfile.findProfileForLanguage(language);
        return profile != null ? profile.getDuplocatorState(language) : null;
    }

    @NotNull
    public static ExternalizableDuplocatorState registerAndGetState(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/util/DuplocatorUtil", "registerAndGetState"));
        }
        MultilanguageDuplocatorSettings settings = MultilanguageDuplocatorSettings.getInstance();
        ExternalizableDuplocatorState state = settings.getState(language);
        if (state == null) {
            state = new DefaultDuplocatorState();
            settings.registerState(language, state);
        }
        ExternalizableDuplocatorState externalizableDuplocatorState = state;
        if (externalizableDuplocatorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/util/DuplocatorUtil", "registerAndGetState"));
        }
        return externalizableDuplocatorState;
    }
}

