/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.ApplicationConfigurationProducer;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.execution.scratch.JavaScratchConfigurationType;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public class JavaScratchConfigurationProducer
extends ApplicationConfigurationProducer<JavaScratchConfiguration> {
    public JavaScratchConfigurationProducer() {
        super(JavaScratchConfigurationType.getInstance());
    }

    @Override
    protected boolean setupConfigurationFromContext(JavaScratchConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiFile psiFile;
        VirtualFile vFile;
        Location location = context.getLocation();
        if (location != null && (vFile = location.getVirtualFile()) instanceof VirtualFileWithId && vFile.getFileType() == ScratchFileType.INSTANCE && (psiFile = location.getPsiElement().getContainingFile()) != null && psiFile.getLanguage() == JavaLanguage.INSTANCE) {
            configuration.SCRATCH_FILE_ID = ((VirtualFileWithId)vFile).getId();
            return super.setupConfigurationFromContext(configuration, context, sourceElement);
        }
        return false;
    }

    public boolean shouldReplace(ConfigurationFromContext self, ConfigurationFromContext other) {
        return other.isProducedBy(ApplicationConfigurationProducer.class) && !other.isProducedBy(JavaScratchConfigurationProducer.class);
    }

    @Override
    public boolean isConfigurationFromContext(JavaScratchConfiguration configuration, ConfigurationContext context) {
        PsiFile containingFile;
        VirtualFile scratchFile;
        PsiElement location = context.getPsiLocation();
        PsiClass aClass = ApplicationConfigurationType.getMainClass(location);
        return aClass != null && Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)configuration.MAIN_CLASS_NAME) && (scratchFile = configuration.getScratchVirtualFile()) != null && (containingFile = aClass.getContainingFile()) != null && scratchFile.equals(containingFile.getVirtualFile());
    }
}

