/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.ide.actions.ExportSettingsAction;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.ide.actions.MyZipOutputStream;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.PairProcessor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.ClassMapping;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"y\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"E\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001BE\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\t&\u0015\t\u0001\u0012E\u0003\u0002\t\u0007i\u0019\u0002B\u0001\t\u00055\t\u0001TA\r\u0004\u0011\ri\u0011\u0001g\u0002U\u0007\u0007i9\u0003\u0003\u0003\u000e\u0003a\u0015\u0011D\u0002E\u0005\u001b\u0011I!!C\u0001\u0019\fa)\u0011d\u0001\u0005\u0007\u001b\u0005Aj!G\u0002\t\u000f5\t\u0001t\u0002+\u0004\u00045%B!\u0001\u0005\t\u001b\u0005Az!G\u0002\t\u00125\t\u0001$C\r\u0006\u0011'i1!C\u0001\u0005\u0004aQ\u0011\u0004\u0002E\u000b\u001b\ta\t\u0001G\u0006U\u0007\u0007i9\u0005c\u0006\u000e\u0015%\u0011\u0011\"\u0001M\u0006\u0013\u0015IA!\u0003\u0002\n\u0003ai\u0001\u0014\u0004\r\r3\rAY\"D\u0001\u0019\u001de\u0019\u0001RD\u0007\u000219IB\u0001B\u0001\t\u001f5\t\u0001tD\r\t\t\u0005A\u0001#D\u0003\n\u0005%\t\u0001t\u0002G\u00011\u0015!61AG\u0012\t\u0005A\t#D\u0001\u0019\u0010e\u0019\u0001\"E\u0007\u00021GI2\u0001\u0003\n\u000e\u0003a=\u0011d\u0001E\u0013\u001b\u0005Az\u0001VB\u0002\u001b\rB1#D\u0001\u0019\u0006E\u0011A\u0001\u0001E\u0014#\t!\t\u0001\u0003\u000b\u0016\u0015%\u0011\u0011\"\u0001S\u0014\u0013\u0015IA!\u0003\u0002\n\u0003\u0011\"\u0002$\u0006M\u00153\u0013AY#D\u0001%(A\u001b\t!'\u0003\t-5\tA\u0005\u0006)\u0004\u0003E\u001b\u0011\u0001#\fU\u0007\u0007\t2\u0002B!\t\u0011\u0001i9\u0001'\u0001R\u0007\u0005!\u0011!U\u0002\u0002\u000b\u0001!61\u0001"}, strings={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ExportSettingsActionKt", "exportInstalledPlugins", "", "zipOut", "Lcom/intellij/ide/actions/MyZipOutputStream;", "exportSettings", "exportFiles", "", "Ljava/io/File;", "out", "Ljava/io/OutputStream;", "configPath", "", "getComponentPresentableName", "state", "Lcom/intellij/openapi/components/State;", "aClass", "Ljava/lang/Class;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getExportableComponentsMap", "", "", "Lcom/intellij/ide/actions/ExportableItem;", "onlyExisting", "", "computePresentableNames", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "onlyPaths", "messageOrDefault", "classLoader", "Ljava/lang/ClassLoader;", "bundleName", "defaultName", "putValue", "K", "V", "", "", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V"}, moduleName="configuration-store-impl")
public final class ExportSettingsActionKt {
    private static final Logger LOG = Logger.getInstance(ExportSettingsAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportSettings(@NotNull Set<? extends File> exportFiles, @NotNull OutputStream out, @NotNull String configPath) {
        Intrinsics.checkParameterIsNotNull(exportFiles, (String)"exportFiles");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        MyZipOutputStream zipOut = new MyZipOutputStream(out);
        try {
            THashSet writtenItemRelativePaths = new THashSet();
            for (File file : exportFiles) {
                String relativePath;
                if (!file.exists()) continue;
                if (FileUtilRt.getRelativePath((String)configPath, (String)FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath()), (char)'/') == null) {
                    Intrinsics.throwNpe();
                }
                ZipUtil.addFileOrDirRecursively((ZipOutputStream)zipOut, (File)null, (File)file, (String)relativePath, (FileFilter)null, (Set)((Set)writtenItemRelativePaths));
            }
            ExportSettingsActionKt.exportInstalledPlugins(zipOut);
            ZipEntry zipEntry = new ZipEntry("IntelliJ IDEA Global Settings");
            zipOut.putNextEntry(zipEntry);
            zipOut.closeEntry();
        }
        finally {
            zipOut.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void exportInstalledPlugins(MyZipOutputStream zipOut) {
        ArrayList<String> plugins = new ArrayList<String>();
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        for (int i = 0; i < ideaPluginDescriptorArray.length; ++i) {
            IdeaPluginDescriptor descriptor = ideaPluginDescriptorArray[i];
            if (descriptor.isBundled() || !descriptor.isEnabled()) continue;
            plugins.add(descriptor.getPluginId().getIdString());
        }
        if (plugins.isEmpty()) {
            return;
        }
        ZipEntry e = new ZipEntry("installed.txt");
        zipOut.putNextEntry(e);
        try {
            PluginManagerCore.writePluginsList((Collection<String>)plugins, new OutputStreamWriter((OutputStream)zipOut, CharsetToolkit.UTF8_CHARSET));
        }
        finally {
            zipOut.closeEntry();
        }
    }

    public static final <K, V> void putValue(Map<K, List<V>> $receiver, K key, V value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        List list = $receiver.get(key);
        if (list == null) {
            list = (List)new SmartList(value);
            $receiver.put(key, list);
        } else {
            list.add(value);
        }
    }

    @NotNull
    public static final Map<File, List<? extends ExportableItem>> getExportableComponentsMap(boolean onlyExisting, boolean computePresentableNames, @NotNull StateStorageManager storageManager2, @Nullable Set<? extends String> onlyPaths) {
        Iterable $receiver;
        Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
        LinkedHashMap result2 = new LinkedHashMap();
        Function1 processor2 = (Function1)new Function1<ExportableComponent, Unit>(result2){
            final /* synthetic */ LinkedHashMap $result;

            public final void invoke(@NotNull ExportableComponent component) {
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                List list = ArraysKt.toList((Object[])component.getExportFiles());
                String string = component.getPresentableName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"component.presentableName");
                ExportableItem item = new ExportableItem(list, string, RoamingType.DEFAULT);
                for (File exportFile : item.getFiles()) {
                    ExportSettingsActionKt.putValue(this.$result, exportFile, item);
                }
            }
            {
                this.$result = linkedHashMap;
                super(1);
            }
        };
        Object[] objectArray = ApplicationManager.getApplication().getComponents(ExportableApplicationComponent.class);
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            Object element = $receiver[i];
            processor2.invoke(element);
        }
        $receiver = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
        for (Object element : $receiver) {
            processor2.invoke(element);
        }
        String configPath = storageManager2.expandMacros(SchemeManagerFactoryImplKt.getROOT_CONFIG());
        Function1<File, Boolean> isSkipFile$ = new Function1<File, Boolean>(onlyPaths, configPath, onlyExisting){
            final /* synthetic */ Set $onlyPaths;
            final /* synthetic */ String $configPath;
            final /* synthetic */ boolean $onlyExisting;

            public final boolean invoke(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (this.$onlyPaths != null) {
                    String string = FileUtilRt.getRelativePath((String)this.$configPath, (String)FileUtilKt.getSystemIndependentPath(file), (char)'/');
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String relativePath = string;
                    if (!StringsKt.contains$default((String)file.getName(), (char)'.', (boolean)false, (int)2) && !file.isFile()) {
                        relativePath = relativePath + '/';
                    }
                    if (!this.$onlyPaths.contains(relativePath)) {
                        return true;
                    }
                }
                return this.$onlyExisting && !file.exists();
            }
            {
                this.$onlyPaths = set;
                this.$configPath = string;
                this.$onlyExisting = bl;
                super(1);
            }
        };
        if (onlyExisting || onlyPaths != null) {
            Iterator it = CollectionsKt.mutableKeys((Map)result2).iterator();
            while (it.hasNext()) {
                if (!isSkipFile$.invoke((File)it.next())) continue;
                it.remove();
            }
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ServiceManagerImpl.processAllImplementationClasses((ApplicationImpl)application, (PairProcessor)new PairProcessor<Class<?>, PluginDescriptor>(storageManager2, isSkipFile$, computePresentableNames, result2){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile;
            final /* synthetic */ boolean $computePresentableNames;
            final /* synthetic */ LinkedHashMap $result;

            public boolean process(@NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
                File file;
                boolean isFileIncluded;
                Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
                State stateAnnotation = StoreUtil.getStateSpec(aClass);
                if (stateAnnotation == null || StringsKt.isNullOrEmpty((String)stateAnnotation.name()) || ExportableComponent.class.isAssignableFrom(aClass)) {
                    return true;
                }
                Storage storage2 = (Storage)ArraysKt.firstOrNull((Object[])ComponentStoreImplKt.sortStoragesByDeprecated(stateAnnotation.storages()));
                if (storage2 == null) {
                    return true;
                }
                Storage storage3 = storage2;
                if (!(Intrinsics.areEqual((Object)storage3.roamingType(), (Object)RoamingType.DISABLED) ^ true) || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass((Class)storage3.storageClass()), (Object)Reflection.getOrCreateKotlinClass(StateStorage.class)) || !Intrinsics.areEqual((Object)storage3.scheme(), (Object)StorageScheme.DEFAULT) || StringsKt.isNullOrEmpty((String)storage3.file())) {
                    return true;
                }
                File additionalExportFile = null;
                String additionalExportPath = stateAnnotation.additionalExportFile();
                if (StringsKt.isNotEmpty((String)additionalExportPath)) {
                    if (additionalExportPath.charAt(0) != '$') {
                        additionalExportPath = SchemeManagerFactoryImplKt.getROOT_CONFIG() + "/" + additionalExportPath;
                    }
                    if (this.$isSkipFile.invoke(additionalExportFile = new File(this.$storageManager.expandMacros(additionalExportPath)))) {
                        additionalExportFile = null;
                    }
                }
                boolean bl = isFileIncluded = !this.$isSkipFile.invoke(file = new File(this.$storageManager.expandMacros(storage3.file())));
                if (isFileIncluded || additionalExportFile != null) {
                    List files = additionalExportFile == null ? CollectionsKt.listOf((Object)file) : (isFileIncluded ? CollectionsKt.listOf((Object[])new File[]{file, additionalExportFile}) : CollectionsKt.listOf((Object)additionalExportFile));
                    ExportableItem item = new ExportableItem(files, this.$computePresentableNames ? ExportSettingsActionKt.access$getComponentPresentableName(stateAnnotation, aClass, pluginDescriptor) : "", storage3.roamingType());
                    ExportSettingsActionKt.putValue(this.$result, file, item);
                    if (additionalExportFile != null) {
                        ExportSettingsActionKt.putValue(this.$result, additionalExportFile, item);
                    }
                }
                return true;
            }
            {
                this.$storageManager = $captured_local_variable$0;
                this.$isSkipFile = $captured_local_variable$1;
                this.$computePresentableNames = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
            }
        });
        return result2;
    }

    @NotNull
    public static /* synthetic */ Map getExportableComponentsMap$default(boolean bl, boolean bl2, StateStorageManager stateStorageManager, Set set, int n) {
        if ((n & 4) != 0) {
            StateStorageManager stateStorageManager2 = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStateStorageManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)stateStorageManager2, (String)"ApplicationManager.getAp\u2026Store.stateStorageManager");
            stateStorageManager = stateStorageManager2;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return ExportSettingsActionKt.getExportableComponentsMap(bl, bl2, stateStorageManager, set);
    }

    private static final String getComponentPresentableName(State state, Class<?> aClass, PluginDescriptor pluginDescriptor) {
        Object classLoader;
        Class presentableName = ClassMapping.getJava((KClass)Reflection.getOrCreateKotlinClass((Class)state.presentableName()));
        if (Intrinsics.areEqual((Object)presentableName, State.NameGetter.class) ^ true) {
            try {
                String string = (String)((State.NameGetter)ReflectionUtil.newInstance((Class)presentableName)).get();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ReflectionUtil.newInstance(presentableName).get()");
                return string;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        String defaultName = state.name();
        String string = pluginDescriptor instanceof IdeaPluginDescriptor && Intrinsics.areEqual((Object)"com.intellij", (Object)((IdeaPluginDescriptor)pluginDescriptor).getPluginId().getIdString()) ^ true ? ((IdeaPluginDescriptor)pluginDescriptor).getResourceBundleBaseName() : "messages.OptionsBundle";
        if (string == null) {
            return defaultName;
        }
        String resourceBundleName = string;
        Object object = pluginDescriptor;
        if (object == null || (object = object.getPluginClassLoader()) == null) {
            object = classLoader = aClass.getClassLoader();
        }
        if (classLoader != null) {
            String message = ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, resourceBundleName, defaultName);
            if (message != defaultName) {
                return message;
            }
            if (PlatformUtils.isRubyMine()) {
                return ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, "org.jetbrains.plugins.ruby.RBundle", defaultName);
            }
        }
        return defaultName;
    }

    private static final String messageOrDefault(ClassLoader classLoader, String bundleName, String defaultName) {
        ResourceBundle resourceBundle = AbstractBundle.getResourceBundle((String)bundleName, (ClassLoader)classLoader);
        if (resourceBundle == null) {
            return defaultName;
        }
        ResourceBundle bundle = resourceBundle;
        String string = CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)("exportable." + defaultName + ".presentable.name"), (String)defaultName, (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CommonBundle.messageOrDe\u2026table.name\", defaultName)");
        return string;
    }

    @NotNull
    public static final /* synthetic */ String access$getComponentPresentableName(@NotNull State state, @NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
        return ExportSettingsActionKt.getComponentPresentableName(state, aClass, pluginDescriptor);
    }
}

