/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lexer.JavaHighlightingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaFileHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ourMap1;
    private static final Map<IElementType, TextAttributesKey> ourMap2;
    protected final LanguageLevel myLanguageLevel;

    public JavaFileHighlighter() {
        this(LanguageLevel.HIGHEST);
    }

    public JavaFileHighlighter(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/ide/highlighter/JavaFileHighlighter", "<init>"));
        }
        this.myLanguageLevel = languageLevel;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        JavaHighlightingLexer javaHighlightingLexer = new JavaHighlightingLexer(this.myLanguageLevel);
        if (javaHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/JavaFileHighlighter", "getHighlightingLexer"));
        }
        return javaHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = JavaFileHighlighter.pack((TextAttributesKey)ourMap1.get(tokenType), (TextAttributesKey)ourMap2.get(tokenType));
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/JavaFileHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    static {
        IElementType[] javaDocMarkup;
        ourMap1 = new HashMap<IElementType, TextAttributesKey>();
        ourMap2 = new HashMap<IElementType, TextAttributesKey>();
        JavaFileHighlighter.fillMap(ourMap1, (TokenSet)ElementType.KEYWORD_BIT_SET, (TextAttributesKey)JavaHighlightingColors.KEYWORD);
        JavaFileHighlighter.fillMap(ourMap1, (TokenSet)ElementType.LITERAL_BIT_SET, (TextAttributesKey)JavaHighlightingColors.KEYWORD);
        JavaFileHighlighter.fillMap(ourMap1, (TokenSet)ElementType.OPERATION_BIT_SET, (TextAttributesKey)JavaHighlightingColors.OPERATION_SIGN);
        for (IElementType type : JavaDocTokenType.ALL_JAVADOC_TOKENS.getTypes()) {
            ourMap1.put(type, JavaHighlightingColors.DOC_COMMENT);
        }
        ourMap1.put(XmlTokenType.XML_DATA_CHARACTERS, JavaHighlightingColors.DOC_COMMENT);
        ourMap1.put(XmlTokenType.XML_REAL_WHITE_SPACE, JavaHighlightingColors.DOC_COMMENT);
        ourMap1.put(XmlTokenType.TAG_WHITE_SPACE, JavaHighlightingColors.DOC_COMMENT);
        ourMap1.put(JavaTokenType.INTEGER_LITERAL, JavaHighlightingColors.NUMBER);
        ourMap1.put(JavaTokenType.LONG_LITERAL, JavaHighlightingColors.NUMBER);
        ourMap1.put(JavaTokenType.FLOAT_LITERAL, JavaHighlightingColors.NUMBER);
        ourMap1.put(JavaTokenType.DOUBLE_LITERAL, JavaHighlightingColors.NUMBER);
        ourMap1.put(JavaTokenType.STRING_LITERAL, JavaHighlightingColors.STRING);
        ourMap1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, JavaHighlightingColors.VALID_STRING_ESCAPE);
        ourMap1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, JavaHighlightingColors.INVALID_STRING_ESCAPE);
        ourMap1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, JavaHighlightingColors.INVALID_STRING_ESCAPE);
        ourMap1.put(JavaTokenType.CHARACTER_LITERAL, JavaHighlightingColors.STRING);
        ourMap1.put(JavaTokenType.LPARENTH, JavaHighlightingColors.PARENTHESES);
        ourMap1.put(JavaTokenType.RPARENTH, JavaHighlightingColors.PARENTHESES);
        ourMap1.put(JavaTokenType.LBRACE, JavaHighlightingColors.BRACES);
        ourMap1.put(JavaTokenType.RBRACE, JavaHighlightingColors.BRACES);
        ourMap1.put(JavaTokenType.LBRACKET, JavaHighlightingColors.BRACKETS);
        ourMap1.put(JavaTokenType.RBRACKET, JavaHighlightingColors.BRACKETS);
        ourMap1.put(JavaTokenType.COMMA, JavaHighlightingColors.COMMA);
        ourMap1.put(JavaTokenType.DOT, JavaHighlightingColors.DOT);
        ourMap1.put(JavaTokenType.SEMICOLON, JavaHighlightingColors.JAVA_SEMICOLON);
        ourMap1.put(JavaTokenType.C_STYLE_COMMENT, JavaHighlightingColors.JAVA_BLOCK_COMMENT);
        ourMap1.put((IElementType)JavaDocElementType.DOC_COMMENT, JavaHighlightingColors.DOC_COMMENT);
        ourMap1.put(JavaTokenType.END_OF_LINE_COMMENT, JavaHighlightingColors.LINE_COMMENT);
        ourMap1.put(TokenType.BAD_CHARACTER, HighlighterColors.BAD_CHARACTER);
        ourMap1.put(JavaDocTokenType.DOC_TAG_NAME, JavaHighlightingColors.DOC_COMMENT);
        ourMap2.put(JavaDocTokenType.DOC_TAG_NAME, JavaHighlightingColors.DOC_COMMENT_TAG);
        for (IElementType idx : javaDocMarkup = new IElementType[]{XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_TAG_END, XmlTokenType.XML_EMPTY_ELEMENT_END, XmlTokenType.TAG_WHITE_SPACE, XmlTokenType.XML_TAG_NAME, XmlTokenType.XML_NAME, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, XmlTokenType.XML_CHAR_ENTITY_REF, XmlTokenType.XML_EQ}) {
            ourMap1.put(idx, JavaHighlightingColors.DOC_COMMENT);
            ourMap2.put(idx, JavaHighlightingColors.DOC_COMMENT_MARKUP);
        }
    }
}

