/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ProjectTopics;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.scopeView.ScopeTreeStructureExpander;
import com.intellij.ide.scopeView.nodes.BasePsiNode;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageTreeExpansionMonitor;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBTreeWithHintProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UIBundle;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeTreeViewPanel
extends JPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.scopeView.ScopeTreeViewPanel");
    private final IdeView myIdeView;
    private final MyPsiTreeChangeAdapter myPsiTreeChangeAdapter;
    private final DnDAwareTree myTree;
    @NotNull
    private final Project myProject;
    private FileTreeModelBuilder myBuilder;
    private String CURRENT_SCOPE_NAME;
    private TreeExpansionMonitor<PackageDependenciesNode> myTreeExpansionMonitor;
    private CopyPasteDelegator myCopyPasteDelegator;
    private final MyDeletePSIElementProvider myDeletePSIElementProvider;
    private final ModuleDeleteProvider myDeleteModuleProvider;
    private final DependencyValidationManager myDependencyValidationManager;
    private final WolfTheProblemSolver.ProblemListener myProblemListener;
    private final FileStatusListener myFileStatusListener;
    private final MergingUpdateQueue myUpdateQueue;
    private final MyChangesListListener myChangesListListener;
    protected ActionCallback myActionCallback;

    public ScopeTreeViewPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scopeView/ScopeTreeViewPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myIdeView = new MyIdeView();
        this.myPsiTreeChangeAdapter = new MyPsiTreeChangeAdapter();
        this.myTree = new JBTreeWithHintProvider(){

            public boolean isFileColorsEnabled() {
                return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
            }

            @Nullable
            public Color getFileColorFor(DefaultMutableTreeNode node) {
                if (!(node instanceof PackageDependenciesNode)) {
                    return null;
                }
                return ProjectViewTree.getColorForObject(((PackageDependenciesNode)node).getPsiElement(), ScopeTreeViewPanel.this.myProject, FunctionUtil.id());
            }
        };
        this.myDeletePSIElementProvider = new MyDeletePSIElementProvider();
        this.myDeleteModuleProvider = new ModuleDeleteProvider();
        this.myProblemListener = new MyProblemListener();
        this.myFileStatusListener = new FileStatusListener(){

            public void fileStatusesChanged() {
                List treePaths = TreeUtil.collectExpandedPaths((JTree)((Object)ScopeTreeViewPanel.this.myTree));
                for (TreePath treePath : treePaths) {
                    Object component = treePath.getLastPathComponent();
                    if (!(component instanceof PackageDependenciesNode)) continue;
                    ((PackageDependenciesNode)component).updateColor();
                    for (int i = 0; i < ((PackageDependenciesNode)component).getChildCount(); ++i) {
                        ((PackageDependenciesNode)((PackageDependenciesNode)component).getChildAt(i)).updateColor();
                    }
                }
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                NamedScope currentScope;
                PackageSet value;
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ide/scopeView/ScopeTreeViewPanel$2", "fileStatusChanged"));
                }
                if (!virtualFile.isValid()) {
                    return;
                }
                PsiFile file = PsiManager.getInstance((Project)ScopeTreeViewPanel.this.myProject).findFile(virtualFile);
                if (file != null && (value = (currentScope = ScopeTreeViewPanel.this.getCurrentScope()).getValue()) != null && value.contains(file, NamedScopesHolder.getHolder((Project)ScopeTreeViewPanel.this.myProject, (String)currentScope.getName(), (NamedScopesHolder)ScopeTreeViewPanel.this.myDependencyValidationManager))) {
                    if (!ScopeTreeViewPanel.this.myBuilder.hasFileNode(virtualFile)) {
                        return;
                    }
                    PackageDependenciesNode node = ScopeTreeViewPanel.this.myBuilder.getFileParentNode(virtualFile);
                    PackageDependenciesNode[] nodes = FileTreeModelBuilder.findNodeForPsiElement(node, (PsiElement)file);
                    if (nodes != null) {
                        for (PackageDependenciesNode dependenciesNode : nodes) {
                            dependenciesNode.updateColor();
                        }
                    }
                }
            }
        };
        this.myUpdateQueue = new MergingUpdateQueue("ScopeViewUpdate", 300, this.isTreeShowing(), (JComponent)((Object)this.myTree));
        this.myChangesListListener = new MyChangesListListener();
        this.myUpdateQueue.setPassThrough(false);
        this.myProject = project;
        this.initTree();
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree)), "Center");
        this.myDependencyValidationManager = DependencyValidationManager.getInstance((Project)this.myProject);
        UiNotifyConnector uiNotifyConnector = new UiNotifyConnector((Component)((Object)this.myTree), (Activatable)this.myUpdateQueue);
        Disposer.register((Disposable)this, (Disposable)this.myUpdateQueue);
        Disposer.register((Disposable)this, (Disposable)uiNotifyConnector);
        if (this.isTreeShowing()) {
            this.myUpdateQueue.showNotify();
        }
    }

    public void initListeners() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyModuleRootListener());
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeAdapter);
        WolfTheProblemSolver.getInstance((Project)this.myProject).addProblemListener(this.myProblemListener);
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)this.myChangesListListener);
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener(this.myFileStatusListener, (Disposable)this.myProject);
    }

    public void dispose() {
        FileTreeModelBuilder.clearCaches(this.myProject);
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeAdapter);
        WolfTheProblemSolver.getInstance((Project)this.myProject).removeProblemListener(this.myProblemListener);
        ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener((ChangeListListener)this.myChangesListListener);
    }

    public void selectNode(final PsiElement element, final PsiFileSystemItem file, final boolean requestFocus) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScopeTreeViewPanel.this.myUpdateQueue.queue(new Update("Select"){

                    public void run() {
                        if (ScopeTreeViewPanel.this.myProject.isDisposed()) {
                            return;
                        }
                        PackageDependenciesNode node = ScopeTreeViewPanel.this.myBuilder.findNode(file, element);
                        if (node != null && node.getPsiElement() != element) {
                            TreePath path = new TreePath(node.getPath());
                            if (ScopeTreeViewPanel.this.myTree.isCollapsed(path)) {
                                ScopeTreeViewPanel.this.myTree.expandPath(path);
                                ScopeTreeViewPanel.this.myTree.makeVisible(path);
                            }
                        }
                        if ((node = ScopeTreeViewPanel.this.myBuilder.findNode(file, element)) != null) {
                            TreeUtil.selectPath((JTree)((Object)ScopeTreeViewPanel.this.myTree), (TreePath)new TreePath(node.getPath()));
                            if (requestFocus) {
                                ScopeTreeViewPanel.this.myTree.requestFocus();
                            }
                        }
                    }
                });
            }
        };
        this.doWhenDone(runnable);
    }

    private void doWhenDone(Runnable runnable) {
        if (this.myActionCallback == null || ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            this.myActionCallback.doWhenDone(runnable);
        }
    }

    public void selectScope(NamedScope scope) {
        this.refreshScope(scope);
        if (scope != CustomScopesProviderEx.getAllScope() && scope != null) {
            this.CURRENT_SCOPE_NAME = scope.getName();
        }
    }

    public JPanel getPanel() {
        return this;
    }

    private void initTree() {
        ScopeTreeStructureExpander[] extensions;
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)((Object)this.myTree));
        TreeUtil.installActions((JTree)((Object)this.myTree));
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        new TreeSpeedSearch((JTree)((Object)this.myTree));
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                PsiElement[] psiElementArray = ScopeTreeViewPanel.this.getSelectedPsiElements();
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeTreeViewPanel$4", "getSelectedElements"));
                }
                return psiElementArray;
            }
        };
        this.myTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)((Object)this.myTree), this.myProject);
        for (ScopeTreeStructureExpander expander : extensions = (ScopeTreeStructureExpander[])Extensions.getExtensions(ScopeTreeStructureExpander.EP_NAME, (AreaInstance)this.myProject)) {
            this.myTree.addTreeWillExpandListener(expander);
        }
        if (extensions.length == 0) {
            this.myTree.addTreeWillExpandListener(new SortingExpandListener());
        }
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                DefaultMutableTreeNode selectedNode;
                Object component;
                if (10 == e.getKeyCode() && (component = ScopeTreeViewPanel.this.myTree.getLastSelectedPathComponent()) instanceof DefaultMutableTreeNode && (selectedNode = (DefaultMutableTreeNode)component).isLeaf()) {
                    OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)((Object)ScopeTreeViewPanel.this.myTree)), (boolean)false);
                }
            }
        });
    }

    @NotNull
    private PsiElement[] getSelectedPsiElements() {
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null) {
            HashSet result2 = new HashSet();
            for (TreePath path : treePaths) {
                PackageDependenciesNode node;
                PsiElement psiElement;
                Object component = path.getLastPathComponent();
                if (!(component instanceof PackageDependenciesNode) || (psiElement = (node = (PackageDependenciesNode)component).getPsiElement()) == null || !psiElement.isValid()) continue;
                result2.add(psiElement);
            }
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)result2);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeTreeViewPanel", "getSelectedPsiElements"));
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeTreeViewPanel", "getSelectedPsiElements"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public void refreshScope(@Nullable NamedScope scope) {
        FileTreeModelBuilder.clearCaches(this.myProject);
        if (scope == null) {
            scope = CustomScopesProviderEx.getAllScope();
        }
        LOG.assertTrue(scope != null);
        final NamedScopesHolder holder = NamedScopesHolder.getHolder((Project)this.myProject, (String)scope.getName(), (NamedScopesHolder)this.myDependencyValidationManager);
        final PackageSet packageSet = scope.getValue() != null ? scope.getValue() : new InvalidPackageSet("");
        DependenciesPanel.DependencyPanelSettings settings = new DependenciesPanel.DependencyPanelSettings();
        settings.UI_FILTER_LEGALS = true;
        settings.UI_GROUP_BY_SCOPE_TYPE = false;
        settings.UI_SHOW_FILES = true;
        ProjectView projectView = ProjectView.getInstance(this.myProject);
        settings.UI_FLATTEN_PACKAGES = projectView.isFlattenPackages("Scope");
        settings.UI_COMPACT_EMPTY_MIDDLE_PACKAGES = projectView.isHideEmptyMiddlePackages("Scope");
        settings.UI_SHOW_MODULES = projectView.isShowModules("Scope");
        settings.UI_SHOW_MODULE_GROUPS = projectView.isShowModules("Scope");
        this.myBuilder = new FileTreeModelBuilder(this.myProject, new Marker(){

            @Override
            public boolean isMarked(VirtualFile file) {
                return packageSet != null && (packageSet instanceof PackageSetBase ? ((PackageSetBase)packageSet).contains(file, ScopeTreeViewPanel.this.myProject, holder) : packageSet.contains(PackageSetBase.getPsiFile((VirtualFile)file, (Project)ScopeTreeViewPanel.this.myProject), holder));
            }
        }, settings);
        this.myTree.setPaintBusy(true);
        this.myBuilder.setTree(this.myTree);
        this.myTree.getEmptyText().setText("Loading...");
        this.myActionCallback = new ActionCallback();
        this.myTree.putClientProperty("Callback", new WeakReference<ActionCallback>(this.myActionCallback));
        this.myTree.setModel(this.myBuilder.build(this.myProject, true, new Runnable(){

            @Override
            public void run() {
                ScopeTreeViewPanel.this.myTree.setPaintBusy(false);
                ScopeTreeViewPanel.this.myTree.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                ScopeTreeViewPanel.this.myActionCallback.setDone();
            }
        }));
        ((PackageDependenciesNode)this.myTree.getModel().getRoot()).sortChildren();
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        FileTreeModelBuilder.clearCaches(this.myProject);
    }

    protected NamedScope getCurrentScope() {
        NamedScope scope = NamedScopesHolder.getScope((Project)this.myProject, (String)this.CURRENT_SCOPE_NAME);
        if (scope == null) {
            scope = CustomScopesProviderEx.getAllScope();
        }
        LOG.assertTrue(scope != null);
        return scope;
    }

    @Nullable
    public Object getData(String dataId) {
        Object pathComponent;
        TreePath selectionPath;
        PackageDependenciesNode node;
        TreePath selectionPath2;
        if (LangDataKeys.MODULE_CONTEXT.is(dataId) && (selectionPath2 = this.myTree.getSelectionPath()) != null && (node = (PackageDependenciesNode)selectionPath2.getLastPathComponent()) instanceof ModuleNode) {
            return ((ModuleNode)node).getModule();
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId) && (selectionPath2 = this.myTree.getSelectionPath()) != null) {
            node = (PackageDependenciesNode)selectionPath2.getLastPathComponent();
            return node != null && node.isValid() ? node.getPsiElement() : null;
        }
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null && LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            HashSet psiElements = new HashSet();
            for (TreePath treePath : treePaths) {
                PsiElement psiElement;
                PackageDependenciesNode node2 = (PackageDependenciesNode)treePath.getLastPathComponent();
                if (!node2.isValid() || (psiElement = node2.getPsiElement()) == null) continue;
                psiElements.add(psiElement);
            }
            return psiElements.isEmpty() ? null : PsiUtilCore.toPsiElementArray((Collection)psiElements);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            if (this.getSelectedModules() != null) {
                return this.myDeleteModuleProvider;
            }
            return this.myDeletePSIElementProvider;
        }
        if (LangDataKeys.PASTE_TARGET_PSI_ELEMENT.is(dataId) && (selectionPath = this.myTree.getSelectionPath()) != null && (pathComponent = selectionPath.getLastPathComponent()) instanceof DirectoryNode) {
            return ((DirectoryNode)pathComponent).getTargetDirectory();
        }
        return null;
    }

    @Nullable
    private Module[] getSelectedModules() {
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null) {
            HashSet result2 = new HashSet();
            for (TreePath path : treePaths) {
                PackageDependenciesNode node = (PackageDependenciesNode)path.getLastPathComponent();
                if (node instanceof ModuleNode) {
                    result2.add(((ModuleNode)node).getModule());
                    continue;
                }
                if (!(node instanceof ModuleGroupNode)) continue;
                ModuleGroupNode groupNode = (ModuleGroupNode)node;
                ModuleGroup moduleGroup = groupNode.getModuleGroup();
                result2.addAll(moduleGroup.modulesInGroup(this.myProject, true));
            }
            return result2.isEmpty() ? null : result2.toArray(new Module[result2.size()]);
        }
        return null;
    }

    private void reload(final @Nullable DefaultMutableTreeNode rootToReload) {
        final DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        if (rootToReload != null && rootToReload != treeModel.getRoot()) {
            final List treePaths = TreeUtil.collectExpandedPaths((JTree)((Object)this.myTree), (TreePath)new TreePath(rootToReload.getPath()));
            final List selectionPaths = TreeUtil.collectSelectedPaths((JTree)((Object)this.myTree), (TreePath)new TreePath(rootToReload.getPath()));
            final TreePath path = new TreePath(rootToReload.getPath());
            final boolean wasCollapsed = this.myTree.isCollapsed(path);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!ScopeTreeViewPanel.this.isTreeShowing() || rootToReload.getParent() == null) {
                        return;
                    }
                    TreeUtil.sort((DefaultMutableTreeNode)rootToReload, (Comparator)ScopeTreeViewPanel.this.getNodeComparator());
                    treeModel.reload(rootToReload);
                    if (!wasCollapsed) {
                        ScopeTreeViewPanel.this.myTree.collapsePath(path);
                        for (TreePath treePath : treePaths) {
                            ScopeTreeViewPanel.this.myTree.expandPath(treePath);
                        }
                        for (TreePath selectionPath : selectionPaths) {
                            TreeUtil.selectPath((JTree)((Object)ScopeTreeViewPanel.this.myTree), (TreePath)selectionPath);
                        }
                    }
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        } else {
            TreeUtil.sort((DefaultTreeModel)treeModel, (Comparator)this.getNodeComparator());
            treeModel.reload();
        }
    }

    private DependencyNodeComparator getNodeComparator() {
        return new DependencyNodeComparator(ProjectView.getInstance(this.myProject).isSortByType("Scope"));
    }

    public void setSortByType() {
        this.myTreeExpansionMonitor.freeze();
        this.reload(null);
        this.myTreeExpansionMonitor.restore();
    }

    ActionCallback getActionCallback() {
        return this.myActionCallback;
    }

    public DnDAwareTree getTree() {
        return this.myTree;
    }

    private void addNode(VirtualFile file, String scopeName) {
        this.queueUpdate(file, new Function<PsiFile, DefaultMutableTreeNode>(){

            @Nullable
            public DefaultMutableTreeNode fun(PsiFile psiFile) {
                return ScopeTreeViewPanel.this.myBuilder.addFileNode(psiFile);
            }
        }, scopeName);
    }

    private void removeNode(VirtualFile file, String scopeName) {
        this.queueUpdate(file, new Function<PsiFile, DefaultMutableTreeNode>(){

            @Nullable
            public DefaultMutableTreeNode fun(PsiFile psiFile) {
                return ScopeTreeViewPanel.this.myBuilder.removeNode((PsiElement)psiFile, psiFile.getContainingDirectory());
            }
        }, scopeName);
    }

    private void queueUpdate(final VirtualFile fileToRefresh, final Function<PsiFile, DefaultMutableTreeNode> rootToReloadGetter, String scopeName) {
        if (this.myProject.isDisposed()) {
            return;
        }
        AbstractProjectViewPane pane = ProjectView.getInstance(this.myProject).getCurrentProjectViewPane();
        if (pane == null || !"Scope".equals(pane.getId()) || !scopeName.equals(pane.getSubId())) {
            return;
        }
        this.myUpdateQueue.queue(new Update(fileToRefresh){

            public void run() {
                if (ScopeTreeViewPanel.this.myProject.isDisposed() || !fileToRefresh.isValid()) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)ScopeTreeViewPanel.this.myProject).findFile(fileToRefresh);
                if (psiFile != null) {
                    ScopeTreeViewPanel.this.reload((DefaultMutableTreeNode)rootToReloadGetter.fun((Object)psiFile));
                }
            }

            public boolean isExpired() {
                return !ScopeTreeViewPanel.this.isTreeShowing();
            }
        });
    }

    private boolean isTreeShowing() {
        return this.myTree.isShowing() || ApplicationManager.getApplication().isUnitTestMode();
    }

    private class SortingExpandListener
    implements TreeWillExpandListener {
        private SortingExpandListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            if (path == null) {
                return;
            }
            PackageDependenciesNode node = (PackageDependenciesNode)path.getLastPathComponent();
            node.sortChildren();
            ((DefaultTreeModel)ScopeTreeViewPanel.this.myTree.getModel()).reload(node);
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }
    }

    private class MyChangesListListener
    extends ChangeListAdapter {
        private MyChangesListListener() {
        }

        public void changeListAdded(ChangeList list) {
            this.fireListeners(list, null);
        }

        public void changeListRemoved(ChangeList list) {
            this.fireListeners(list, null);
        }

        public void changeListRenamed(ChangeList list, String oldName) {
            this.fireListeners(list, oldName);
        }

        private void fireListeners(ChangeList list, @Nullable String oldName) {
            AbstractProjectViewPane pane = ProjectView.getInstance(ScopeTreeViewPanel.this.myProject).getCurrentProjectViewPane();
            if (pane == null || !"Scope".equals(pane.getId())) {
                return;
            }
            String subId = pane.getSubId();
            if (!(list.getName().equals(subId) || oldName != null && oldName.equals(subId))) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScopeTreeViewPanel.this.myDependencyValidationManager.fireScopeListeners();
                }
            }, ScopeTreeViewPanel.this.myProject.getDisposed());
        }

        public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
            String name = fromList.getName();
            HashSet files = new HashSet();
            this.collectFiles(changes, (Set<VirtualFile>)files);
            for (VirtualFile file : files) {
                ScopeTreeViewPanel.this.removeNode(file, name);
            }
        }

        public void changesAdded(Collection<Change> changes, ChangeList toList) {
            String name = toList.getName();
            HashSet files = new HashSet();
            this.collectFiles(changes, (Set<VirtualFile>)files);
            for (VirtualFile file : files) {
                ScopeTreeViewPanel.this.addNode(file, name);
            }
        }

        private void collectFiles(Collection<Change> changes, Set<VirtualFile> files) {
            for (Change change : changes) {
                VirtualFile virtualFile;
                ContentRevision afterRevision = change.getAfterRevision();
                if (afterRevision == null || (virtualFile = afterRevision.getFile().getVirtualFile()) == null) continue;
                files.add(virtualFile);
            }
        }
    }

    private class MyProblemListener
    extends WolfTheProblemSolver.ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyProblemListener", "problemsAppeared"));
            }
            ScopeTreeViewPanel.this.addNode(file, DefaultScopesProvider.getInstance(ScopeTreeViewPanel.this.myProject).getProblemsScope().getName());
        }

        public void problemsDisappeared(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyProblemListener", "problemsDisappeared"));
            }
            ScopeTreeViewPanel.this.removeNode(file, DefaultScopesProvider.getInstance(ScopeTreeViewPanel.this.myProject).getProblemsScope().getName());
        }
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyDeletePSIElementProvider", "canDeleteElement"));
            }
            PsiElement[] elements = ScopeTreeViewPanel.this.getSelectedPsiElements();
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyDeletePSIElementProvider", "deleteElement"));
            }
            List<PsiElement> allElements = Arrays.asList(ScopeTreeViewPanel.this.getSelectedPsiElements());
            ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
            for (PsiElement psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, ScopeTreeViewPanel.this.myProject);
            }
            finally {
                a.finish();
            }
        }
    }

    private class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element) {
            if (element != null) {
                Editor editor;
                VirtualFile virtualFile;
                PackageSet packageSet = ScopeTreeViewPanel.this.getCurrentScope().getValue();
                PsiFile psiFile = element.getContainingFile();
                if (packageSet == null) {
                    return;
                }
                Object object = psiFile != null ? psiFile.getVirtualFile() : (virtualFile = element instanceof PsiDirectory ? ((PsiDirectory)element).getVirtualFile() : null);
                if (virtualFile != null) {
                    ProjectView projectView = ProjectView.getInstance(ScopeTreeViewPanel.this.myProject);
                    NamedScopesHolder holder = NamedScopesHolder.getHolder((Project)ScopeTreeViewPanel.this.myProject, (String)ScopeTreeViewPanel.this.CURRENT_SCOPE_NAME, (NamedScopesHolder)ScopeTreeViewPanel.this.myDependencyValidationManager);
                    if (packageSet instanceof PackageSetBase && !((PackageSetBase)packageSet).contains(virtualFile, ScopeTreeViewPanel.this.myProject, holder) || psiFile != null && !packageSet.contains(psiFile, holder)) {
                        projectView.changeView("ProjectPane");
                    }
                    projectView.select(element, virtualFile, false);
                }
                if ((editor = EditorHelper.openInEditor(element)) != null) {
                    ToolWindowManager.getInstance((Project)ScopeTreeViewPanel.this.myProject).activateEditorComponent();
                }
            }
        }

        @Nullable
        private PsiDirectory getDirectory() {
            TreePath[] selectedPaths = ScopeTreeViewPanel.this.myTree.getSelectionPaths();
            if (selectedPaths != null) {
                if (selectedPaths.length != 1) {
                    return null;
                }
                TreePath path = selectedPaths[0];
                PackageDependenciesNode node = (PackageDependenciesNode)path.getLastPathComponent();
                if (!node.isValid()) {
                    return null;
                }
                if (node instanceof DirectoryNode) {
                    return (PsiDirectory)node.getPsiElement();
                }
                if (node instanceof BasePsiNode) {
                    PsiElement psiElement = node.getPsiElement();
                    LOG.assertTrue(psiElement != null);
                    PsiFile psiFile = psiElement.getContainingFile();
                    LOG.assertTrue(psiFile != null);
                    return psiFile.getContainingDirectory();
                }
                if (node instanceof FileNode) {
                    PsiFile psiFile = (PsiFile)node.getPsiElement();
                    LOG.assertTrue(psiFile != null);
                    return psiFile.getContainingDirectory();
                }
            }
            return null;
        }

        @NotNull
        public PsiDirectory[] getDirectories() {
            PsiDirectory[] psiDirectoryArray;
            PsiDirectory directory = this.getDirectory();
            if (directory == null) {
                psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
            } else {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = directory;
            }
            if (psiDirectoryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyIdeView", "getDirectories"));
            }
            return psiDirectoryArray;
        }

        @Nullable
        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }
    }

    private class MyModuleRootListener
    extends ModuleRootAdapter {
        private MyModuleRootListener() {
        }

        public void rootsChanged(ModuleRootEvent event) {
            ScopeTreeViewPanel.this.myUpdateQueue.cancelAllUpdates();
            ScopeTreeViewPanel.this.myUpdateQueue.queue(new Update("RootsChanged"){

                public void run() {
                    ScopeTreeViewPanel.this.refreshScope(ScopeTreeViewPanel.this.getCurrentScope());
                }

                public boolean isExpired() {
                    return !ScopeTreeViewPanel.this.isTreeShowing();
                }
            });
        }
    }

    private class MyPsiTreeChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeAdapter() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyPsiTreeChangeAdapter", "childAdded"));
            }
            PsiElement element = event.getParent();
            final PsiElement child = event.getChild();
            if (child == null) {
                return;
            }
            if (element.getContainingFile() == null) {
                this.queueUpdate(new Runnable(){

                    @Override
                    public void run() {
                        if (!child.isValid()) {
                            return;
                        }
                        MyPsiTreeChangeAdapter.this.processNodeCreation(child);
                    }
                }, false);
            }
        }

        private void processNodeCreation(PsiElement psiElement) {
            if (psiElement instanceof PsiFile && !this.isInjected((PsiFile)psiElement)) {
                PackageDependenciesNode rootToReload = ScopeTreeViewPanel.this.myBuilder.addFileNode((PsiFile)psiElement);
                if (rootToReload != null) {
                    ScopeTreeViewPanel.this.reload(rootToReload);
                }
            } else if (psiElement instanceof PsiDirectory) {
                PsiElement[] children = psiElement.getChildren();
                if (children.length > 0) {
                    this.queueRefreshScope(ScopeTreeViewPanel.this.getCurrentScope(), (PsiDirectory)psiElement);
                } else {
                    PackageDependenciesNode node = ScopeTreeViewPanel.this.myBuilder.addDirNode((PsiDirectory)psiElement);
                    if (node != null) {
                        ScopeTreeViewPanel.this.reload((DefaultMutableTreeNode)node.getParent());
                    }
                }
            }
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyPsiTreeChangeAdapter", "beforeChildRemoval"));
            }
            final PsiElement child = event.getChild();
            final PsiElement parent = event.getParent();
            if (parent instanceof PsiDirectory && (child instanceof PsiFile && !this.isInjected((PsiFile)child) || child instanceof PsiDirectory)) {
                this.queueUpdate(new Runnable(){

                    @Override
                    public void run() {
                        DefaultMutableTreeNode rootToReload = ScopeTreeViewPanel.this.myBuilder.removeNode(child, (PsiDirectory)parent);
                        if (rootToReload != null) {
                            ScopeTreeViewPanel.this.reload(rootToReload);
                        }
                    }
                }, true);
            }
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyPsiTreeChangeAdapter", "beforeChildMovement"));
            }
            final PsiElement oldParent = event.getOldParent();
            final PsiElement child = event.getChild();
            if (oldParent instanceof PsiDirectory && child instanceof PsiFileSystemItem && (!(child instanceof PsiFile) || !this.isInjected((PsiFile)child))) {
                this.queueUpdate(new Runnable(){

                    @Override
                    public void run() {
                        DefaultMutableTreeNode rootToReload = ScopeTreeViewPanel.this.myBuilder.removeNode(child, child instanceof PsiDirectory ? (PsiDirectory)child : (PsiDirectory)oldParent);
                        if (rootToReload != null) {
                            ScopeTreeViewPanel.this.reload(rootToReload);
                        }
                    }
                }, true);
            }
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyPsiTreeChangeAdapter", "childMoved"));
            }
            PsiElement newParent = event.getNewParent();
            PsiElement child = event.getChild();
            if (newParent instanceof PsiDirectory && child instanceof PsiFileSystemItem && (!(child instanceof PsiFile) || !this.isInjected((PsiFile)child))) {
                final PsiFileSystemItem file = (PsiFileSystemItem)child;
                this.queueUpdate(new Runnable(){

                    @Override
                    public void run() {
                        VirtualFile virtualFile = file.getVirtualFile();
                        if (virtualFile != null && virtualFile.isValid()) {
                            PsiFileSystemItem newFile;
                            Object object = file.isValid() ? file : (newFile = file.isDirectory() ? PsiManager.getInstance((Project)ScopeTreeViewPanel.this.myProject).findDirectory(virtualFile) : PsiManager.getInstance((Project)ScopeTreeViewPanel.this.myProject).findFile(virtualFile));
                            if (newFile != null) {
                                PackageDependenciesNode rootToReload;
                                PackageDependenciesNode packageDependenciesNode = rootToReload = newFile.isDirectory() ? ScopeTreeViewPanel.this.myBuilder.addDirNode((PsiDirectory)newFile) : ScopeTreeViewPanel.this.myBuilder.addFileNode((PsiFile)newFile);
                                if (rootToReload != null) {
                                    ScopeTreeViewPanel.this.reload(rootToReload);
                                }
                            }
                        }
                    }
                }, true);
            }
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyPsiTreeChangeAdapter", "childrenChanged"));
            }
            PsiElement parent = event.getParent();
            final PsiFile file = parent.getContainingFile();
            if (file != null && file.getFileType() == StdFileTypes.JAVA) {
                if (!file.getViewProvider().isPhysical() && !this.isInjected(file)) {
                    return;
                }
                this.queueUpdate(new Runnable(){

                    @Override
                    public void run() {
                        if (file.isValid() && file.getViewProvider().isPhysical()) {
                            NamedScope scope = ScopeTreeViewPanel.this.getCurrentScope();
                            PackageSet packageSet = scope.getValue();
                            if (packageSet == null) {
                                return;
                            }
                            if (packageSet.contains(file, NamedScopesHolder.getHolder((Project)ScopeTreeViewPanel.this.myProject, (String)scope.getName(), (NamedScopesHolder)ScopeTreeViewPanel.this.myDependencyValidationManager))) {
                                ScopeTreeViewPanel.this.reload(ScopeTreeViewPanel.this.myBuilder.getFileParentNode(file.getVirtualFile()));
                            }
                        }
                    }
                }, false);
            }
        }

        public final void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyPsiTreeChangeAdapter", "propertyChanged"));
            }
            String propertyName = event.getPropertyName();
            final PsiElement element = event.getElement();
            if (element != null) {
                PackageSet value;
                final NamedScope scope = ScopeTreeViewPanel.this.getCurrentScope();
                if (propertyName.equals("fileName") || propertyName.equals("propFileTypes")) {
                    this.queueUpdate(new Runnable(){

                        @Override
                        public void run() {
                            if (element.isValid()) {
                                MyPsiTreeChangeAdapter.this.processRenamed(scope, element.getContainingFile());
                            }
                        }
                    }, false);
                } else if (propertyName.equals("directoryName") && (!((value = ScopeTreeViewPanel.this.getCurrentScope().getValue()) instanceof PackageSetBase) || ((PackageSetBase)value).contains(((PsiDirectory)element).getVirtualFile(), ScopeTreeViewPanel.this.myProject, (NamedScopesHolder)ScopeTreeViewPanel.this.myDependencyValidationManager))) {
                    this.queueRefreshScope(scope, (PsiDirectory)element);
                }
            }
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyPsiTreeChangeAdapter", "childReplaced"));
            }
            final NamedScope scope = ScopeTreeViewPanel.this.getCurrentScope();
            PsiElement element = event.getNewChild();
            final PsiFile psiFile = event.getFile();
            if (psiFile != null && !this.isInjected(psiFile)) {
                if (psiFile.getLanguage() == psiFile.getViewProvider().getBaseLanguage()) {
                    this.queueUpdate(new Runnable(){

                        @Override
                        public void run() {
                            MyPsiTreeChangeAdapter.this.processRenamed(scope, psiFile);
                        }
                    }, false);
                }
            } else if (element instanceof PsiDirectory && element.isValid()) {
                this.queueRefreshScope(scope, (PsiDirectory)element);
            }
        }

        private boolean isInjected(PsiFile psiFile) {
            return InjectedLanguageManager.getInstance((Project)ScopeTreeViewPanel.this.myProject).isInjectedFragment(psiFile);
        }

        private void queueRefreshScope(final NamedScope scope, final PsiDirectory dir) {
            ScopeTreeViewPanel.this.myUpdateQueue.cancelAllUpdates();
            this.queueUpdate(new Runnable(){

                @Override
                public void run() {
                    ScopeTreeViewPanel.this.myTreeExpansionMonitor.freeze();
                    ScopeTreeViewPanel.this.refreshScope(scope);
                    ScopeTreeViewPanel.this.doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            ScopeTreeViewPanel.this.myTreeExpansionMonitor.restore();
                            PackageDependenciesNode dirNode = ScopeTreeViewPanel.this.myBuilder.findNode((PsiFileSystemItem)dir, (PsiElement)dir);
                            if (dirNode != null) {
                                TreeUtil.selectPath((JTree)((Object)ScopeTreeViewPanel.this.myTree), (TreePath)new TreePath(dirNode.getPath()));
                            }
                        }
                    });
                }
            }, false);
        }

        private void processRenamed(NamedScope scope, PsiFile file) {
            if (!file.isValid() || !file.getViewProvider().isPhysical()) {
                return;
            }
            PackageSet packageSet = scope.getValue();
            if (packageSet == null) {
                return;
            }
            if (packageSet.contains(file, NamedScopesHolder.getHolder((Project)ScopeTreeViewPanel.this.myProject, (String)scope.getName(), (NamedScopesHolder)ScopeTreeViewPanel.this.myDependencyValidationManager))) {
                ScopeTreeViewPanel.this.reload(ScopeTreeViewPanel.this.myBuilder.addFileNode(file));
            } else {
                DefaultMutableTreeNode rootToReload = ScopeTreeViewPanel.this.myBuilder.removeNode((PsiElement)file, file.getParent());
                if (rootToReload != null) {
                    ScopeTreeViewPanel.this.reload(rootToReload);
                }
            }
        }

        private void queueUpdate(final Runnable request, boolean updateImmediately) {
            final Runnable wrapped = new Runnable(){

                @Override
                public void run() {
                    if (ScopeTreeViewPanel.this.myProject.isDisposed()) {
                        return;
                    }
                    request.run();
                }
            };
            if (updateImmediately && ScopeTreeViewPanel.this.isTreeShowing()) {
                ScopeTreeViewPanel.this.myUpdateQueue.run(new Update(request){

                    public void run() {
                        wrapped.run();
                    }
                });
            } else {
                ScopeTreeViewPanel.this.myUpdateQueue.queue(new Update(request){

                    public void run() {
                        wrapped.run();
                    }

                    public boolean isExpired() {
                        return !ScopeTreeViewPanel.this.isTreeShowing();
                    }
                });
            }
        }
    }

    private class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private WolfTheProblemSolver myWolfTheProblemSolver;

        private MyTreeCellRenderer() {
            this.myWolfTheProblemSolver = WolfTheProblemSolver.getInstance((Project)ScopeTreeViewPanel.this.myProject);
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof PackageDependenciesNode) {
                String locationString;
                PackageDependenciesNode node = (PackageDependenciesNode)value;
                try {
                    this.setIcon(node.getIcon());
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                SimpleTextAttributes regularAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                TextAttributes textAttributes = regularAttributes.toTextAttributes();
                if (node instanceof BasePsiNode && ((BasePsiNode)node).isDeprecated()) {
                    textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.DEPRECATED_ATTRIBUTES).clone();
                }
                PsiElement psiElement = node.getPsiElement();
                textAttributes.setForegroundColor(CopyPasteManager.getInstance().isCutElement((Object)psiElement) ? CopyPasteManager.CUT_COLOR : node.getColor());
                if (ScopeTreeViewPanel.this.getCurrentScope() != DefaultScopesProvider.getInstance(ScopeTreeViewPanel.this.myProject).getProblemsScope()) {
                    boolean isProblem;
                    PsiFile containingFile = psiElement != null ? psiElement.getContainingFile() : null;
                    ProjectViewNodeDecorator[] virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
                    if (containingFile != null) {
                        isProblem = this.myWolfTheProblemSolver.isProblemFile((VirtualFile)virtualFile);
                    } else if (virtualFile != null) {
                        isProblem = this.myWolfTheProblemSolver.hasProblemFilesBeneath((Condition)new Condition<VirtualFile>((VirtualFile)virtualFile){
                            final /* synthetic */ VirtualFile val$virtualFile;
                            {
                                this.val$virtualFile = virtualFile;
                            }

                            public boolean value(VirtualFile file) {
                                return VfsUtilCore.isAncestor((VirtualFile)this.val$virtualFile, (VirtualFile)file, (boolean)false);
                            }
                        });
                    } else {
                        Module module = node instanceof ModuleNode ? ((ModuleNode)node).getModule() : null;
                        boolean bl = isProblem = module != null && this.myWolfTheProblemSolver.hasProblemFilesBeneath(module);
                    }
                    if (isProblem) {
                        textAttributes.setEffectColor((Color)JBColor.RED);
                        textAttributes.setEffectType(EffectType.WAVE_UNDERSCORE);
                    }
                }
                this.append(node.toString(), SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes));
                String oldToString = this.toString();
                if (!ScopeTreeViewPanel.this.myProject.isDisposed()) {
                    for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)ScopeTreeViewPanel.this.myProject)) {
                        decorator.decorate(node, this);
                    }
                }
                if (this.toString().equals(oldToString) && (locationString = node.getComment()) != null && locationString.length() > 0) {
                    this.append(" (" + locationString + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }
    }
}

