/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApplicationUtil {
    public static <T> T tryRunReadAction(final @NotNull Computable<T> computable) throws CannotRunReadActionException {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/application/ex/ApplicationUtil", "tryRunReadAction"));
        }
        final Ref result2 = new Ref();
        if (((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(new Runnable(){

            @Override
            public void run() {
                result2.set(computable.compute());
            }
        })) {
            return (T)result2.get();
        }
        throw new CannotRunReadActionException();
    }

    public static void tryRunReadAction(@NotNull Runnable computable) throws CannotRunReadActionException {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/application/ex/ApplicationUtil", "tryRunReadAction"));
        }
        if (!((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(computable)) {
            throw new CannotRunReadActionException();
        }
    }

    public static <T> T runWithCheckCanceled(@NotNull Callable<T> callable, @NotNull ProgressIndicator indicator) throws Exception {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        return ApplicationUtil.runWithCheckCanceled(callable, indicator, PooledThreadExecutor.INSTANCE);
    }

    public static <T> T runWithCheckCanceled(final @NotNull Callable<T> callable, final @NotNull ProgressIndicator indicator, @NotNull ExecutorService executorService) throws Exception {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        if (executorService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorService", "com/intellij/openapi/application/ex/ApplicationUtil", "runWithCheckCanceled"));
        }
        final Ref result2 = Ref.create();
        final Ref error = Ref.create();
        Future<?> future2 = executorService.submit(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            result2.set(callable.call());
                        }
                        catch (Throwable t) {
                            error.set((Object)t);
                        }
                    }
                }, indicator);
            }
        });
        while (true) {
            try {
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                future2.cancel(true);
                throw e;
            }
            try {
                future2.get(200L, TimeUnit.MILLISECONDS);
                ExceptionUtil.rethrowAll((Throwable)((Throwable)error.get()));
                return (T)result2.get();
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    public static class CannotRunReadActionException
    extends RuntimeException {
        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

