/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.ApplyTextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.CustomBinaryPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PathMerger;
import com.intellij.openapi.diff.impl.patch.formove.PathsVerifier;
import com.intellij.openapi.diff.impl.patch.formove.TriggerAdditionOrDeletion;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchAction;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchApplier<BinaryType extends FilePatch> {
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    private final List<FilePatch> myPatches;
    private final CustomBinaryPatchApplier<BinaryType> myCustomForBinaries;
    private final CommitContext myCommitContext;
    private final Consumer<Collection<FilePath>> myToTargetListsMover;
    private final List<FilePatch> myRemainingPatches;
    private final PathsVerifier<BinaryType> myVerifier;
    private boolean mySystemOperation;
    private final boolean myReverseConflict;
    @Nullable
    private final String myLeftConflictPanelTitle;
    @Nullable
    private final String myRightConflictPanelTitle;

    public PatchApplier(@NotNull Project project, VirtualFile baseDirectory, List<FilePatch> patches, @Nullable Consumer<Collection<FilePath>> toTargetListsMover, CustomBinaryPatchApplier<BinaryType> customForBinaries, CommitContext commitContext, boolean reverseConflict, @Nullable String leftConflictPanelTitle, @Nullable String rightConflictPanelTitle) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "<init>"));
        }
        this.myProject = project;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches;
        this.myToTargetListsMover = toTargetListsMover;
        this.myCustomForBinaries = customForBinaries;
        this.myCommitContext = commitContext;
        this.myReverseConflict = reverseConflict;
        this.myLeftConflictPanelTitle = leftConflictPanelTitle;
        this.myRightConflictPanelTitle = rightConflictPanelTitle;
        this.myRemainingPatches = new ArrayList<FilePatch>();
        this.myVerifier = new PathsVerifier(this.myProject, this.myBaseDirectory, this.myPatches, new PathsVerifier.BaseMapper(){

            @Override
            @Nullable
            public VirtualFile getFile(FilePatch patch, String path) {
                return PathMerger.getFile(PatchApplier.this.myBaseDirectory, path);
            }

            @Override
            public FilePath getPath(FilePatch patch, String path) {
                return PathMerger.getFile(VcsUtil.getFilePath((VirtualFile)PatchApplier.this.myBaseDirectory), path);
            }
        });
    }

    public PatchApplier(Project project, VirtualFile baseDirectory, List<FilePatch> patches, LocalChangeList targetChangeList, CustomBinaryPatchApplier<BinaryType> customForBinaries, CommitContext commitContext, boolean reverseConflict, @Nullable String leftConflictPanelTitle, @Nullable String rightConflictPanelTitle) {
        this(project, baseDirectory, patches, PatchApplier.createMover(project, targetChangeList), customForBinaries, commitContext, reverseConflict, leftConflictPanelTitle, rightConflictPanelTitle);
    }

    public void setIgnoreContentRootsCheck() {
        this.myVerifier.setIgnoreContentRootsCheck(true);
    }

    public PatchApplier(Project project, VirtualFile baseDirectory, List<FilePatch> patches, LocalChangeList targetChangeList, CustomBinaryPatchApplier<BinaryType> customForBinaries, CommitContext commitContext) {
        this(project, baseDirectory, patches, targetChangeList, customForBinaries, commitContext, false, null, null);
    }

    public void setIsSystemOperation(boolean systemOperation) {
        this.mySystemOperation = systemOperation;
    }

    @Nullable
    private static Consumer<Collection<FilePath>> createMover(Project project, LocalChangeList targetChangeList) {
        ChangeListManager clm = ChangeListManager.getInstance((Project)project);
        if (targetChangeList == null || clm.getDefaultListName().equals(targetChangeList.getName())) {
            return null;
        }
        return new FilesMover(clm, targetChangeList);
    }

    public void execute() {
        this.execute(true, false);
    }

    public ApplyPatchTask createApplyPart(boolean showSuccessNotification, boolean silentAddDelete) {
        return new ApplyPatchTask(showSuccessNotification, silentAddDelete);
    }

    public void execute(boolean showSuccessNotification, boolean silentAddDelete) {
        this.createApplyPart(showSuccessNotification, silentAddDelete).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplyPatchStatus executePatchGroup(final Collection<PatchApplier> group, LocalChangeList localChangeList) {
        if (group.isEmpty()) {
            return ApplyPatchStatus.SUCCESS;
        }
        Project project = group.iterator().next().myProject;
        ApplyPatchStatus result2 = ApplyPatchStatus.SUCCESS;
        for (PatchApplier patchApplier : group) {
            if (!ApplyPatchStatus.FAILURE.equals((Object)(result2 = ApplyPatchStatus.and(result2, patchApplier.nonWriteActionPreCheck())))) continue;
            return result2;
        }
        final TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(project, false);
        final Ref refStatus = new Ref(null);
        try {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    for (PatchApplier applier : group) {
                        if (!applier.createFiles()) {
                            refStatus.set((Object)ApplyPatchStatus.FAILURE);
                            return;
                        }
                        applier.addSkippedItems(trigger);
                    }
                    trigger.prepare();
                    for (PatchApplier applier : group) {
                        refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)refStatus.get()), applier.executeWritable()));
                        if (refStatus.get() != ApplyPatchStatus.ABORT) continue;
                        break;
                    }
                }
            }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null);
        }
        finally {
            VcsFileListenerContextHelper.getInstance((Project)project).clearContext();
        }
        result2 = (ApplyPatchStatus)((Object)refStatus.get());
        result2 = result2 == null ? ApplyPatchStatus.FAILURE : result2;
        trigger.processIt();
        HashSet<FilePath> directlyAffected = new HashSet<FilePath>();
        HashSet<VirtualFile> indirectlyAffected = new HashSet<VirtualFile>();
        for (PatchApplier applier : group) {
            directlyAffected.addAll(applier.getDirectlyAffected());
            indirectlyAffected.addAll(applier.getIndirectlyAffected());
        }
        directlyAffected.addAll(trigger.getAffected());
        Consumer<Collection<FilePath>> mover = localChangeList == null ? null : PatchApplier.createMover(project, localChangeList);
        PatchApplier.refreshPassedFilesAndMoveToChangelist(project, directlyAffected, indirectlyAffected, mover);
        PatchApplier.showApplyStatus(project, result2);
        return result2;
    }

    protected void addSkippedItems(TriggerAdditionOrDeletion trigger) {
        trigger.addExisting(this.myVerifier.getToBeAdded());
        trigger.addDeleted(this.myVerifier.getToBeDeleted());
    }

    public ApplyPatchStatus nonWriteActionPreCheck() {
        boolean value = this.myVerifier.nonWriteActionPreCheck();
        if (!value) {
            return ApplyPatchStatus.FAILURE;
        }
        List<FilePatch> skipped = this.myVerifier.getSkipped();
        boolean applyAll = skipped.isEmpty();
        this.myPatches.removeAll(skipped);
        return applyAll ? ApplyPatchStatus.SUCCESS : (skipped.size() == this.myPatches.size() ? ApplyPatchStatus.ALREADY_APPLIED : ApplyPatchStatus.PARTIAL);
    }

    protected ApplyPatchStatus executeWritable() {
        if (!this.makeWritable(this.myVerifier.getWritableFiles())) {
            return ApplyPatchStatus.FAILURE;
        }
        List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches = this.myVerifier.getTextPatches();
        if (!this.fileTypesAreOk(textPatches)) {
            return ApplyPatchStatus.FAILURE;
        }
        try {
            PatchApplier.markInternalOperation(textPatches, true);
            ApplyPatchStatus applyPatchStatus = this.actualApply(this.myVerifier, this.myCommitContext);
            return applyPatchStatus;
        }
        finally {
            PatchApplier.markInternalOperation(textPatches, false);
        }
    }

    private boolean createFiles() {
        Application application = ApplicationManager.getApplication();
        return (Boolean)application.runWriteAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return PatchApplier.this.myVerifier.execute();
            }
        });
    }

    private static void markInternalOperation(List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches, boolean set) {
        for (Pair<VirtualFile, ApplyTextFilePatch> patch : textPatches) {
            ChangesUtil.markInternalOperation((VirtualFile)((VirtualFile)patch.getFirst()), (boolean)set);
        }
    }

    protected void refreshFiles(Collection<FilePath> additionalDirectly) {
        List<FilePath> directlyAffected = this.myVerifier.getDirectlyAffected();
        List<VirtualFile> indirectlyAffected = this.myVerifier.getAllAffected();
        directlyAffected.addAll(additionalDirectly);
        PatchApplier.refreshPassedFilesAndMoveToChangelist(this.myProject, directlyAffected, indirectlyAffected, this.myToTargetListsMover);
    }

    public List<FilePath> getDirectlyAffected() {
        return this.myVerifier.getDirectlyAffected();
    }

    public List<VirtualFile> getIndirectlyAffected() {
        return this.myVerifier.getAllAffected();
    }

    public static void refreshPassedFilesAndMoveToChangelist(@NotNull Project project, final Collection<FilePath> directlyAffected, final Collection<VirtualFile> indirectlyAffected, final Consumer<Collection<FilePath>> targetChangelistMover) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "refreshPassedFilesAndMoveToChangelist"));
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (FilePath filePath : directlyAffected) {
            lfs.refreshAndFindFileByIoFile(filePath.getIOFile());
        }
        lfs.refreshFiles(indirectlyAffected, false, true, null);
        if (project.isDisposed()) {
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (!directlyAffected.isEmpty() && targetChangelistMover != null) {
            changeListManager.invokeAfterUpdate(new Runnable(){

                @Override
                public void run() {
                    targetChangelistMover.consume((Object)directlyAffected);
                }
            }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, VcsBundle.message((String)"change.lists.manager.move.changes.to.list", (Object[])new Object[0]), (Consumer)new Consumer<VcsDirtyScopeManager>(){

                public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                    PatchApplier.markDirty(vcsDirtyScopeManager, directlyAffected, indirectlyAffected);
                }
            }, null);
        } else {
            PatchApplier.markDirty(VcsDirtyScopeManager.getInstance((Project)project), directlyAffected, indirectlyAffected);
        }
    }

    private static void markDirty(@NotNull VcsDirtyScopeManager vcsDirtyScopeManager, @NotNull Collection<FilePath> directlyAffected, @NotNull Collection<VirtualFile> indirectlyAffected) {
        if (vcsDirtyScopeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDirtyScopeManager", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "markDirty"));
        }
        if (directlyAffected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directlyAffected", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "markDirty"));
        }
        if (indirectlyAffected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indirectlyAffected", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "markDirty"));
        }
        vcsDirtyScopeManager.filePathsDirty(directlyAffected, null);
        vcsDirtyScopeManager.filesDirty(indirectlyAffected, null);
    }

    @Nullable
    private ApplyPatchStatus actualApply(PathsVerifier<BinaryType> verifier, CommitContext commitContext) {
        List textPatches = verifier.getTextPatches();
        ApplyPatchContext context = new ApplyPatchContext(this.myBaseDirectory, 0, true, true);
        ApplyPatchStatus status = null;
        try {
            status = this.applyList(textPatches, context, status, commitContext);
            if (status == ApplyPatchStatus.ABORT) {
                return status;
            }
            if (this.myCustomForBinaries == null) {
                status = this.applyList(verifier.getBinaryPatches(), context, status, commitContext);
            } else {
                List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> binaryPatches = verifier.getBinaryPatches();
                ApplyPatchStatus patchStatus = this.myCustomForBinaries.apply(binaryPatches);
                List<FilePatch> appliedPatches = this.myCustomForBinaries.getAppliedPatches();
                this.moveForCustomBinaries(binaryPatches, appliedPatches);
                status = ApplyPatchStatus.and(status, patchStatus);
                this.myRemainingPatches.removeAll(appliedPatches);
            }
        }
        catch (IOException e) {
            PatchApplier.showError(this.myProject, e.getMessage(), true);
            return ApplyPatchStatus.FAILURE;
        }
        return status;
    }

    private void moveForCustomBinaries(List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> patches, List<FilePatch> appliedPatches) throws IOException {
        for (Pair<VirtualFile, ApplyFilePatchBase<BinaryType>> patch : patches) {
            if (!appliedPatches.contains(((ApplyFilePatchBase)patch.getSecond()).getPatch())) continue;
            this.myVerifier.doMoveIfNeeded((VirtualFile)patch.getFirst());
        }
    }

    private <V extends FilePatch, T extends ApplyFilePatchBase<V>> ApplyPatchStatus applyList(List<Pair<VirtualFile, T>> patches, ApplyPatchContext context, ApplyPatchStatus status, CommitContext commiContext) throws IOException {
        for (Pair<VirtualFile, T> patch : patches) {
            ApplyPatchStatus patchStatus = ApplyPatchAction.applyOnly(this.myProject, (ApplyFilePatchBase)patch.getSecond(), context, (VirtualFile)patch.getFirst(), commiContext, this.myReverseConflict, this.myLeftConflictPanelTitle, this.myRightConflictPanelTitle);
            if (patchStatus == ApplyPatchStatus.ABORT) {
                return patchStatus;
            }
            status = ApplyPatchStatus.and(status, patchStatus);
            if (patchStatus == ApplyPatchStatus.FAILURE) {
                return status;
            }
            if (patchStatus == ApplyPatchStatus.SKIP) continue;
            this.myVerifier.doMoveIfNeeded((VirtualFile)patch.getFirst());
            this.myRemainingPatches.remove(((ApplyFilePatchBase)patch.getSecond()).getPatch());
        }
        return status;
    }

    protected static void showApplyStatus(@NotNull Project project, ApplyPatchStatus status) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier", "showApplyStatus"));
        }
        if (status == ApplyPatchStatus.ALREADY_APPLIED) {
            PatchApplier.showError(project, VcsBundle.message((String)"patch.apply.already.applied", (Object[])new Object[0]), false);
        } else if (status == ApplyPatchStatus.PARTIAL) {
            PatchApplier.showError(project, VcsBundle.message((String)"patch.apply.partially.applied", (Object[])new Object[0]), false);
        } else if (ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            String message = VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]);
            VcsBalloonProblemNotifier.NOTIFICATION_GROUP.createNotification(message, MessageType.INFO).notify(project);
        }
    }

    public List<FilePatch> getRemainingPatches() {
        return this.myRemainingPatches;
    }

    private boolean makeWritable(List<VirtualFile> filesToMakeWritable) {
        VirtualFile[] fileArray = VfsUtilCore.toVirtualFileArray(filesToMakeWritable);
        ReadonlyStatusHandler.OperationStatus readonlyStatus = ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(fileArray);
        return !readonlyStatus.hasReadonlyFiles();
    }

    private boolean fileTypesAreOk(List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches) {
        for (Pair<VirtualFile, ApplyTextFilePatch> textPatch : textPatches) {
            FileType fileType;
            VirtualFile file = (VirtualFile)textPatch.getFirst();
            if (file.isDirectory() || (fileType = file.getFileType()) != FileTypes.UNKNOWN || (fileType = FileTypeChooser.associateFileType(file.getName())) != null) continue;
            PatchApplier.showError(this.myProject, "Cannot apply patch. File " + file.getPresentableName() + " type not defined.", true);
            return false;
        }
        return true;
    }

    public static void showError(final Project project, final String message, final boolean error) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        final String title = VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]);
        final Runnable messageShower = new Runnable(){

            @Override
            public void run() {
                if (error) {
                    Messages.showErrorDialog((Project)project, (String)message, (String)title);
                } else {
                    Messages.showInfoMessage((Project)project, (String)message, (String)title);
                }
            }
        };
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

            @Override
            public void run() {
                messageShower.run();
            }
        }, null, (Project)project);
    }

    private static class FilesMover
    implements Consumer<Collection<FilePath>> {
        private final ChangeListManager myChangeListManager;
        private final LocalChangeList myTargetChangeList;

        public FilesMover(ChangeListManager changeListManager, LocalChangeList targetChangeList) {
            this.myChangeListManager = changeListManager;
            this.myTargetChangeList = targetChangeList;
        }

        public void consume(Collection<FilePath> directlyAffected) {
            ArrayList<Change> changes = new ArrayList<Change>();
            for (FilePath file : directlyAffected) {
                Change change = this.myChangeListManager.getChange(file);
                if (change == null) continue;
                changes.add(change);
            }
            this.myChangeListManager.moveChangesTo(this.myTargetChangeList, changes.toArray(new Change[changes.size()]));
        }
    }

    public class ApplyPatchTask {
        private ApplyPatchStatus myStatus;
        private final boolean myShowNotification;
        private final boolean mySystemOperation;
        private VcsShowConfirmationOption.Value myAddconfirmationvalue;
        private VcsShowConfirmationOption.Value myDeleteconfirmationvalue;

        public ApplyPatchTask(boolean showNotification, boolean systemOperation) {
            this.myShowNotification = showNotification;
            this.mySystemOperation = systemOperation;
        }

        public void run() {
            PatchApplier.this.myRemainingPatches.addAll(PatchApplier.this.myPatches);
            ApplyPatchStatus patchStatus = PatchApplier.this.nonWriteActionPreCheck();
            if (ApplyPatchStatus.FAILURE.equals((Object)patchStatus)) {
                if (this.myShowNotification) {
                    PatchApplier.showApplyStatus(PatchApplier.this.myProject, patchStatus);
                }
                this.myStatus = patchStatus;
                return;
            }
            TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(PatchApplier.this.myProject, this.mySystemOperation);
            ApplyPatchStatus applyStatus = this.getApplyPatchStatus(trigger);
            this.myStatus = ApplyPatchStatus.SUCCESS.equals((Object)patchStatus) ? applyStatus : ApplyPatchStatus.and(patchStatus, applyStatus);
            trigger.processIt();
            if (this.myShowNotification || !ApplyPatchStatus.SUCCESS.equals((Object)this.myStatus)) {
                PatchApplier.showApplyStatus(PatchApplier.this.myProject, this.myStatus);
            }
            PatchApplier.this.refreshFiles(trigger.getAffected());
        }

        @NotNull
        private ApplyPatchStatus getApplyPatchStatus(final @NotNull TriggerAdditionOrDeletion trigger) {
            if (trigger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trigger", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier$ApplyPatchTask", "getApplyPatchStatus"));
            }
            final Ref refStatus = Ref.create((Object)((Object)ApplyPatchStatus.FAILURE));
            try {
                this.setConfirmationToDefault();
                CommandProcessor.getInstance().executeCommand(PatchApplier.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        if (!PatchApplier.this.createFiles()) {
                            refStatus.set((Object)ApplyPatchStatus.FAILURE);
                            return;
                        }
                        PatchApplier.this.addSkippedItems(trigger);
                        trigger.prepare();
                        refStatus.set((Object)PatchApplier.this.executeWritable());
                    }
                }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null);
            }
            finally {
                this.returnConfirmationBack();
                VcsFileListenerContextHelper.getInstance((Project)PatchApplier.this.myProject).clearContext();
            }
            ApplyPatchStatus applyPatchStatus = (ApplyPatchStatus)((Object)refStatus.get());
            if (applyPatchStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/formove/PatchApplier$ApplyPatchTask", "getApplyPatchStatus"));
            }
            return applyPatchStatus;
        }

        private void returnConfirmationBack() {
            if (this.mySystemOperation) {
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)PatchApplier.this.myProject);
                VcsShowConfirmationOption addConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, null);
                addConfirmation.setValue(this.myAddconfirmationvalue);
                VcsShowConfirmationOption deleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, null);
                deleteConfirmation.setValue(this.myDeleteconfirmationvalue);
            }
        }

        private void setConfirmationToDefault() {
            if (this.mySystemOperation) {
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)PatchApplier.this.myProject);
                VcsShowConfirmationOption addConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, null);
                this.myAddconfirmationvalue = addConfirmation.getValue();
                addConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
                VcsShowConfirmationOption deleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, null);
                this.myDeleteconfirmationvalue = deleteConfirmation.getValue();
                deleteConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            }
        }

        public ApplyPatchStatus getStatus() {
            return this.myStatus;
        }
    }
}

