/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationsNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.event.InputEvent;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationNode
extends ExternalSystemNode {
    private final RunnerAndConfigurationSettings mySettings;

    public RunConfigurationNode(@NotNull ExternalProjectsView externalProjectsView, RunConfigurationsNode parent, @NotNull RunnerAndConfigurationSettings settings) {
        if (externalProjectsView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectsView", "com/intellij/openapi/externalSystem/view/RunConfigurationNode", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/view/RunConfigurationNode", "<init>"));
        }
        super(externalProjectsView, parent);
        this.mySettings = settings;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(ProgramRunnerUtil.getConfigurationIcon(this.mySettings, false));
        ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)this.mySettings.getConfiguration();
        ExternalSystemTaskExecutionSettings taskExecutionSettings = runConfiguration.getSettings();
        String shortcutHint = StringUtil.nullize((String)this.getShortcutsManager().getDescription(taskExecutionSettings.getExternalProjectPath(), this.mySettings.getName()));
        String activatorHint = StringUtil.nullize((String)this.getTaskActivator().getDescription(taskExecutionSettings.getExternalSystemId(), taskExecutionSettings.getExternalProjectPath(), ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(this.mySettings)));
        String hint = shortcutHint == null ? activatorHint : (activatorHint == null ? shortcutHint : shortcutHint + ", " + activatorHint);
        this.setNameAndTooltip(this.getName(), StringUtil.join((Collection)taskExecutionSettings.getTaskNames(), (String)" "), hint);
    }

    public RunnerAndConfigurationSettings getSettings() {
        return this.mySettings;
    }

    public String getName() {
        return this.mySettings.getName();
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.RunConfigurationMenu";
    }

    public void updateRunConfiguration() {
    }

    @Override
    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        Project project = this.getExternalProjectsView().getProject();
        ProgramRunnerUtil.executeConfiguration(project, this.mySettings, DefaultRunExecutor.getRunExecutorInstance());
        RunManagerEx runManagerEx = RunManagerEx.getInstanceEx(project);
        runManagerEx.setSelectedConfiguration(this.mySettings);
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return new Navigatable(){

            public void navigate(boolean requestFocus) {
                RunManager.getInstance((Project)RunConfigurationNode.this.myProject).setSelectedConfiguration(RunConfigurationNode.this.mySettings);
                EditConfigurationsDialog dialog = new EditConfigurationsDialog(RunConfigurationNode.this.myProject);
                dialog.show();
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return false;
            }
        };
    }
}

