/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArtifactEditorSettings
implements PersistentStateComponent<ArtifactEditorSettingsState> {
    private boolean mySortElements = true;
    private final List<ComplexPackagingElementType<?>> myTypesToShowContent = new ArrayList();

    public ArtifactEditorSettings() {
    }

    public ArtifactEditorSettings(boolean sortElements, Collection<ComplexPackagingElementType<?>> typesToShowContent) {
        this.mySortElements = sortElements;
        this.myTypesToShowContent.addAll(typesToShowContent);
    }

    public ArtifactEditorSettingsState getState() {
        ArtifactEditorSettingsState state = new ArtifactEditorSettingsState();
        state.mySortElements = this.mySortElements;
        for (ComplexPackagingElementType<?> type : this.myTypesToShowContent) {
            state.myTypesToShowContentIds.add(type.getId());
        }
        return state;
    }

    public void loadState(ArtifactEditorSettingsState state) {
        this.mySortElements = state.mySortElements;
        this.myTypesToShowContent.clear();
        for (String id : state.myTypesToShowContentIds) {
            PackagingElementType type = PackagingElementFactory.getInstance().findElementType(id);
            if (!(type instanceof ComplexPackagingElementType)) continue;
            this.myTypesToShowContent.add((ComplexPackagingElementType)type);
        }
    }

    public boolean isSortElements() {
        return this.mySortElements;
    }

    public List<ComplexPackagingElementType<?>> getTypesToShowContent() {
        return this.myTypesToShowContent;
    }

    public void setSortElements(boolean sortElements) {
        this.mySortElements = sortElements;
    }

    public void setTypesToShowContent(Collection<ComplexPackagingElementType<?>> typesToShowContent) {
        this.myTypesToShowContent.clear();
        this.myTypesToShowContent.addAll(typesToShowContent);
    }

    @Tag(value="artifact-editor")
    public static class ArtifactEditorSettingsState {
        @Tag(value="show-sorted")
        public boolean mySortElements = true;
        @Tag(value="show-content")
        @AbstractCollection(surroundWithTag=false, elementTag="type", elementValueAttribute="id")
        public List<String> myTypesToShowContentIds = new ArrayList<String>();
    }
}

