/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class KeyCodeTypeCommand
extends AlphaNumericTypeCommand {
    public static final String PREFIX = "%type";
    public static final String CODE_DELIMITER = ";";
    public static final String MODIFIER_DELIMITER = ":";

    public KeyCodeTypeCommand(String text, int line) {
        super(text, line);
    }

    @Override
    public ActionCallback _execute(final PlaybackContext context) {
        String text = this.getText().substring(PREFIX.length()).trim();
        int textDelim = text.indexOf(" ");
        final String codes = textDelim >= 0 ? text.substring(0, textDelim) : text;
        final String unicode = codes.length() + 1 < text.length() ? text.substring(textDelim + 1) : "";
        final ActionCallback result2 = new ActionCallback();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                TypingTarget typingTarget = AlphaNumericTypeCommand.findTarget(context);
                if (typingTarget != null) {
                    typingTarget.type(unicode).doWhenDone(result2.createSetDoneRunnable()).doWhenRejected(new Runnable(){

                        @Override
                        public void run() {
                            KeyCodeTypeCommand.this.typeCodes(context, context.getRobot(), codes).notify(result2);
                        }
                    });
                } else {
                    KeyCodeTypeCommand.this.typeCodes(context, context.getRobot(), codes).notify(result2);
                }
            }
        });
        return result2;
    }

    private ActionCallback typeCodes(final PlaybackContext context, final Robot robot, final String codes) {
        final ActionCallback result2 = new ActionCallback();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String[] pairs;
                for (String eachPair : pairs = codes.split(KeyCodeTypeCommand.CODE_DELIMITER)) {
                    try {
                        String[] splits = eachPair.split(KeyCodeTypeCommand.MODIFIER_DELIMITER);
                        Integer code = Integer.valueOf(splits[0]);
                        Integer modifier = Integer.valueOf(splits[1]);
                        KeyCodeTypeCommand.this.type(robot, code, modifier);
                    }
                    catch (NumberFormatException e) {
                        KeyCodeTypeCommand.this.dumpError(context, "Invalid code: " + eachPair);
                        result2.setRejected();
                        return;
                    }
                }
                result2.setDone();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        } else {
            runnable.run();
        }
        return result2;
    }

    public static Couple<List<Integer>> parseKeyCodes(String keyCodesText) {
        ArrayList<Integer> codes = new ArrayList<Integer>();
        ArrayList<Integer> modifiers = new ArrayList<Integer>();
        if (keyCodesText != null) {
            String[] pairs;
            for (String each : pairs = keyCodesText.split(CODE_DELIMITER)) {
                String[] strings = each.split(MODIFIER_DELIMITER);
                if (strings.length != 2) continue;
                codes.add(Integer.valueOf(strings[0]));
                modifiers.add(Integer.valueOf(strings[1]));
            }
        }
        return Couple.of(codes, modifiers);
    }

    public static String unparseKeyCodes(Couple<List<Integer>> pairs) {
        StringBuilder result2 = new StringBuilder();
        List codes = (List)pairs.getFirst();
        List modifiers = (List)pairs.getSecond();
        for (int i = 0; i < codes.size(); ++i) {
            Integer each = (Integer)codes.get(i);
            result2.append(each.toString());
            result2.append(MODIFIER_DELIMITER);
            result2.append(modifiers.get(i));
            if (i >= codes.size() - 1) continue;
            result2.append(CODE_DELIMITER);
        }
        return result2.toString();
    }
}

