/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsGuess {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManagerImpl myVcsManager;

    public VcsGuess(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/VcsGuess", "<init>"));
        }
        this.myProject = project;
        this.myVcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Nullable
    public AbstractVcs getVcsForDirty(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/VcsGuess", "getVcsForDirty"));
        }
        if (file.isInLocalFileSystem() && this.isFileInIndex(null, file)) {
            return this.myVcsManager.getVcsFor(file);
        }
        return null;
    }

    @Nullable
    public AbstractVcs getVcsForDirty(@NotNull FilePath filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/VcsGuess", "getVcsForDirty"));
        }
        if (filePath.isNonLocal()) {
            return null;
        }
        VirtualFile validParent = ChangesUtil.findValidParentAccurately((FilePath)filePath);
        if (validParent != null && this.isFileInIndex(filePath, validParent)) {
            return this.myVcsManager.getVcsFor(validParent);
        }
        return null;
    }

    private boolean isFileInIndex(final @Nullable FilePath filePath, final @NotNull VirtualFile validParent) {
        if (validParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validParent", "com/intellij/openapi/vcs/changes/VcsGuess", "isFileInIndex"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (VcsGuess.this.myProject.isDisposed()) {
                    return false;
                }
                boolean inContent = VcsGuess.this.myVcsManager.isFileInContent(validParent);
                if (inContent) {
                    return true;
                }
                if (filePath != null) {
                    return VcsGuess.isFileInBaseDir(filePath, VcsGuess.this.myProject.getBaseDir()) && !VcsGuess.this.myVcsManager.isIgnored(validParent);
                }
                return false;
            }
        });
    }

    private static boolean isFileInBaseDir(@NotNull FilePath filePath, @Nullable VirtualFile baseDir) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/VcsGuess", "isFileInBaseDir"));
        }
        VirtualFile parent = filePath.getVirtualFileParent();
        return !filePath.isDirectory() && parent != null && parent.equals(baseDir);
    }
}

