/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vcs.update.DirectoryTreeNode;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vcs.update.FileTreeNode;
import com.intellij.openapi.vcs.update.GroupByPackages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupTreeNode
extends AbstractTreeNode
implements Disposable {
    private final String myName;
    private final boolean mySupportsDeletion;
    private final List<String> myFilePaths;
    private final Map<String, String> myErrorsMap;
    private final SimpleTextAttributes myInvalidAttributes;
    private final Project myProject;
    private final String myFileGroupId;

    public GroupTreeNode(@NotNull String name, boolean supportsDeletion, @NotNull SimpleTextAttributes invalidAttributes, @NotNull Project project, @NotNull Map<String, String> errorsMap, String id) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/update/GroupTreeNode", "<init>"));
        }
        if (invalidAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidAttributes", "com/intellij/openapi/vcs/update/GroupTreeNode", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/update/GroupTreeNode", "<init>"));
        }
        if (errorsMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorsMap", "com/intellij/openapi/vcs/update/GroupTreeNode", "<init>"));
        }
        this.myFilePaths = new ArrayList<String>();
        this.myName = name;
        this.mySupportsDeletion = supportsDeletion;
        this.myInvalidAttributes = invalidAttributes;
        this.myProject = project;
        this.myErrorsMap = errorsMap;
        this.myFileGroupId = id;
    }

    public String getFileGroupId() {
        return this.myFileGroupId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/GroupTreeNode", "getName"));
        }
        return string;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        String iconName = expanded ? "folderOpen" : "folder";
        return IconLoader.getIcon((String)("/nodes/" + iconName + ".png"));
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            result2.addAll(((AbstractTreeNode)this.getChildAt(i)).getVirtualFiles());
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/GroupTreeNode", "getVirtualFiles"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<File> getFiles() {
        ArrayList<File> result2 = new ArrayList<File>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            result2.addAll(((AbstractTreeNode)this.getChildAt(i)).getFiles());
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/GroupTreeNode", "getFiles"));
        }
        return arrayList;
    }

    @Override
    protected int getItemsCount() {
        int result2 = 0;
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            AbstractTreeNode treeNode = (AbstractTreeNode)children.nextElement();
            result2 += treeNode.getItemsCount();
        }
        return result2;
    }

    @Override
    protected boolean showStatistics() {
        return true;
    }

    @Override
    @NotNull
    public SimpleTextAttributes getAttributes() {
        SimpleTextAttributes simpleTextAttributes = this.myFilterAttributes == null ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : this.myFilterAttributes;
        if (simpleTextAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/GroupTreeNode", "getAttributes"));
        }
        return simpleTextAttributes;
    }

    @Override
    public boolean getSupportsDeletion() {
        return this.mySupportsDeletion;
    }

    public void addFilePath(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/update/GroupTreeNode", "addFilePath"));
        }
        this.myFilePaths.add(filePath);
    }

    public void rebuild(boolean groupByPackages, @Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        this.myFilterAttributes = null;
        if (this.containsGroups()) {
            this.rebuildGroups(groupByPackages, filter, showOnlyFilteredItems);
        } else {
            this.rebuildFiles(groupByPackages, filter, showOnlyFilteredItems);
        }
    }

    private void rebuildGroups(boolean groupByPackages, @Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        boolean apply = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            GroupTreeNode childGroup = (GroupTreeNode)this.getChildAt(i);
            childGroup.rebuild(groupByPackages, filter, showOnlyFilteredItems);
            apply |= childGroup.myFilterAttributes != null;
        }
        this.applyFilter(apply);
    }

    private void rebuildFiles(boolean groupByPackages, @Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            TreeNode node = this.getChildAt(i);
            if (!(node instanceof Disposable)) continue;
            Disposer.dispose((Disposable)((Disposable)node));
        }
        this.removeAllChildren();
        if (groupByPackages) {
            this.buildPackages();
            this.acceptFilter(filter, showOnlyFilteredItems);
        } else {
            this.buildFiles(filter, showOnlyFilteredItems);
        }
        this.setTreeModel(this.myTreeModel);
        if (this.myTreeModel != null) {
            this.myTreeModel.nodeStructureChanged(this);
        }
    }

    private void buildPackages() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (String myFilePath : this.myFilePaths) {
            files.add(new File(myFilePath));
        }
        GroupByPackages groupByPackages = new GroupByPackages(files);
        List<File> roots = groupByPackages.getRoots();
        this.addFiles(this, roots, files, groupByPackages, null);
    }

    private void addFiles(@NotNull AbstractTreeNode parentNode, @NotNull List<File> roots, final @NotNull Collection<File> files, @NotNull GroupByPackages groupByPackages, String parentPath) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/vcs/update/GroupTreeNode", "addFiles"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/update/GroupTreeNode", "addFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/update/GroupTreeNode", "addFiles"));
        }
        if (groupByPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupByPackages", "com/intellij/openapi/vcs/update/GroupTreeNode", "addFiles"));
        }
        Collections.sort(roots, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                boolean containsFile2;
                boolean containsFile1 = files.contains(file1);
                if (containsFile1 == (containsFile2 = files.contains(file2))) {
                    return file1.getAbsolutePath().compareToIgnoreCase(file2.getAbsolutePath());
                }
                return containsFile1 ? 1 : -1;
            }
        });
        for (File root : roots) {
            FileOrDirectoryTreeNode child = files.contains(root) ? new FileTreeNode(root.getAbsolutePath(), this.myInvalidAttributes, this.myProject, parentPath) : new DirectoryTreeNode(root.getAbsolutePath(), this.myProject, parentPath);
            Disposer.register((Disposable)((Disposable)parentNode), (Disposable)child);
            parentNode.add(child);
            this.addFiles(child, groupByPackages.getChildren(root), files, groupByPackages, child.getFilePath());
        }
    }

    private void buildFiles(@Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        Collections.sort(this.myFilePaths, new Comparator<String>(){

            @Override
            public int compare(String path1, String path2) {
                return path1.compareToIgnoreCase(path2);
            }
        });
        boolean apply = false;
        for (String filePath : this.myFilePaths) {
            String error;
            FileTreeNode child = new FileTreeNode(filePath, this.myInvalidAttributes, this.myProject, null);
            if (filter != null) {
                if (child.acceptFilter(filter, showOnlyFilteredItems)) {
                    apply = true;
                } else if (showOnlyFilteredItems) {
                    Disposer.dispose((Disposable)child);
                    continue;
                }
            }
            if ((error = this.myErrorsMap.get(filePath)) != null) {
                child.setErrorText(error);
            }
            this.add(child);
            Disposer.register((Disposable)this, (Disposable)child);
        }
        this.applyFilter(apply);
    }

    private boolean containsGroups() {
        return this.myFilePaths.isEmpty();
    }

    public void dispose() {
    }
}

