/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessor;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectOpenProcessorBase<T extends ProjectImportBuilder>
extends ProjectOpenProcessor {
    private final T myBuilder;

    protected ProjectOpenProcessorBase(@NotNull T builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/projectImport/ProjectOpenProcessorBase", "<init>"));
        }
        this.myBuilder = builder;
    }

    public String getName() {
        return ((ProjectImportBuilder)((Object)this.getBuilder())).getName();
    }

    @Nullable
    public Icon getIcon() {
        return ((ProjectImportBuilder)((Object)this.getBuilder())).getIcon();
    }

    public boolean canOpenProject(VirtualFile file) {
        String[] supported = this.getSupportedExtensions();
        if (supported != null) {
            if (file.isDirectory()) {
                for (VirtualFile child : ProjectOpenProcessorBase.getFileChildren(file)) {
                    if (!ProjectOpenProcessorBase.canOpenFile(child, supported)) continue;
                    return true;
                }
                return false;
            }
            if (ProjectOpenProcessorBase.canOpenFile(file, supported)) {
                return true;
            }
        }
        return false;
    }

    private static Collection<VirtualFile> getFileChildren(VirtualFile file) {
        if (file instanceof NewVirtualFile) {
            return ((NewVirtualFile)file).getCachedChildren();
        }
        return Arrays.asList(file.getChildren());
    }

    protected static boolean canOpenFile(VirtualFile file, String[] supported) {
        String fileName = file.getName();
        for (String name : supported) {
            if (!fileName.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean doQuickImport(VirtualFile file, WizardContext wizardContext) {
        return false;
    }

    @NotNull
    public T getBuilder() {
        T t = this.myBuilder;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/projectImport/ProjectOpenProcessorBase", "getBuilder"));
        }
        return t;
    }

    @Nullable
    public abstract String[] getSupportedExtensions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, Project projectToClose, boolean forceOpenInNewFrame) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/projectImport/ProjectOpenProcessorBase", "doOpenProject"));
        }
        try {
            Project projectToOpen;
            Project defaultProject;
            Sdk jdk;
            String[] supported;
            ((ProjectImportBuilder)((Object)this.getBuilder())).setUpdate(false);
            final WizardContext wizardContext = new WizardContext(null);
            if (virtualFile.isDirectory()) {
                supported = this.getSupportedExtensions();
                for (VirtualFile file : ProjectOpenProcessorBase.getFileChildren(virtualFile)) {
                    if (!ProjectOpenProcessorBase.canOpenFile(file, supported)) continue;
                    virtualFile = file;
                    break;
                }
            }
            wizardContext.setProjectFileDirectory(virtualFile.getParent().getPath());
            if (!this.doQuickImport(virtualFile, wizardContext)) {
                supported = null;
                return supported;
            }
            if (wizardContext.getProjectName() == null) {
                if (wizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT) {
                    wizardContext.setProjectName(IdeBundle.message((String)"project.import.default.name", (Object[])new Object[]{this.getName()}) + ".ipr");
                } else {
                    wizardContext.setProjectName(IdeBundle.message((String)"project.import.default.name.dotIdea", (Object[])new Object[]{this.getName()}));
                }
            }
            if ((jdk = ProjectRootManager.getInstance((Project)(defaultProject = ProjectManager.getInstance().getDefaultProject())).getProjectSdk()) == null) {
                jdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)JavaSdk.getInstance());
            }
            wizardContext.setProjectJdk(jdk);
            String dotIdeaFilePath = wizardContext.getProjectFileDirectory() + File.separator + ".idea";
            String projectFilePath = wizardContext.getProjectFileDirectory() + File.separator + wizardContext.getProjectName() + ".ipr";
            File dotIdeaFile = new File(dotIdeaFilePath);
            File projectFile = new File(projectFilePath);
            String pathToOpen = wizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT ? projectFilePath : dotIdeaFile.getParent();
            boolean shouldOpenExisting = false;
            if (!ApplicationManager.getApplication().isHeadlessEnvironment() && (projectFile.exists() || dotIdeaFile.exists())) {
                String existingName;
                if (dotIdeaFile.exists()) {
                    existingName = "an existing project";
                    pathToOpen = dotIdeaFile.getParent();
                } else {
                    existingName = "'" + projectFile.getName() + "'";
                    pathToOpen = projectFilePath;
                }
                int result2 = Messages.showYesNoCancelDialog((Project)projectToClose, (String)IdeBundle.message((String)"project.import.open.existing", (Object[])new Object[]{existingName, projectFile.getParent(), virtualFile.getName()}), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"project.import.open.existing.openExisting", (Object[])new Object[0]), (String)IdeBundle.message((String)"project.import.open.existing.reimport", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result2 == 2) {
                    Project project = null;
                    return project;
                }
                boolean bl = shouldOpenExisting = result2 == 0;
            }
            if (shouldOpenExisting) {
                try {
                    projectToOpen = ProjectManagerEx.getInstanceEx().loadProject(pathToOpen);
                }
                catch (Exception e) {
                    Project project = null;
                    this.getBuilder().cleanup();
                    return project;
                }
            } else {
                projectToOpen = ProjectManagerEx.getInstanceEx().newProject(wizardContext.getProjectName(), pathToOpen, true, false);
                if (projectToOpen == null || !this.getBuilder().validate(projectToClose, projectToOpen)) {
                    Project project = null;
                    return project;
                }
                projectToOpen.save();
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        String projectDirPath;
                        Sdk jdk = wizardContext.getProjectJdk();
                        if (jdk != null) {
                            NewProjectUtil.applyJdkToProject(projectToOpen, jdk);
                        }
                        String path = StringUtil.endsWithChar((CharSequence)(projectDirPath = wizardContext.getProjectFileDirectory()), (char)'/') ? projectDirPath + "classes" : projectDirPath + "/classes";
                        CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)projectToOpen);
                        if (extension != null) {
                            extension.setCompilerOutputUrl(ProjectOpenProcessorBase.getUrl(path));
                        }
                    }
                });
                ((ProjectImportBuilder)((Object)this.getBuilder())).commit(projectToOpen, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            if (!forceOpenInNewFrame) {
                NewProjectUtil.closePreviousProject(projectToClose);
            }
            ProjectUtil.updateLastProjectLocation(pathToOpen);
            ProjectManagerEx.getInstanceEx().openProject(projectToOpen);
            Project project = projectToOpen;
            return project;
        }
        finally {
            this.getBuilder().cleanup();
        }
    }

    public static String getUrl(@NonNls String path) {
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)path));
    }
}

