/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryIconProvider
extends IconProvider
implements DumbAware {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/DirectoryIconProvider", "getIcon"));
        }
        if (element instanceof PsiDirectory) {
            Project project;
            PsiDirectory psiDirectory = (PsiDirectory)element;
            VirtualFile vFile = psiDirectory.getVirtualFile();
            SourceFolder sourceFolder = ProjectRootsUtil.getModuleSourceRoot(vFile, project = psiDirectory.getProject());
            if (sourceFolder != null) {
                return SourceRootPresentation.getSourceRootIcon(sourceFolder);
            }
            Icon excludedIcon = DirectoryIconProvider.getIconIfExcluded(project, vFile);
            return excludedIcon != null ? excludedIcon : PlatformIcons.DIRECTORY_CLOSED_ICON;
        }
        return null;
    }

    @Nullable
    public static Icon getIconIfExcluded(@NotNull Project project, @NotNull VirtualFile vFile) {
        boolean ignored;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/file/DirectoryIconProvider", "getIconIfExcluded"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/DirectoryIconProvider", "getIconIfExcluded"));
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && (ignored = ProjectRootManager.getInstance((Project)project).getFileIndex().isExcluded(vFile))) {
            return AllIcons.Modules.ExcludeRoot;
        }
        return null;
    }
}

