/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyClassDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyClassesHandler
extends CopyHandlerDelegateBase {
    private static final Logger LOG = Logger.getInstance((String)("#" + CopyClassesHandler.class.getName()));

    @Override
    public boolean forbidToClone(PsiElement[] elements, boolean fromUpdate) {
        Map<PsiFile, PsiClass[]> fileMap = CopyClassesHandler.convertToTopLevelClasses(elements, fromUpdate, null, null);
        if (fileMap != null && fileMap.size() == 1) {
            PsiClass[] psiClasses = fileMap.values().iterator().next();
            return psiClasses != null && psiClasses.length > 1;
        }
        return true;
    }

    @Override
    public boolean canCopy(PsiElement[] elements, boolean fromUpdate) {
        return CopyClassesHandler.canCopyClass(fromUpdate, elements);
    }

    public static boolean canCopyClass(PsiElement ... elements) {
        return CopyClassesHandler.canCopyClass(false, elements);
    }

    public static boolean canCopyClass(boolean fromUpdate, PsiElement ... elements) {
        if (fromUpdate && elements.length > 0 && elements[0] instanceof PsiDirectory) {
            return true;
        }
        return CopyClassesHandler.convertToTopLevelClasses(elements, fromUpdate, null, null) != null;
    }

    @Nullable
    private static Map<PsiFile, PsiClass[]> convertToTopLevelClasses(PsiElement[] elements, boolean fromUpdate, String relativePath, Map<PsiFile, String> relativeMap) {
        HashMap<PsiFile, PsiClass[]> result2 = new HashMap<PsiFile, PsiClass[]>();
        for (PsiElement element : elements) {
            PsiElement navigationElement = element.getNavigationElement();
            LOG.assertTrue(navigationElement != null, (Object)element);
            PsiFile containingFile = navigationElement.getContainingFile();
            if (containingFile instanceof PsiClassOwner && JavaProjectRootsUtil.isOutsideJavaSourceRoot(containingFile)) continue;
            PsiClass[] topLevelClasses = CopyClassesHandler.getTopLevelClasses(element);
            if (topLevelClasses == null) {
                if (element instanceof PsiDirectory) {
                    if (fromUpdate) continue;
                    String name = ((PsiDirectory)element).getName();
                    String path = relativePath != null ? (relativePath.length() > 0 ? relativePath + "/" : "") + name : null;
                    Map<PsiFile, PsiClass[]> map = CopyClassesHandler.convertToTopLevelClasses(element.getChildren(), fromUpdate, path, relativeMap);
                    if (map == null) {
                        return null;
                    }
                    for (Map.Entry<PsiFile, PsiClass[]> entry : map.entrySet()) {
                        CopyClassesHandler.fillResultsMap(result2, entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                if (!(element instanceof PsiFileSystemItem)) {
                    return null;
                }
            }
            CopyClassesHandler.fillResultsMap(result2, containingFile, topLevelClasses);
            if (relativeMap == null) continue;
            relativeMap.put(containingFile, relativePath);
        }
        if (result2.isEmpty()) {
            return null;
        }
        boolean hasClasses = false;
        for (PsiClass[] classes : result2.values()) {
            if (classes == null) continue;
            hasClasses = true;
            break;
        }
        return hasClasses ? result2 : null;
    }

    @Nullable
    private static String normalizeRelativeMap(Map<PsiFile, String> relativeMap) {
        String vector = null;
        for (String relativePath : relativeMap.values()) {
            if (vector == null) {
                vector = relativePath;
                continue;
            }
            if (vector.startsWith(relativePath + "/")) {
                vector = relativePath;
                continue;
            }
            if (relativePath.startsWith(vector + "/") || relativePath.equals(vector)) continue;
            return null;
        }
        if (vector != null) {
            Iterator<String> iterator = relativeMap.keySet().iterator();
            while (iterator.hasNext()) {
                PsiFile psiFile;
                String path = relativeMap.get(psiFile = (PsiFile)iterator.next());
                relativeMap.put(psiFile, path.equals(vector) ? "" : path.substring(vector.length() + 1));
            }
        }
        return vector;
    }

    private static void fillResultsMap(Map<PsiFile, PsiClass[]> result2, PsiFile containingFile, PsiClass[] topLevelClasses) {
        Object[] classes = result2.get(containingFile);
        if (topLevelClasses != null) {
            if (classes != null) {
                topLevelClasses = (PsiClass[])ArrayUtil.mergeArrays((Object[])classes, (Object[])topLevelClasses, (ArrayFactory)PsiClass.ARRAY_FACTORY);
            }
            result2.put(containingFile, topLevelClasses);
        } else {
            result2.put(containingFile, (PsiClass[])classes);
        }
    }

    @Override
    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        Project project;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.copyClass");
        HashMap<PsiFile, String> relativePathsMap = new HashMap<PsiFile, String>();
        Map<PsiFile, PsiClass[]> classes = CopyClassesHandler.convertToTopLevelClasses(elements, false, "", relativePathsMap);
        assert (classes != null);
        if (defaultTargetDirectory == null) {
            PsiFile psiFile = classes.keySet().iterator().next();
            defaultTargetDirectory = psiFile.getContainingDirectory();
            LOG.assertTrue(defaultTargetDirectory != null, (Object)psiFile);
        } else {
            project = defaultTargetDirectory.getProject();
            VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(defaultTargetDirectory.getVirtualFile());
            if (sourceRootForFile == null) {
                ArrayList<Object> files = new ArrayList<Object>();
                int elementsLength = elements.length;
                for (int i = 0; i < elementsLength; ++i) {
                    PsiFile containingFile = elements[i].getContainingFile();
                    if (containingFile != null) {
                        files.add(containingFile);
                        continue;
                    }
                    if (!(elements[i] instanceof PsiDirectory)) continue;
                    files.add(elements[i]);
                }
                CopyFilesOrDirectoriesHandler.copyAsFiles(files.toArray(new PsiElement[files.size()]), defaultTargetDirectory, project);
                return;
            }
        }
        project = defaultTargetDirectory.getProject();
        PsiDirectory targetDirectory = null;
        String className = null;
        boolean openInEditor = true;
        if (CopyClassesHandler.copyOneClass(classes)) {
            final String commonPath = ArrayUtilRt.find((Object[])elements, (Object)classes.values().iterator().next()) == -1 ? CopyClassesHandler.normalizeRelativeMap(relativePathsMap) : null;
            CopyClassDialog dialog = new CopyClassDialog(classes.values().iterator().next()[0], defaultTargetDirectory, project, false){

                @Override
                protected String getQualifiedName() {
                    String qualifiedName = super.getQualifiedName();
                    if (commonPath != null && !commonPath.isEmpty() && !qualifiedName.endsWith(commonPath)) {
                        return StringUtil.getQualifiedName((String)qualifiedName, (String)commonPath.replaceAll("/", "."));
                    }
                    return qualifiedName;
                }
            };
            dialog.setTitle(RefactoringBundle.message((String)"copy.handler.copy.class"));
            if (dialog.showAndGet()) {
                openInEditor = dialog.openInEditor();
                targetDirectory = dialog.getTargetDirectory();
                className = dialog.getClassName();
                if (className == null || className.length() == 0) {
                    return;
                }
            }
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            targetDirectory = defaultTargetDirectory;
        } else {
            CopyFilesOrDirectoriesDialog dialog;
            PsiClass[] psiClasses;
            if ((defaultTargetDirectory = CopyFilesOrDirectoriesHandler.resolveDirectory(defaultTargetDirectory)) == null) {
                return;
            }
            PsiFile[] files = PsiUtilCore.toPsiFileArray(classes.keySet());
            if (classes.keySet().size() == 1 && (psiClasses = classes.values().iterator().next()) != null) {
                files = psiClasses;
            }
            if ((dialog = new CopyFilesOrDirectoriesDialog((PsiElement[])files, defaultTargetDirectory, project, false)).showAndGet()) {
                targetDirectory = dialog.getTargetDirectory();
                className = dialog.getNewName();
                openInEditor = dialog.openInEditor();
            }
        }
        if (targetDirectory != null) {
            CopyClassesHandler.copyClassesImpl(className, project, classes, relativePathsMap, targetDirectory, defaultTargetDirectory, RefactoringBundle.message((String)"copy.handler.copy.class"), false, openInEditor);
        }
    }

    private static boolean copyOneClass(Map<PsiFile, PsiClass[]> classes) {
        if (classes.size() == 1) {
            PsiClass[] psiClasses = classes.values().iterator().next();
            return psiClasses != null && psiClasses.length == 1;
        }
        return false;
    }

    @Override
    public void doClone(PsiElement element) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.copyClass");
        PsiClass[] classes = CopyClassesHandler.getTopLevelClasses(element);
        if (classes == null) {
            CopyFilesOrDirectoriesHandler.doCloneFile(element);
            return;
        }
        Project project = element.getProject();
        CopyClassDialog dialog = new CopyClassDialog(classes[0], null, project, true);
        dialog.setTitle(RefactoringBundle.message((String)"copy.handler.clone.class"));
        if (dialog.showAndGet()) {
            String className = dialog.getClassName();
            PsiDirectory targetDirectory = element.getContainingFile().getContainingDirectory();
            CopyClassesHandler.copyClassesImpl(className, project, Collections.singletonMap(classes[0].getContainingFile(), classes), null, targetDirectory, targetDirectory, RefactoringBundle.message((String)"copy.handler.clone.class"), true, true);
        }
    }

    private static void copyClassesImpl(final String copyClassName, final Project project, final Map<PsiFile, PsiClass[]> classes, final HashMap<PsiFile, String> map, final Object targetDirectory, final PsiDirectory defaultTargetDirectory, String commandName, final boolean selectInActivePanel, final boolean openInEditor) {
        final boolean[] result2 = new boolean[]{false};
        Runnable command = new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PsiDirectory target = targetDirectory instanceof PsiDirectory ? (PsiDirectory)targetDirectory : ((MoveDestination)targetDirectory).getTargetDirectory(defaultTargetDirectory);
                            Collection<PsiFile> files = CopyClassesHandler.doCopyClasses(classes, map, copyClassName, target, project);
                            if (files != null) {
                                if (openInEditor) {
                                    for (PsiFile file : files) {
                                        CopyHandler.updateSelectionInActiveProjectView((PsiElement)file, project, selectInActivePanel);
                                    }
                                    EditorHelper.openFilesInEditor((PsiElement[])((PsiElement[])files.toArray(new PsiFile[files.size()])));
                                }
                                result2[0] = true;
                            }
                        }
                        catch (IncorrectOperationException ex) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                                }
                            });
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        };
        CommandProcessor processor2 = CommandProcessor.getInstance();
        processor2.executeCommand(project, command, commandName, null);
        if (result2[0]) {
            ToolWindowManager.getInstance((Project)project).invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolWindowManager.getInstance((Project)project).activateEditorComponent();
                }
            });
        }
    }

    @Nullable
    public static Collection<PsiFile> doCopyClasses(Map<PsiFile, PsiClass[]> fileToClasses, String copyClassName, PsiDirectory targetDirectory, Project project) throws IncorrectOperationException {
        return CopyClassesHandler.doCopyClasses(fileToClasses, null, copyClassName, targetDirectory, project);
    }

    @Nullable
    public static Collection<PsiFile> doCopyClasses(Map<PsiFile, PsiClass[]> fileToClasses, @Nullable HashMap<PsiFile, String> map, String copyClassName, PsiDirectory targetDirectory, Project project) throws IncorrectOperationException {
        int[] nArray;
        PsiElement newElement = null;
        HashMap<PsiClass, PsiElement> oldToNewMap = new HashMap<PsiClass, PsiElement>();
        for (PsiClass[] psiClasses : fileToClasses.values()) {
            if (psiClasses == null) continue;
            for (PsiClass aClass : psiClasses) {
                if (CopyClassesHandler.isSynthetic(aClass)) continue;
                oldToNewMap.put(aClass, null);
            }
        }
        ArrayList<PsiFile> createdFiles = new ArrayList<PsiFile>(fileToClasses.size());
        if (fileToClasses.size() > 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        } else {
            nArray = null;
        }
        int[] choice = nArray;
        ArrayList<PsiFile> files = new ArrayList<PsiFile>();
        for (Map.Entry<PsiFile, PsiClass[]> entry : fileToClasses.entrySet()) {
            PsiFile psiFile = entry.getKey();
            PsiClass[] sources = entry.getValue();
            if (psiFile instanceof PsiClassOwner && sources != null) {
                PsiFile createdFile = CopyClassesHandler.copy(psiFile, targetDirectory, copyClassName, map == null ? null : map.get(psiFile), choice);
                if (createdFile == null) {
                    return null;
                }
                for (PsiClass destination : ((PsiClassOwner)createdFile).getClasses()) {
                    if (CopyClassesHandler.isSynthetic(destination)) continue;
                    PsiClass source = CopyClassesHandler.findByName(sources, destination.getName());
                    if (source != null) {
                        PsiClass copy = CopyClassesHandler.copy(source, copyClassName);
                        newElement = destination.replace((PsiElement)copy);
                        oldToNewMap.put(source, newElement);
                        continue;
                    }
                    destination.delete();
                }
                createdFiles.add(createdFile);
                continue;
            }
            files.add(psiFile);
        }
        for (PsiFile file : files) {
            try {
                PsiFile fileCopy;
                String relativePath;
                PsiDirectory finalTarget = targetDirectory;
                String string = relativePath = map != null ? map.get(file) : null;
                if (relativePath != null && !relativePath.isEmpty()) {
                    finalTarget = CopyClassesHandler.buildRelativeDir(targetDirectory, relativePath).findOrCreateTargetDirectory();
                }
                if ((fileCopy = CopyFilesOrDirectoriesHandler.copyToDirectory((PsiFileSystemItem)file, CopyClassesHandler.getNewFileName(file, copyClassName), finalTarget, choice)) == null) continue;
                createdFiles.add(fileCopy);
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e.getMessage());
            }
        }
        HashSet<PsiElement> rebindExpressions = new HashSet<PsiElement>();
        for (PsiElement element : oldToNewMap.values()) {
            if (element == null) {
                LOG.error(oldToNewMap.keySet());
                continue;
            }
            CopyClassesHandler.decodeRefs(element, oldToNewMap, rebindExpressions);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        for (PsiFile psiFile : createdFiles) {
            if (!(psiFile instanceof PsiJavaFile)) continue;
            codeStyleManager.removeRedundantImports((PsiJavaFile)psiFile);
        }
        for (PsiElement expression : rebindExpressions) {
            codeStyleManager.shortenClassReferences(expression);
        }
        new OptimizeImportsProcessor(project, createdFiles.toArray(new PsiFile[createdFiles.size()]), null).run();
        return createdFiles;
    }

    protected static boolean isSynthetic(PsiClass aClass) {
        return aClass instanceof SyntheticElement || !aClass.isPhysical();
    }

    private static PsiFile copy(@NotNull PsiFile file, PsiDirectory directory, String name, String relativePath, int[] choice) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/copy/CopyClassesHandler", "copy"));
        }
        String fileName = CopyClassesHandler.getNewFileName(file, name);
        if (relativePath != null && !relativePath.isEmpty()) {
            return CopyClassesHandler.buildRelativeDir(directory, relativePath).findOrCreateTargetDirectory().copyFileFrom(fileName, file);
        }
        if (CopyFilesOrDirectoriesHandler.checkFileExist(directory, choice, file, fileName, "Copy")) {
            return null;
        }
        return directory.copyFileFrom(fileName, file);
    }

    private static String getNewFileName(PsiFile file, String name) {
        if (name != null) {
            if (file instanceof PsiClassOwner) {
                for (PsiClass psiClass : ((PsiClassOwner)file).getClasses()) {
                    if (CopyClassesHandler.isSynthetic(psiClass)) continue;
                    return name + "." + file.getViewProvider().getVirtualFile().getExtension();
                }
            }
            return name;
        }
        return file.getName();
    }

    @NotNull
    private static MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper buildRelativeDir(@NotNull PsiDirectory directory, @NotNull String relativePath) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/refactoring/copy/CopyClassesHandler", "buildRelativeDir"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/refactoring/copy/CopyClassesHandler", "buildRelativeDir"));
        }
        MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper current = null;
        for (String pathElement : relativePath.split("/")) {
            current = current == null ? new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(directory, pathElement) : new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(current, pathElement);
        }
        LOG.assertTrue(current != null);
        MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper targetDirectoryWrapper = current;
        if (targetDirectoryWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/copy/CopyClassesHandler", "buildRelativeDir"));
        }
        return targetDirectoryWrapper;
    }

    private static PsiClass copy(PsiClass aClass, String name) {
        PsiClass classNavigationElement = (PsiClass)aClass.getNavigationElement();
        PsiClass classCopy = (PsiClass)classNavigationElement.copy();
        if (name != null) {
            classCopy.setName(name);
        }
        return classCopy;
    }

    @Nullable
    private static PsiClass findByName(PsiClass[] classes, String name) {
        if (name != null) {
            for (PsiClass aClass : classes) {
                if (!name.equals(aClass.getName())) continue;
                return aClass;
            }
        }
        return null;
    }

    private static void rebindExternalReferences(PsiElement element, Map<PsiClass, PsiElement> oldToNewMap, Set<PsiElement> rebindExpressions) {
        LocalSearchScope searchScope = new LocalSearchScope(element);
        for (PsiClass aClass : oldToNewMap.keySet()) {
            PsiElement newClass = oldToNewMap.get(aClass);
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope)) {
                rebindExpressions.add(reference.bindToElement(newClass));
            }
        }
    }

    private static void decodeRefs(@NotNull PsiElement element, final Map<PsiClass, PsiElement> oldToNewMap, Set<PsiElement> rebindExpressions) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/copy/CopyClassesHandler", "decodeRefs"));
        }
        final LinkedHashMap rebindMap = new LinkedHashMap();
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                CopyClassesHandler.decodeRef((PsiJavaCodeReferenceElement)expression, oldToNewMap, rebindMap);
                super.visitReferenceExpression(expression);
            }

            public void visitNewExpression(PsiNewExpression expression) {
                PsiJavaCodeReferenceElement referenceElement = expression.getClassReference();
                if (referenceElement != null) {
                    CopyClassesHandler.decodeRef(referenceElement, oldToNewMap, rebindMap);
                }
                super.visitNewExpression(expression);
            }

            public void visitTypeElement(PsiTypeElement type) {
                PsiJavaCodeReferenceElement referenceElement = type.getInnermostComponentReferenceElement();
                if (referenceElement != null) {
                    CopyClassesHandler.decodeRef(referenceElement, oldToNewMap, rebindMap);
                }
                super.visitTypeElement(type);
            }
        });
        for (Map.Entry entry : rebindMap.entrySet()) {
            rebindExpressions.add(((PsiJavaCodeReferenceElement)entry.getKey()).bindToElement((PsiElement)entry.getValue()));
        }
        CopyClassesHandler.rebindExternalReferences(element, oldToNewMap, rebindExpressions);
    }

    private static void decodeRef(PsiJavaCodeReferenceElement expression, Map<PsiClass, PsiElement> oldToNewMap, Map<PsiJavaCodeReferenceElement, PsiElement> rebindExpressions) {
        PsiClass psiClass;
        PsiElement resolved = expression.resolve();
        if (resolved instanceof PsiClass && oldToNewMap.containsKey(psiClass = (PsiClass)resolved)) {
            rebindExpressions.put(expression, oldToNewMap.get(psiClass));
        }
    }

    @Nullable
    private static PsiClass[] getTopLevelClasses(PsiElement element) {
        PsiClass[] psiClassArray;
        while (!(element == null || element instanceof PsiFile || element instanceof PsiClass && element.getParent() != null && ((PsiClass)element).getContainingClass() == null && !(element instanceof PsiAnonymousClass))) {
            element = element.getParent();
        }
        if (element instanceof PsiCompiledElement) {
            return null;
        }
        if (element instanceof PsiClassOwner) {
            PsiClass[] classes = ((PsiClassOwner)element).getClasses();
            ArrayList<PsiClass> buffer = new ArrayList<PsiClass>();
            for (PsiClass aClass : classes) {
                if (CopyClassesHandler.isSynthetic(aClass)) {
                    return null;
                }
                buffer.add(aClass);
            }
            return buffer.toArray(new PsiClass[buffer.size()]);
        }
        if (element instanceof PsiClass) {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = (PsiClass)element;
        } else {
            psiClassArray = null;
        }
        return psiClassArray;
    }
}

