/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceLeafValueClassNode;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SliceNullnessAnalyzer {
    private static void groupByNullness(NullAnalysisResult result2, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map) {
        SliceRootNode root = SliceNullnessAnalyzer.createNewTree(result2, oldRoot, map);
        SliceUsage rootUsage = (SliceUsage)((Object)((SliceNode)oldRoot.myCachedChildren.get(0)).getValue());
        SliceManager.getInstance(root.getProject()).createToolWindow(true, root, true, SliceManager.getElementDescription(null, rootUsage.getElement(), " Grouped by Nullness"));
    }

    @NotNull
    public static SliceRootNode createNewTree(NullAnalysisResult result2, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map) {
        SliceRootNode root = oldRoot.copy();
        assert (oldRoot.myCachedChildren.size() == 1);
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        root.setChanged();
        root.targetEqualUsages.clear();
        root.myCachedChildren = new ArrayList();
        SliceNullnessAnalyzer.createValueRootNode(result2, oldRoot, map, root, oldRootStart, "Null Values", NullAnalysisResult.NULLS);
        SliceNullnessAnalyzer.createValueRootNode(result2, oldRoot, map, root, oldRootStart, "NotNull Values", NullAnalysisResult.NOT_NULLS);
        SliceNullnessAnalyzer.createValueRootNode(result2, oldRoot, map, root, oldRootStart, "Other Values", NullAnalysisResult.UNKNOWNS);
        SliceRootNode sliceRootNode = root;
        if (sliceRootNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "createNewTree"));
        }
        return sliceRootNode;
    }

    private static void createValueRootNode(NullAnalysisResult result2, SliceRootNode oldRoot, final Map<SliceNode, NullAnalysisResult> map, SliceRootNode root, SliceNode oldRootStart, String nodeName, final int group) {
        Collection<PsiElement> groupedByValue = result2.groupedByValue[group];
        if (groupedByValue.isEmpty()) {
            return;
        }
        SliceLeafValueClassNode valueRoot = new SliceLeafValueClassNode(root.getProject(), root, nodeName);
        root.myCachedChildren.add(valueRoot);
        THashSet uniqueValues = new THashSet(groupedByValue, SliceLeafAnalyzer.LEAF_ELEMENT_EQUALITY);
        for (final PsiElement expression : uniqueValues) {
            SliceNode newRoot = SliceLeafAnalyzer.filterTree(oldRootStart, new NullableFunction<SliceNode, SliceNode>(){

                public SliceNode fun(SliceNode oldNode) {
                    if (oldNode.getDuplicate() != null) {
                        return null;
                    }
                    for (PsiElement nullSuspect : SliceNullnessAnalyzer.group(oldNode, map, group)) {
                        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nullSuspect, (PsiElement)expression)) continue;
                        return oldNode.copy();
                    }
                    return null;
                }
            }, new PairProcessor<SliceNode, List<SliceNode>>(){

                public boolean process(SliceNode node, List<SliceNode> children) {
                    if (!children.isEmpty()) {
                        return true;
                    }
                    PsiElement element = ((SliceUsage)((Object)node.getValue())).getElement();
                    if (element == null) {
                        return false;
                    }
                    return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)expression);
                }
            });
            valueRoot.myCachedChildren.add(new SliceLeafValueRootNode(root.getProject(), expression, valueRoot, Collections.singletonList(newRoot), ((SliceUsage)((Object)oldRoot.getValue())).params));
        }
    }

    public static void startAnalyzeNullness(final AbstractTreeStructure treeStructure, final Runnable finish) {
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref leafExpressions = Ref.create(null);
        final Map<SliceNode, NullAnalysisResult> map = SliceNullnessAnalyzer.createMap();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(root.getProject(), "Expanding all nodes... (may very well take the whole day)", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/slicer/SliceNullnessAnalyzer$3", "run"));
                }
                NullAnalysisResult l = SliceNullnessAnalyzer.calcNullableLeaves(root, treeStructure, map);
                leafExpressions.set((Object)l);
            }

            public void onCancel() {
                finish.run();
            }

            public void onSuccess() {
                try {
                    NullAnalysisResult leaves = (NullAnalysisResult)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    SliceNullnessAnalyzer.groupByNullness(leaves, root, map);
                }
                finally {
                    finish.run();
                }
            }
        });
    }

    public static Map<SliceNode, NullAnalysisResult> createMap() {
        return new FactoryMap<SliceNode, NullAnalysisResult>(){

            protected NullAnalysisResult create(SliceNode key) {
                return new NullAnalysisResult();
            }

            protected Map<SliceNode, NullAnalysisResult> createMap() {
                return ContainerUtil.newIdentityTroveMap();
            }
        };
    }

    private static NullAnalysisResult node(@NotNull SliceNode node, @NotNull Map<SliceNode, NullAnalysisResult> nulls) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/slicer/SliceNullnessAnalyzer", "node"));
        }
        if (nulls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nulls", "com/intellij/slicer/SliceNullnessAnalyzer", "node"));
        }
        return nulls.get(node);
    }

    private static Collection<PsiElement> group(@NotNull SliceNode node, @NotNull Map<SliceNode, NullAnalysisResult> nulls, int group) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/slicer/SliceNullnessAnalyzer", "group"));
        }
        if (nulls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nulls", "com/intellij/slicer/SliceNullnessAnalyzer", "group"));
        }
        return nulls.get((Object)node).groupedByValue[group];
    }

    @NotNull
    public static NullAnalysisResult calcNullableLeaves(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final @NotNull Map<SliceNode, NullAnalysisResult> map) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/slicer/SliceNullnessAnalyzer", "calcNullableLeaves"));
        }
        if (treeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeStructure", "com/intellij/slicer/SliceNullnessAnalyzer", "calcNullableLeaves"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/slicer/SliceNullnessAnalyzer", "calcNullableLeaves"));
        }
        final SliceLeafAnalyzer.SliceNodeGuide guide = new SliceLeafAnalyzer.SliceNodeGuide(treeStructure);
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            public void visit(final @NotNull SliceNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceNullnessAnalyzer$5", "visit"));
                }
                element.calculateDupNode();
                SliceNullnessAnalyzer.node(element, map).clear();
                SliceNode duplicate = element.getDuplicate();
                if (duplicate != null) {
                    SliceNullnessAnalyzer.node(element, map).add(SliceNullnessAnalyzer.node(duplicate, map));
                } else {
                    final PsiElement value = (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

                        public PsiElement compute() {
                            return ((SliceUsage)((Object)element.getValue())).getElement();
                        }
                    });
                    Nullness nullness = (Nullness)((Object)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Nullness>(){

                        public Nullness compute() {
                            return SliceNullnessAnalyzer.checkNullness(value);
                        }
                    }));
                    if (nullness == Nullness.NULLABLE) {
                        SliceNullnessAnalyzer.group(element, map, NullAnalysisResult.NULLS).add(value);
                    } else if (nullness == Nullness.NOT_NULL) {
                        SliceNullnessAnalyzer.group(element, map, NullAnalysisResult.NOT_NULLS).add(value);
                    } else {
                        Collection children = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<? extends AbstractTreeNode>>(){

                            public Collection<? extends AbstractTreeNode> compute() {
                                return element.getChildren();
                            }
                        });
                        if (children.isEmpty()) {
                            SliceNullnessAnalyzer.group(element, map, NullAnalysisResult.UNKNOWNS).add(value);
                        }
                        super.visit((Object)element);
                    }
                }
            }

            public void elementFinished(@NotNull SliceNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceNullnessAnalyzer$5", "elementFinished"));
                }
                SliceNode parent = guide.getParent(element);
                if (parent != null) {
                    SliceNullnessAnalyzer.node(parent, map).add(SliceNullnessAnalyzer.node(element, map));
                }
            }
        };
        walkingState.visit((Object)root);
        NullAnalysisResult nullAnalysisResult = SliceNullnessAnalyzer.node(root, map);
        if (nullAnalysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "calcNullableLeaves"));
        }
        return nullAnalysisResult;
    }

    @NotNull
    private static Nullness checkNullness(PsiElement element) {
        Nullness result2;
        PsiElement value = element;
        if (value instanceof PsiExpression) {
            value = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiExpression)value));
        }
        if (value instanceof PsiLiteralExpression) {
            Nullness nullness = ((PsiLiteralExpression)value).getValue() == null ? Nullness.NULLABLE : Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        if (value instanceof PsiNewExpression) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        if (value instanceof PsiThisExpression) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        if (value instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)value).resolveMethod();
            if (method != null && NullableNotNullManager.isNotNull((PsiModifierListOwner)method)) {
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
                }
                return nullness;
            }
            if (method != null && NullableNotNullManager.isNullable((PsiModifierListOwner)method)) {
                Nullness nullness = Nullness.NULLABLE;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
                }
                return nullness;
            }
        }
        if (value instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)value).getOperationTokenType() == JavaTokenType.PLUS) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        PsiElement context = value;
        if (value instanceof PsiReference) {
            PsiElement resolved = ((PsiReference)value).resolve();
            if (resolved instanceof PsiCompiledElement) {
                resolved = resolved.getNavigationElement();
            }
            value = resolved;
        }
        if (value instanceof PsiParameter && ((PsiParameter)value).getDeclarationScope() instanceof PsiCatchSection) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        if ((value instanceof PsiLocalVariable || value instanceof PsiParameter) && (result2 = DfaUtil.checkNullness((PsiVariable)value, context)) != Nullness.UNKNOWN) {
            Nullness nullness = result2;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        if (value instanceof PsiModifierListOwner) {
            if (NullableNotNullManager.isNotNull((PsiModifierListOwner)((PsiModifierListOwner)value))) {
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
                }
                return nullness;
            }
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)((PsiModifierListOwner)value))) {
                Nullness nullness = Nullness.NULLABLE;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
                }
                return nullness;
            }
        }
        if (value instanceof PsiEnumConstant) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNullnessAnalyzer", "checkNullness"));
        }
        return nullness;
    }

    static class NullAnalysisResult {
        public static int NULLS = 0;
        public static int NOT_NULLS = 1;
        public static int UNKNOWNS = 2;
        public final Collection<PsiElement>[] groupedByValue = new Collection[]{new THashSet(), new THashSet(), new THashSet()};

        NullAnalysisResult() {
        }

        public void clear() {
            for (Collection<PsiElement> elements : this.groupedByValue) {
                elements.clear();
            }
        }

        private void add(NullAnalysisResult duplicate) {
            for (int i = 0; i < this.groupedByValue.length; ++i) {
                Collection<PsiElement> elements = this.groupedByValue[i];
                Collection<PsiElement> other = duplicate.groupedByValue[i];
                elements.addAll(other);
            }
        }
    }
}

