/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;

public class SynchronizationUtil {
    private SynchronizationUtil() {
    }

    public static boolean isInSynchronizedContext(PsiElement element) {
        PsiModifierListOwner modifierListOwner;
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiSynchronizedStatement.class, PsiClass.class, PsiLambdaExpression.class});
        if (context instanceof PsiSynchronizedStatement) {
            return true;
        }
        if (context instanceof PsiMethod && (modifierListOwner = (PsiModifierListOwner)context).hasModifierProperty("synchronized")) {
            return true;
        }
        if (context instanceof PsiMethod || context instanceof PsiLambdaExpression) {
            HoldsLockAssertionVisitor visitor = new HoldsLockAssertionVisitor();
            context.accept((PsiElementVisitor)visitor);
            PsiAssertStatement assertStatement = visitor.getAssertStatement();
            return assertStatement != null && assertStatement.getTextOffset() + assertStatement.getTextLength() < element.getTextOffset();
        }
        return false;
    }

    public static boolean isCallToHoldsLock(PsiExpression expression) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!"holdsLock".equals(name)) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Thread");
    }

    private static class HoldsLockAssertionVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private PsiAssertStatement myAssertStatement = null;

        private HoldsLockAssertionVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            if (this.myAssertStatement != null) {
                return;
            }
            super.visitAssertStatement(statement);
            PsiExpression condition = statement.getAssertCondition();
            if (SynchronizationUtil.isCallToHoldsLock(condition)) {
                this.myAssertStatement = statement;
                this.stopWalking();
            }
        }

        public PsiAssertStatement getAssertStatement() {
            return this.myAssertStatement;
        }
    }
}

