/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.net.InetAddresses;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.UriUtil;
import com.intellij.util.io.URLUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.ide.HttpRequestHandler;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001\u0001\u0004\u0001\u0011\re\t\u0001\u0014AO\u0001\r\u0005\u0016\u0011kA\u0001\t\u0003\u0015BAa\u0003E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001dA\u0013\u0011\t-A9!D\u0001\u0019\u0005e\u0019\u0001\u0002B\u0007\u00021\u0013I2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001\u0005\u0006\u001b\u0005AZ\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/BuiltInWebServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "Companion"}, moduleName="built-in-server")
public final class BuiltInWebServer
extends HttpRequestHandler {
    @NotNull
    public static final Logger LOG;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.builtInWebServer.BuiltInWebServer$Companion.INSTANCE;
        LOG = Logger.getInstance(BuiltInWebServer.class);
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return super.isSupported(request) || Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        String projectName;
        boolean isIpv6;
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String host = request.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
        if (StringsKt.isNullOrEmpty((String)host)) {
            return false;
        }
        int portIndex = StringsKt.indexOf$default((String)host, (char)':', (int)0, (boolean)false, (int)6);
        if (portIndex > 0) {
            host = StringsKt.substring((String)host, (int)0, (int)portIndex);
        }
        boolean bl = isIpv6 = CollectionsKt.charAt((CharSequence)host, (int)0) == '[' && CollectionsKt.length((CharSequence)host) > 2 && CollectionsKt.charAt((CharSequence)host, (int)(CollectionsKt.length((CharSequence)host) - 1)) == ']';
        if (isIpv6) {
            host = StringsKt.substring((String)host, (int)1, (int)(CollectionsKt.length((CharSequence)host) - 1));
        }
        if (!isIpv6 && !InetAddresses.isInetAddress((String)host)) {
            String string = host;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"host");
            if (!BuiltInWebServerKt.isOwnHostName(string) && !StringsKt.endsWith$default((String)host, (String)".ngrok.io", (boolean)false, (int)2)) {
                projectName = host;
                return BuiltInWebServer.Companion.doProcess(request, context, projectName);
            }
        }
        if (CollectionsKt.length((CharSequence)urlDecoder.path()) < 2) {
            return false;
        }
        projectName = null;
        return BuiltInWebServer.Companion.doProcess(request, context, projectName);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001b\u0002\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)\u0013\u0003B\u0001\t\t5\t\u0001\u0014B\r\u0004\u0011\u0015i\u0011\u0001g\u0003\u001a\u0007!1Q\"\u0001M\u00073\u0011Aq!\u0004\u0002\r\u0002a=\u00116\u0004\u0003D\u0011!\rQr\u0001\r\u0003#\u000e\tAQA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\rA9\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/BuiltInWebServer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "doProcess", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectNameAsHost", ""}, moduleName="built-in-server")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        /*
         * Unable to fully structure code
         */
        private final boolean doProcess(FullHttpRequest request, ChannelHandlerContext context, String projectNameAsHost) {
            block14: {
                decodedPath = URLUtil.unescapePercentSequences((String)UriUtil.trimParameters(request.uri()));
                offset = new Ref.IntRef();
                emptyPath = new Ref.BooleanRef();
                isCustomHost = projectNameAsHost != null;
                projectName = new Ref.ObjectRef();
                if (isCustomHost) {
                    v0 = projectNameAsHost;
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    projectName.element = v0;
                    offset.element = 0;
                    emptyPath.element = StringsKt.isEmpty((String)decodedPath);
                } else {
                    offset.element = StringsKt.indexOf$default((String)decodedPath, (char)'/', (int)1, (boolean)false, (int)4);
                    projectName.element = StringsKt.substring((String)decodedPath, (int)1, (int)(offset.element == -1 ? CollectionsKt.length((CharSequence)decodedPath) : offset.element));
                    emptyPath.element = offset.element == -1;
                }
                var9_9 = new Ref.ObjectRef();
                var9_9.element = null;
                var11_10 = ProjectManager.getInstance().getOpenProjects();
                for (var12_11 = 0; var12_11 < ((void)$receiver).length; ++var12_11) {
                    block16: {
                        block17: {
                            block15: {
                                element = $receiver[var12_11];
                                project = (Project)element;
                                if (!project.isDisposed()) break block15;
                                v1 = false;
                                break block16;
                            }
                            name = project.getName();
                            if (!isCustomHost) break block17;
                            if (!StringsKt.equals((String)((String)projectName.element), (String)project.getName(), (boolean)true)) ** GOTO lbl-1000
                            v1 = true;
                            break block16;
                        }
                        v2 = name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"name");
                        if (!StringsKt.regionMatches((String)decodedPath, (int)1, (String)v2, (int)0, (int)CollectionsKt.length((CharSequence)name), (boolean)(SystemInfoRt.isFileSystemCaseSensitive == false))) ** GOTO lbl-1000
                        v3 = emptyPathCandidate = CollectionsKt.length((CharSequence)decodedPath) == CollectionsKt.length((CharSequence)name) + 1;
                        if (emptyPathCandidate || CollectionsKt.charAt((CharSequence)decodedPath, (int)(CollectionsKt.length((CharSequence)name) + 1)) == '/') {
                            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                            projectName.element = projectName.element;
                            offset.element = CollectionsKt.length((CharSequence)name) + 1;
                            emptyPath.element = emptyPathCandidate;
                            v1 = true;
                        } else lbl-1000:
                        // 3 sources

                        {
                            if ((Project)candidateByDirectoryName.element == null && BuiltInWebServerKt.compareNameAndProjectBasePath((String)projectName.element, project)) {
                                candidateByDirectoryName.element = project;
                            }
                            v1 = false;
                        }
                    }
                    if (!v1) continue;
                    v4 = element;
                    break block14;
                }
                v4 = null;
            }
            if ((v5 = (Project)v4) == null) {
                v5 = (Project)candidateByDirectoryName.element;
            }
            if (v5 == null) {
                return false;
            }
            project = v5;
            if (emptyPath.element) {
                if (!SystemInfoRt.isFileSystemCaseSensitive) {
                    v6 = project.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"project.name");
                    projectName.element = v6;
                }
                WebServerPathHandler.redirectToDirectory((HttpRequest)request, context.channel(), (String)projectName.element);
                return true;
            }
            path = FileUtil.toCanonicalPath((String)StringsKt.substring((String)decodedPath, (int)(offset.element + 1)), (char)'/');
            var14_15 = (WebServerPathHandler[])WebServerPathHandler.EP_NAME.getExtensions();
            for (var13_14 = 0; var13_14 < var14_15.length; ++var13_14) {
                pathHandler = var14_15[var13_14];
                try {
                    if (!pathHandler.process(path, project, request, context, (String)projectName.element, decodedPath, isCustomHost)) continue;
                    return true;
                }
                catch (Throwable e) {
                    this.getLOG().error(e);
                }
            }
            return false;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

