/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.Responses;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rA!\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!J\u0011\u0005\u0017!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)\u0011d\u0001E\u0006\u001b\u0005Ab!\u0007\u0003\t\u000e5\u0011A\u0012\u0001\r\u00043\rAq!D\u0001\u0019\u0007e\u0019\u0001rB\u0007\u00021\t\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/DefaultWebServerPathHandler;", "Lorg/jetbrains/builtInWebServer/WebServerPathHandler;", "()V", "process", "", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectName", "decodedRawPath", "isCustomHost"}, moduleName="built-in-server")
public final class DefaultWebServerPathHandler
extends WebServerPathHandler {
    @Override
    public boolean process(@NotNull String path, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @Nullable String projectName, @NotNull String decodedRawPath, boolean isCustomHost) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)decodedRawPath, (String)"decodedRawPath");
        Channel channel = context.channel();
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        PathInfo pathInfo = (PathInfo)pathToFileManager.getPathToInfoCache().getIfPresent((Object)path);
        boolean indexUsed = false;
        if (pathInfo == null || !pathInfo.isValid()) {
            pathInfo = pathToFileManager.doFindByRelativePath$built_in_server(path);
            if (pathInfo == null) {
                if (StringsKt.isEmpty((String)path)) {
                    Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, "Index file doesn't exist.", (HttpRequest)request);
                    return true;
                }
                return false;
            }
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)pathInfo);
        }
        if (pathInfo.isDirectory()) {
            if (!FileUtilKt.endsWithSlash(decodedRawPath)) {
                WebServerPathHandler.redirectToDirectory((HttpRequest)request, channel, isCustomHost ? path : projectName + "/" + path);
                return true;
            }
            VirtualFile virtualFile = pathInfo.getFile();
            if (virtualFile == null) {
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                File file = pathInfo.getIoFile();
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                virtualFile = localFileSystem.refreshAndFindFileByIoFile(file);
            }
            VirtualFile virtualFile2 = virtualFile;
            VirtualFile virtualFile3 = virtualFile2 = virtualFile2 == null ? (VirtualFile)null : BuiltInWebServerKt.findIndexFile(virtualFile2);
            if (virtualFile2 == null) {
                Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, "Index file doesn't exist.", (HttpRequest)request);
                return true;
            }
            indexUsed = true;
            pathInfo = new PathInfo((File)null, virtualFile2, pathInfo.getRoot(), pathInfo.getModuleName(), pathInfo.isLibrary());
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)pathInfo);
        }
        if (!indexUsed && !FileUtilKt.endsWithName(path, pathInfo.getName())) {
            if (FileUtilKt.endsWithSlash(decodedRawPath)) {
                indexUsed = true;
            } else {
                String parentPath = FileUtilKt.getParentPath(pathInfo.getPath());
                if (parentPath != null) {
                    String string = PathUtilRt.getFileName((String)parentPath);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getFileName(parentPath)");
                    if (FileUtilKt.endsWithName(path, string)) {
                        WebServerPathHandler.redirectToDirectory((HttpRequest)request, channel, isCustomHost ? path : projectName + "/" + path);
                        return true;
                    }
                }
            }
        }
        StringBuilder canonicalRequestPath = new StringBuilder();
        canonicalRequestPath.append('/');
        if (!isCustomHost) {
            canonicalRequestPath.append(projectName).append('/');
        }
        canonicalRequestPath.append(path);
        if (indexUsed) {
            canonicalRequestPath.append('/').append(pathInfo.getName());
        }
        WebServerFileHandler[] webServerFileHandlerArray = (WebServerFileHandler[])WebServerFileHandler.EP_NAME.getExtensions();
        for (int i = 0; i < webServerFileHandlerArray.length; ++i) {
            WebServerFileHandler fileHandler = webServerFileHandlerArray[i];
            try {
                if (!fileHandler.process(pathInfo, canonicalRequestPath, project, request, channel, isCustomHost)) continue;
                return true;
            }
            catch (Throwable e) {
                BuiltInWebServer.Companion.getLOG().error(e);
            }
        }
        return false;
    }
}

