/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.io.Responses;

public abstract class WebServerPathHandler {
    static final ExtensionPointName<WebServerPathHandler> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.webServerPathHandler");

    public abstract boolean process(@NotNull String var1, @NotNull Project var2, @NotNull FullHttpRequest var3, @NotNull ChannelHandlerContext var4, @Nullable String var5, @NotNull String var6, boolean var7);

    protected static void redirectToDirectory(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull String path) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/WebServerPathHandler", "redirectToDirectory"));
        }
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/builtInWebServer/WebServerPathHandler", "redirectToDirectory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/WebServerPathHandler", "redirectToDirectory"));
        }
        FullHttpResponse response = Responses.response(HttpResponseStatus.MOVED_PERMANENTLY);
        URI url = VfsUtil.toUri((String)("http://" + request.headers().getAsString((CharSequence)HttpHeaderNames.HOST) + '/' + path + '/'));
        BuiltInWebServer.LOG.assertTrue(url != null);
        response.headers().add((CharSequence)HttpHeaderNames.LOCATION, (Object)url.toASCIIString());
        Responses.send((HttpResponse)response, channel, request);
    }
}

