/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.PropertyMetadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebugProcessImpl$WhenMappings;
import org.jetbrains.debugger.DebugProcessImpl$_breakpointHandlers$1;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.SuspendContextImpl;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0004)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0012\u0015\tA\"A\u0003\u0002\t\u0011)\u0011\u0001c\u0003\u0006\u0003\u0011%Q!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tA\u0001B\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\t\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001C\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0007\tMa\u0001!\u0006\u0004\u0005\u0001!\u0005QcA\u0005\u0002\t\u0007A\u0012!G\u0001\u0019\u0004\u0005V\u0012b\u0001\u0005\u0003\u001b\u0005A*!C\u0002\t\u00075\tA\u0004A\u0005\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\n\r!%Q\u0002B\u0005\u0002\t\u0007a\t\u0001G\u0003\n\t!-QB\u0001G\u00011\u0019\t6!\u0001E\u0007KM!\u0011\u0001c\u0011\u000e\u0003a\u0011\u0013$\u0002E#\u001b\rI\u0011\u0001b\u0001\u0019Ge!\u0001rI\u0007\u0003\u0019\u0003AB%G\u0002\tJ5\t\u0001$J\u0013\u0004\u0011\u0017j\u0011\u0001'\u0007&\u0011\u0011Q\u0001BJ\u0007\u00021\tJ2\u0001#\u0014\u000e\u0003a%Ru\u0003\u0003\u0013\u0011\u001dja!\u0003\u0003\n\u0007%\tA1\u0001\r\t1\u001f\t6!\u0001\u0005\nK\u0011!!\u0002c\u0014\u000e\u0003aIR\u0015\t\u0005)\u001bqI!\"C\u0005\n\u0003\u0011\r\u0001\u0013K\u000b\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0011aA\u0001\u0013K\u000b\u000f\u0013-!\t!C\u0005\n\u0003\u0011\r\u0001\u0013K\u000b\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0011aAA\u0012\u0001M\b1\u001f\t6!\u0001\u0005\nK\u001bA\u0011&$\u0003\r\u0002aM\u0013kA\u0001\u0005U\u0015.\u0001RKG\u00041\u0011\n6!\u0001\u0003,K\rA9&D\u0001\u0019\t\u0015\nBa\u0005\u0005-\u001b\u0011I!!C\u0001\u0019[ae\u0013$\u0002E#\u001b\rI\u0011\u0001b\u0001\u0019\\e\u0019\u0001BL\u0007\u000213)c\u0001#\u0018\u000e\t%\tA1\u0001G\u00011\u0015)3\u0001C\u0018\u000e\u0003aeQ\u0005\u0002\u0003\u000b\u0011?j\u0011\u0001'\u0007&%\u0011\u0011\u0001\u0002M\u0007\u00021\tJ2\u0001#\u0013\u000e\u0003a\u0005\u0014$\u0002E#\u001b\rI\u0011\u0001b\u0001\u0019Ge\u0019\u0001\"M\u0007\u00021G*#\u0003B\u0001\te5\t\u0001DI\r\u0006\u0011\u000bj1!C\u0001\u0005\u0004a\u0019\u0013d\u0001\u00052\u001b\u0005A\u001a'G\u0002\tJ5\t\u0001\u0014M\u0013\u0004\u0011Kj\u0011\u0001\u0007\u0012&\u0017!\u0019T\"\u0001\r#3\rA9'D\u0001\u0019<e\u0019\u0001\u0002N\u0007\u00021y)C\u0001\u0002\u0002\tj5\t\u0001DI\u0013\u0004\u0011Uj\u0011\u0001\u0007\u0012&\u0007!-T\"\u0001\r#K\rAa'D\u0001\u0019E\u0015\u001a\u0001RN\u0007\u00021\t*3\u0001C\u001c\u000e\u0003a\u0011S\u0005\u0002\u0003\u0002\u0011_j\u0011\u0001\u0007\u0012*%\u0011\t\u0005\u0002C\u0004\u000e\r%!\u0011bA\u0005\u0002\t\u0007A\u0002\u0002g\u0004\u001dCE\u001ba!\u0002\u0002\u0005\u0014!QQB\u0001C\t\u0011%I3\u0002B\"\t\u0011\ri\u0011\u0001\b\u0001R\u0007\u0015)\u0011\u0001c\u0006\u000e\u0005\u0011U\u0001bC\u0015\u0010\t\u000bc\u0002\u0002D\u0007\u000213a\"\u0001\t\u0002R\u0007\u001d)\u0001!\u0004\u0002\u0005\u001b!m\u0011C\u0001\u0003\u000f\u0011;Is\u0001B!\t\u0011\u000fi\u0011\u0001\u0007\u0003R\u0007\u0005)\u0001!K\u0006\u0005\u0005\"AY!\u0004\u0002\r\u0002a1\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0004E\u0010S=!)\t\b\u0005\u0011\u001b\u0005AJ\u0002\b\u0002!\u0005E\u001bq!\u0002\u0001\u000e\u0005\u0011\u0001\u00022D\t\u0003\tCAi\"\u000b\t\u0005\u0006rA\u0011#\u0004\u0002\r\u0002a\rBD\u0001\u0011\u0003#\u000e9Q\u0001A\u0007\u0003\tIA)#\u0005\u0002\u0005'!\u001d\u0012\u0006\u0005CC9!!RB\u0001G\u00011Sa\"\u0001\t\u0002R\u0007\u001d)\u0001!\u0004\u0002\u0005+!-\u0012C\u0001\u0003\u0017\u0011[IS\u0002B\"\u001d\u0011]i\u0011\u0001'\u0007R\u0007\u001d)\u0001!\u0004\u0002\u00050!m\u0011C\u0001\u0003\u0019\u0011;I3\u0002\u0002\"\t\u0011ci!\u0001$\u0001\u00193q\u0011\u0013kA\u0002\u000e\u0005\u0011M\u0002BG\u0015\u000b\t\tC\u0001RG\u0007\u00021m\t6\u0001B\u0003\u0001\u001b\t!9\u0004\u0003\u000f*\u0015\u0011\t\u0005\u0002#\u0003\u000e\t%\tA1\u0001G\u00011\u0015\t6!A\u0003\u0001SA!!\t\u0003E\u001d\u001b\u001dI!!C\u0001\u0019<%\u0011\u0011\"\u0001\r\u001f1u\t6\u0001B\u0003\u0001\u001b\t!i\u0004C\u0010*\u0017\u0011\u0019\u0005\u0002c\u0010\u000e\u00051\u0005\u0001\u0004\t\u000f$#\u000e\u0019QB\u0001C!\u0011\u0005\u0002"}, strings={"Lorg/jetbrains/debugger/DebugProcessImpl;", "C", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lcom/intellij/xdebugger/XDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "connection", "editorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "smartStepIntoHandler", "Lcom/intellij/xdebugger/stepping/XSmartStepIntoHandler;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "(Lcom/intellij/xdebugger/XDebugSession;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;Lcom/intellij/xdebugger/stepping/XSmartStepIntoHandler;Lcom/intellij/execution/ExecutionResult;)V", "_breakpointHandlers", "", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "get_breakpointHandlers", "()[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "_breakpointHandlers$delegate", "Lkotlin/Lazy;", "getConnection", "()Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/connection/VmConnection;", "disableDoNotStepIntoLibraries", "", "getDisableDoNotStepIntoLibraries", "()Z", "setDisableDoNotStepIntoLibraries", "(Z)V", "getExecutionResult", "()Lcom/intellij/execution/ExecutionResult;", "isForceStep", "setForceStep", "lastCallFrame", "Lorg/jetbrains/debugger/CallFrame;", "getLastCallFrame", "()Lorg/jetbrains/debugger/CallFrame;", "setLastCallFrame", "(Lorg/jetbrains/debugger/CallFrame;)V", "lastStep", "Lorg/jetbrains/debugger/StepAction;", "getLastStep", "()Lorg/jetbrains/debugger/StepAction;", "setLastStep", "(Lorg/jetbrains/debugger/StepAction;)V", "processBreakpointConditionsAtIdeSide", "getProcessBreakpointConditionsAtIdeSide", "setProcessBreakpointConditionsAtIdeSide", "realProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "getRealProcessHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "repeatStepInto", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getRepeatStepInto", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "urlToFileCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/util/Url;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getUrlToFileCache", "()Ljava/util/concurrent/ConcurrentMap;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "breakpointReached", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "evaluatedLogExpression", "", "suspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "checkCanPerformCommands", "continueVm", "stepAction", "createBreakpointHandlers", "doGetProcessHandler", "getBreakpointHandlers", "kotlin.jvm.PlatformType", "getCurrentStateHyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "Lorg/jetbrains/annotations/Nullable;", "getCurrentStateMessage", "Lorg/jetbrains/annotations/NotNull;", "getEditorsProvider", "getLocationsForBreakpoint", "", "Lorg/jetbrains/debugger/Location;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "onlySourceMappedBreakpoints", "getSmartStepIntoHandler", "isValuesCustomSorted", "isVmStepOutCorrect", "processBreakpoint", "Lorg/jetbrains/debugger/SuspendContext;", "xSuspendContext", "Lorg/jetbrains/debugger/frame/SuspendContextImpl;", "processBreakpointLogExpressionAndSuspend", "resume", "saveResolvedFile", "url", "file", "setOverlay", "startForceStepInto", "startPausing", "startStepInto", "startStepOut", "startStepOver", "updateLastCallFrame"}, moduleName="script-debugger-ui")
public abstract class DebugProcessImpl<C extends VmConnection<?>>
extends XDebugProcess {
    @NotNull
    private final AtomicBoolean repeatStepInto;
    @Nullable
    private volatile StepAction lastStep;
    @Nullable
    private volatile CallFrame lastCallFrame;
    private volatile boolean isForceStep;
    private volatile boolean disableDoNotStepIntoLibraries;
    @NotNull
    private final ConcurrentMap<Url, VirtualFile> urlToFileCache;
    private boolean processBreakpointConditionsAtIdeSide;
    private final Lazy<? extends XBreakpointHandler<?>[]> _breakpointHandlers$delegate;
    @NotNull
    private final C connection;
    private final XDebuggerEditorsProvider editorsProvider;
    private final XSmartStepIntoHandler<?> smartStepIntoHandler;
    @Nullable
    private final ExecutionResult executionResult;
    private static final /* synthetic */ PropertyMetadata[] $delegatedProperties;

    @NotNull
    protected final AtomicBoolean getRepeatStepInto() {
        return this.repeatStepInto;
    }

    @Nullable
    protected final StepAction getLastStep() {
        return this.lastStep;
    }

    protected final void setLastStep(@Nullable StepAction stepAction) {
        this.lastStep = stepAction;
    }

    @Nullable
    protected final CallFrame getLastCallFrame() {
        return this.lastCallFrame;
    }

    protected final void setLastCallFrame(@Nullable CallFrame callFrame) {
        this.lastCallFrame = callFrame;
    }

    protected final boolean isForceStep() {
        return this.isForceStep;
    }

    protected final void setForceStep(boolean bl) {
        this.isForceStep = bl;
    }

    protected final boolean getDisableDoNotStepIntoLibraries() {
        return this.disableDoNotStepIntoLibraries;
    }

    protected final void setDisableDoNotStepIntoLibraries(boolean bl) {
        this.disableDoNotStepIntoLibraries = bl;
    }

    @NotNull
    protected final ConcurrentMap<Url, VirtualFile> getUrlToFileCache() {
        return this.urlToFileCache;
    }

    public final boolean getProcessBreakpointConditionsAtIdeSide() {
        return this.processBreakpointConditionsAtIdeSide;
    }

    public final void setProcessBreakpointConditionsAtIdeSide(boolean bl) {
        this.processBreakpointConditionsAtIdeSide = bl;
    }

    private final XBreakpointHandler<?>[] get_breakpointHandlers() {
        return (XBreakpointHandler[])LazyKt.getValue(this._breakpointHandlers$delegate, (Object)((Object)this), (KProperty)((KProperty)$delegatedProperties[0]));
    }

    @Nullable
    protected final ProcessHandler getRealProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        return executionResult != null ? executionResult.getProcessHandler() : null;
    }

    @Nullable
    public final XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.smartStepIntoHandler;
    }

    public final XBreakpointHandler<?>[] getBreakpointHandlers() {
        XBreakpointHandler[] xBreakpointHandlerArray;
        switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$1[((VmConnection)this.connection).getState().getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                xBreakpointHandlerArray = XBreakpointHandler.EMPTY_ARRAY;
                break;
            }
            default: {
                xBreakpointHandlerArray = this.get_breakpointHandlers();
            }
        }
        return xBreakpointHandlerArray;
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    @Nullable
    public final Vm getVm() {
        return ((VmConnection)this.connection).getVm();
    }

    @NotNull
    protected abstract XBreakpointHandler<?>[] createBreakpointHandlers();

    private final void updateLastCallFrame() {
        Object object = this.getVm();
        this.lastCallFrame = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null ? object.getTopFrame() : null;
    }

    public final boolean checkCanPerformCommands() {
        return this.getVm() != null;
    }

    public final boolean isValuesCustomSorted() {
        return true;
    }

    public final void startStepOver() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.OVER);
    }

    public final void startForceStepInto() {
        this.isForceStep = true;
        this.startStepInto();
    }

    public final void startStepInto() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.IN);
    }

    public final void startStepOut() {
        if (this.isVmStepOutCorrect()) {
            this.lastCallFrame = null;
        } else {
            this.updateLastCallFrame();
        }
        this.continueVm(StepAction.OUT);
    }

    protected boolean isVmStepOutCorrect() {
        return true;
    }

    public final void resume() {
        this.continueVm(StepAction.CONTINUE);
    }

    protected void continueVm(@NotNull StepAction stepAction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stepAction), (String)"stepAction");
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContextManager<? extends CallFrame> suspendContextManager = vm.getSuspendContextManager();
        if (stepAction == StepAction.CONTINUE) {
            if (suspendContextManager.getContext() == null) {
                return;
            }
            this.lastStep = null;
            this.lastCallFrame = null;
            this.urlToFileCache.clear();
            this.disableDoNotStepIntoLibraries = false;
        } else {
            this.lastStep = stepAction;
        }
        suspendContextManager.continueVm(stepAction, 1);
    }

    protected final void setOverlay() {
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        vm.getSuspendContextManager().setOverlayMessage("Paused in debugger");
    }

    protected final void processBreakpoint(@NotNull SuspendContext suspendContext, @NotNull XBreakpoint<?> breakpoint, @NotNull SuspendContextImpl xSuspendContext) {
        String condition;
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)((Object)xSuspendContext), (String)"xSuspendContext");
        XExpression xExpression = breakpoint.getConditionExpression();
        String string = condition = xExpression != null ? xExpression.getExpression() : null;
        if (!this.processBreakpointConditionsAtIdeSide || condition == null) {
            this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
        } else {
            xSuspendContext.evaluateExpression(condition).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                protected void consume(@NotNull String evaluationResult, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)evaluationResult, (String)"evaluationResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    if (Intrinsics.areEqual((Object)"false", (Object)evaluationResult)) {
                        this.this$0.resume();
                    } else {
                        DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, xSuspendContext, suspendContext, suspendContext){
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;
                final /* synthetic */ SuspendContext $suspendContext;

                protected void consume(@NotNull Throwable failure, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend(this.this$0, this.$breakpoint, this.$xSuspendContext, this.$suspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    this.$suspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void processBreakpointLogExpressionAndSuspend(XBreakpoint<?> breakpoint, SuspendContextImpl xSuspendContext, SuspendContext suspendContext) {
        String logExpression;
        XExpression xExpression = breakpoint.getLogExpressionObject();
        String string = logExpression = xExpression != null ? xExpression.getExpression() : null;
        if (logExpression == null) {
            this.breakpointReached(breakpoint, null, xSuspendContext);
        } else {
            xSuspendContext.evaluateExpression(logExpression).done((Consumer)new ContextDependentAsyncResultConsumer<String>(this, breakpoint, xSuspendContext, suspendContext){
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                protected void consume(@NotNull String logResult, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached(this.this$0, this.$breakpoint, logResult, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$xSuspendContext = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            }).rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(this, breakpoint, logExpression, xSuspendContext, suspendContext){
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint;
                final /* synthetic */ String $logExpression;
                final /* synthetic */ SuspendContextImpl $xSuspendContext;

                protected void consume(@NotNull Throwable logResult, @NotNull Vm vm) {
                    Intrinsics.checkParameterIsNotNull((Object)logResult, (String)"logResult");
                    Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                    DebugProcessImpl.access$breakpointReached(this.this$0, this.$breakpoint, "Failed to evaluate expression: " + this.$logExpression, this.$xSuspendContext);
                }
                {
                    this.this$0 = $outer;
                    this.$breakpoint = $captured_local_variable$1;
                    this.$logExpression = $captured_local_variable$2;
                    this.$xSuspendContext = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    private final void breakpointReached(XBreakpoint<?> breakpoint, String evaluatedLogExpression, XSuspendContext suspendContext) {
        if (this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, suspendContext)) {
            this.setOverlay();
        } else {
            this.resume();
        }
    }

    public final void startPausing() {
        ((VmConnection)this.connection).getVm().getSuspendContextManager().suspend().rejected((Consumer)new RejectErrorReporter(this.getSession(), "Cannot pause"));
    }

    @NotNull
    public final String getCurrentStateMessage() {
        return ((VmConnection)this.connection).getState().getMessage();
    }

    @Nullable
    public final HyperlinkListener getCurrentStateHyperlinkListener() {
        return ((VmConnection)this.connection).getState().getMessageLinkListener();
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        if (executionResult == null || (executionResult = executionResult.getProcessHandler()) == null) {
            executionResult = (ProcessHandler)new DefaultDebugProcessHandler(){

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return executionResult;
    }

    public final void saveResolvedFile(@NotNull Url url, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.urlToFileCache.putIfAbsent(url, file);
    }

    @NotNull
    public abstract List<Location> getLocationsForBreakpoint(@NotNull XLineBreakpoint<?> var1, boolean var2);

    @NotNull
    public final C getConnection() {
        return this.connection;
    }

    @Nullable
    protected final ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    static {
        $delegatedProperties = new PropertyMetadata[]{(PropertyMetadata)DebugProcessImpl$_breakpointHandlers$1.INSTANCE};
    }

    public DebugProcessImpl(@NotNull XDebugSession session, @NotNull C connection, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSmartStepIntoHandler<?> smartStepIntoHandler, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)editorsProvider, (String)"editorsProvider");
        super(session);
        this.connection = connection;
        this.editorsProvider = editorsProvider;
        this.smartStepIntoHandler = smartStepIntoHandler;
        this.executionResult = executionResult;
        this.repeatStepInto = new AtomicBoolean();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap<Url, VirtualFile>()");
        this.urlToFileCache = concurrentMap;
        this._breakpointHandlers$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<XBreakpointHandler<?>[]>(this){
            final /* synthetic */ DebugProcessImpl this$0;

            @NotNull
            public final XBreakpointHandler<?>[] invoke() {
                return this.this$0.createBreakpointHandlers();
            }
            {
                this.this$0 = debugProcessImpl;
                super(0);
            }
        }));
        ((VmConnection)this.connection).addListener(new SocketConnectionListener(){

            @Override
            public void statusChanged(@NotNull ConnectionStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: 
                    case 2: {
                        if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ConnectionStatus.DETACHED)) && this.getRealProcessHandler() != null) {
                            this.getProcessHandler().detachProcess();
                        }
                        this.getSession().stop();
                        break;
                    }
                    case 3: {
                        this.getSession().reportError(status.getStatusText());
                        this.getSession().stop();
                        break;
                    }
                    default: {
                        this.getSession().rebuildViews();
                    }
                }
            }
        });
    }

    public static final /* synthetic */ void access$processBreakpointLogExpressionAndSuspend(DebugProcessImpl<C> $this, @NotNull XBreakpoint<?> breakpoint, @NotNull SuspendContextImpl xSuspendContext, @NotNull SuspendContext suspendContext) {
        super.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
    }

    public static final /* synthetic */ void access$breakpointReached(DebugProcessImpl<C> $this, @NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        super.breakpointReached(breakpoint, evaluatedLogExpression, suspendContext);
    }

    @NotNull
    public static final /* synthetic */ XBreakpointHandler<?>[] access$get_breakpointHandlers$p(DebugProcessImpl<C> $this) {
        return super.get_breakpointHandlers();
    }
}

