/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkListener;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"y\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\r\u0003\u0015\t\u0001\u0002A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0011)\u0011\u0001C\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001!1\u0003\u0004\u0001\u0016\t\u0011\u0001\u0001\u0012A\u000b\u00021\u0005I\u0012\u0001g\u0001\"\u0006E\u001b\u0011\u0001\u0003\u0002&\u000f!\u0011R\"\u0001M\u00133\rA1#D\u0001\u0019\u0011\u0015:\u0001rE\u0007\u00021KI2\u0001C\n\u000e\u0003a5Q\u0005\u0004\u0005\u0015\u001b\u0005A*#\u0007\u0003\t*5\u0011A\u0012\u0001\r\u00163\rAY#D\u0001\u0019-\u00152Aa\u0003E\u0017\u001b\rI\u0011\u0001b\u0001\u0019/\u0015\"Aa\u0003E\u0018\u001b\u0005A*#J\u0004\t15\t\u0001TE\r\u0004\u0011ci\u0011\u0001G\r&\r\u0011\u001d\u0001BC\u0007\u0004\u0013\u0005!\u0019\u0001G\f&)\u0011\u0011\u00012G\u0007\u00021KI2\u0001c\u000b\u000e\u0003a1\u0012$\u0002\u0003\u0002\u0011Si!\u0001$\u0001\u0019+e)A!\u0001\u0005\u001b\u001b\ta\t\u0001'\u000e&\t\u0011Q\u0001bG\u0007\u00021KI3\u0002B&\t\u0011\u000bi!\u0001$\u0001\u0019\u0007E\u001bA!\u0002\u0001\u000e\u0005\u0011\u001d\u0001\u0002B\u0015\b\t\u0005C\u0001\u0012B\u0007\u00021\u0015\t6!A\u0003\u0001Se!\u0011\t\u0003E\u0006\u001bMIa!C\u0003\u0011\u000fU\u0011A\u0012\u0001M\u00071\u001b\u0001r!F\u0005\n\r%)\u0001cB\u000b\u0003\u0019\u0003Aj\u0001'\u0004\r\u0002a1\u0001DB)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003C\u0011!=Q\"\u0001\r\t9\t\n6aA\u0007\u0003\t#A\u0011\"K\r\u0005\u0003\"A\u0019\"D\n\n\r%)\u0001cB\u000b\u0003\u0019\u0003A\u0002\u0002\u0007\u0005\u0011\u000fUI\u0011BB\u0005\u0006!\u001d)\"\u0001$\u0001\u0019\u0011aAA\u0012\u0001\r\u00071\u0019\t6!A\u0003\u0001S-!\u0011\t\u0003\u0005\u000b\u001b\u0015I1!\u0003\u0002\r\u0002aY\u0001TC)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003D\u0011!]Q\"\u0001\r\r9\r\n6aA\u0007\u0003\t3AQ\"\u000b\b\u0005\u0003\"AY\"\u0004\u0005\n\r%)\u0001cB\u000b\u0003\u0019\u0003AB\u0002\u0007\u0007\u0019\u001dE\u001b\u0011!\u0002\u0001*-\u0011\u001dE\u0004C\b\u000e\u00051\u0005A\u0004A\r\u0005\u0011;i!\u0001$\u0001\u001d\u0001q\u0019\u0001EI)\u0004\u0011\u0015\t\u00012E\u0007\u0003\t?A\u0001#\u0005\u0002\u0005\"!\t\u0002"}, strings={"Lorg/jetbrains/debugger/connection/VmConnection;", "T", "Lorg/jetbrains/debugger/Vm;", "Lcom/intellij/openapi/Disposable;", "()V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connectionDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/util/io/socketConnection/SocketConnectionListener;", "kotlin.jvm.PlatformType", "debugEventListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugEventListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "dispatcher", "opened", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "state", "Lcom/intellij/util/io/socketConnection/ConnectionState;", "getState", "()Lcom/intellij/util/io/socketConnection/ConnectionState;", "stateRef", "Ljava/util/concurrent/atomic/AtomicReference;", "<set-?>", "vm", "getVm", "()Lorg/jetbrains/debugger/Vm;", "setVm", "(Lorg/jetbrains/debugger/Vm;)V", "Lorg/jetbrains/debugger/Vm;", "addDebugListener", "", "listener", "addListener", "close", "message", "", "status", "Lcom/intellij/util/io/socketConnection/ConnectionStatus;", "detachAndClose", "Lorg/jetbrains/concurrency/Promise;", "dispose", "executeOnStart", "runnable", "Ljava/lang/Runnable;", "setState", "messageLinkListener", "Ljavax/swing/event/HyperlinkListener;", "startProcessing"}, moduleName="script-debugger-ui")
public abstract class VmConnection<T extends Vm>
implements Disposable {
    @Nullable
    private final WebBrowser browser;
    private final AtomicReference<ConnectionState> stateRef = new AtomicReference<ConnectionState>(new ConnectionState(ConnectionStatus.NOT_CONNECTED));
    private final EventDispatcher<DebugEventListener> dispatcher = EventDispatcher.create(DebugEventListener.class);
    private final EventDispatcher<SocketConnectionListener> connectionDispatcher = EventDispatcher.create(SocketConnectionListener.class);
    @Nullable
    private volatile T vm;
    private final AsyncPromise<Object> opened = new AsyncPromise();
    private final AtomicBoolean closed = new AtomicBoolean();

    @Nullable
    public WebBrowser getBrowser() {
        return this.browser;
    }

    @Nullable
    public final T getVm() {
        return this.vm;
    }

    protected final void setVm(@Nullable T t) {
        this.vm = t;
    }

    @NotNull
    public final ConnectionState getState() {
        ConnectionState connectionState = this.stateRef.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)connectionState, (String)"stateRef.get()");
        return connectionState;
    }

    public final void addDebugListener(@NotNull DebugEventListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.dispatcher.addListener((EventListener)listener);
    }

    @NotNull
    public final Promise<?> opened() {
        return (Promise)this.opened;
    }

    public final void executeOnStart(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        this.opened.done(new Consumer<T>(runnable){
            final /* synthetic */ Runnable $runnable;

            public final void consume(@Nullable Object it) {
                this.$runnable.run();
            }
            {
                this.$runnable = runnable;
            }
        });
    }

    protected final void setState(@NotNull ConnectionStatus status, @Nullable String message, @Nullable HyperlinkListener messageLinkListener) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        ConnectionState newState = new ConnectionState(status, message, messageLinkListener);
        ConnectionState oldState = this.stateRef.getAndSet(newState);
        if (oldState == null || Intrinsics.areEqual((Object)((Object)oldState.getStatus()), (Object)((Object)status)) ^ true) {
            if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ConnectionStatus.CONNECTION_FAILED))) {
                this.opened.setError(newState.getMessage());
            }
            ((SocketConnectionListener)this.connectionDispatcher.getMulticaster()).statusChanged(status);
        }
    }

    protected static /* synthetic */ void setState$default(VmConnection vmConnection, ConnectionStatus connectionStatus, String string, HyperlinkListener hyperlinkListener, int n) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            hyperlinkListener = null;
        }
        vmConnection.setState(connectionStatus, string, hyperlinkListener);
    }

    public final void addListener(@NotNull SocketConnectionListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.connectionDispatcher.addListener((EventListener)listener);
    }

    @NotNull
    protected final DebugEventListener getDebugEventListener() {
        DebugEventListener debugEventListener = (DebugEventListener)this.dispatcher.getMulticaster();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugEventListener, (String)"dispatcher.multicaster");
        return debugEventListener;
    }

    protected void startProcessing() {
        this.opened.setResult(null);
    }

    public final void close(@Nullable String message, @NotNull ConnectionStatus status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (PromiseKt.isPending((Promise)this.opened)) {
            this.opened.setError("closed");
        }
        VmConnection.setState$default(this, status, message, null, 4);
        Disposer.dispose((Disposable)this, (boolean)false);
    }

    public void dispose() {
        this.vm = null;
    }

    @NotNull
    public Promise<?> detachAndClose() {
        Promise<?> callback;
        T currentVm;
        if (PromiseKt.isPending((Promise)this.opened)) {
            this.opened.setError("detached and closed");
        }
        if ((currentVm = this.vm) == null) {
            callback = PromiseKt.resolvedPromise();
        } else {
            this.vm = null;
            callback = currentVm.getAttachStateManager().detach();
        }
        this.close(null, ConnectionStatus.DISCONNECTED);
        return callback;
    }
}

