/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.SingleConnectionNetService;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiDecoder;
import org.jetbrains.io.fastCgi.FastCgiRequest;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"U\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005Aq!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0011\u0019B\u0002\u0001\t\u00113\u0005A\n!(\u0001\u0011C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015:\u0001BB\u0007\u00021\u001bI2\u0001C\u0004\u000e\u0003a%Q\u0005\u0002\u0003\u000b\u0011\u001fi\u0011\u0001\u0007\u0005&\u001f\u0011Q\u0001\u0012C\u0007\u00021!I2\u0001C\u0005\u000e\u0003aM\u0011D\u0002\u0005\u000b\u001b\u0011I!!C\u0001\u0019\u0017aUQ%\u0004\u0003\u0002\u0011/i\u0011\u0001\u0007\u0005\u001a\u0007!aQ\"\u0001M\r3\u0011AQ\"\u0004\u0002\r\u0002amQ\u0005\u0004\u0005\u000f\u001b\u0005A\u0002\"G\u0002\t\u001e5\t\u0001TB\r\u0005\u0011=i!\u0001$\u0001\u0019\u001c\u0015Z\u0001rD\u0007\u00021!I2\u0001\u0003\u0007\u000e\u0003ae\u0011d\u0001\u0005\u000e\u001b\u0005AZ\"K\u0004\u0005\u0003\"A)!D\u0001\u0019\u0007E\u001b\u0011!\u0002\u0001*\u001b\u0011\u0011\u0005\u0002c\u0002\u000e\t%\u0011\u0011\"\u0001M\u00051\u0011\t6\u0001B\u0003\u0001\u001b\t!Q\u0001c\u0003"}, strings={"Lorg/jetbrains/io/fastCgi/FastCgiService;", "Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "requestIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "requests", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lio/netty/channel/Channel;", "getRequests", "()Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "allocateRequestId", "", "channel", "closeProcessConnections", "", "configureBootstrap", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "handleError", "fastCgiRequest", "Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "content", "Lio/netty/buffer/ByteBuf;", "responseReceived", "id", "buffer", "send", "Companion"}, moduleName="built-in-server")
public abstract class FastCgiService
extends SingleConnectionNetService {
    private final AtomicInteger requestIdCounter;
    @NotNull
    private final ConcurrentIntObjectMap<Channel> requests;
    public static final Companion Companion = org.jetbrains.io.fastCgi.FastCgiService$Companion.INSTANCE;

    @NotNull
    protected final ConcurrentIntObjectMap<Channel> getRequests() {
        return this.requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeProcessConnections() {
        try {
            super.closeProcessConnections();
        }
        finally {
            this.requestIdCounter.set(0);
            if (!this.requests.isEmpty()) {
                List waitingClients = ContainerUtil.toList((Enumeration)this.requests.elements());
                this.requests.clear();
                Iterator iterator = waitingClients.iterator();
                while (iterator.hasNext()) {
                    Channel channel;
                    Channel channel2 = channel = (Channel)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"channel");
                    FastCgiService.Companion.sendBadGateway(channel2);
                }
            }
        }
    }

    @Override
    protected void configureBootstrap(@NotNull Bootstrap bootstrap, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)bootstrap, (String)"bootstrap");
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap $receiver = bootstrap;
        $receiver.handler((ChannelHandler)new ChannelInitializer<Channel>(this, errorOutputConsumer){
            final /* synthetic */ FastCgiService this$0;
            final /* synthetic */ Consumer $errorOutputConsumer$inlined;

            protected void initChannel(Channel channel) {
                Channel it = channel;
                it.pipeline().addLast("fastCgiDecoder", (ChannelHandler)new FastCgiDecoder((Consumer<String>)this.$errorOutputConsumer$inlined, this.this$0));
                it.pipeline().addLast("exceptionHandler", ChannelExceptionHandler.getInstance());
            }
            {
                this.this$0 = fastCgiService;
                this.$errorOutputConsumer$inlined = consumer;
            }
        });
    }

    public final void send(@NotNull FastCgiRequest fastCgiRequest, @NotNull ByteBuf content) {
        ByteBuf notEmptyContent;
        Intrinsics.checkParameterIsNotNull((Object)fastCgiRequest, (String)"fastCgiRequest");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (content.isReadable()) {
            content.retain();
            notEmptyContent = content;
            notEmptyContent.touch();
        } else {
            notEmptyContent = null;
        }
        try {
            if (this.getProcessHandler().has()) {
                Channel channel = this.getProcessChannel();
                if (channel == null) {
                    Intrinsics.throwNpe();
                }
                fastCgiRequest.writeToServerChannel(notEmptyContent, channel);
            } else {
                this.getProcessHandler().get().done(new Consumer<T>(this, fastCgiRequest, notEmptyContent){
                    final /* synthetic */ FastCgiService this$0;
                    final /* synthetic */ FastCgiRequest $fastCgiRequest;
                    final /* synthetic */ ByteBuf $notEmptyContent;

                    public final void consume(OSProcessHandler it) {
                        Channel channel = FastCgiService.access$getProcessChannel$p(this.this$0);
                        if (channel == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$fastCgiRequest.writeToServerChannel(this.$notEmptyContent, channel);
                    }
                    {
                        this.this$0 = fastCgiService;
                        this.$fastCgiRequest = fastCgiRequest;
                        this.$notEmptyContent = byteBuf;
                    }
                }).rejected((Consumer)new Consumer<Throwable>(this, fastCgiRequest, notEmptyContent){
                    final /* synthetic */ FastCgiService this$0;
                    final /* synthetic */ FastCgiRequest $fastCgiRequest;
                    final /* synthetic */ ByteBuf $notEmptyContent;

                    public final void consume(Throwable it) {
                        Promise.logError((Logger)FastCgiServiceKt.getLOG(), (Throwable)it);
                        FastCgiService.access$handleError(this.this$0, this.$fastCgiRequest, this.$notEmptyContent);
                    }
                    {
                        this.this$0 = fastCgiService;
                        this.$fastCgiRequest = fastCgiRequest;
                        this.$notEmptyContent = byteBuf;
                    }
                });
            }
        }
        catch (Throwable e) {
            FastCgiServiceKt.getLOG().error(e);
            this.handleError(fastCgiRequest, notEmptyContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleError(FastCgiRequest fastCgiRequest, ByteBuf content) {
        try {
            if (content != null && content.refCnt() != 0) {
                content.release();
            }
        }
        finally {
            Channel channel = (Channel)this.requests.remove(fastCgiRequest.getRequestId());
            if (channel != null) {
                FastCgiService.Companion.sendBadGateway(channel);
            }
        }
    }

    public final int allocateRequestId(@NotNull Channel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        int requestId = this.requestIdCounter.getAndIncrement();
        if (requestId >= Short.MAX_VALUE) {
            this.requestIdCounter.set(0);
            requestId = this.requestIdCounter.getAndDecrement();
        }
        this.requests.put(requestId, (Object)channel);
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void responseReceived(int id, @Nullable ByteBuf buffer) {
        Channel channel = (Channel)this.requests.remove(id);
        if (channel == null || !channel.isActive()) {
            ByteBuf byteBuf = buffer;
            Boolean bl = byteBuf != null ? Boolean.valueOf(byteBuf.release()) : null;
            return;
        }
        if (buffer == null) {
            Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
            return;
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
        try {
            FastCgiService.Companion.parseHeaders((HttpResponse)httpResponse, buffer);
            Responses.addServer((HttpResponse)httpResponse);
            if (!HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)httpResponse))) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)httpResponse), (long)buffer.readableBytes());
            }
        }
        catch (Throwable e) {
            buffer.release();
            try {
                FastCgiServiceKt.getLOG().error(e);
            }
            finally {
                Responses.sendStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR, channel);
            }
            return;
        }
        channel.writeAndFlush((Object)httpResponse);
    }

    public FastCgiService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
        this.requestIdCounter = new AtomicInteger();
        ConcurrentIntObjectMap concurrentIntObjectMap = ContainerUtil.createConcurrentIntObjectMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentIntObjectMap, (String)"ContainerUtil.createConc\u2026ntIntObjectMap<Channel>()");
        this.requests = concurrentIntObjectMap;
    }

    @Nullable
    public static final /* synthetic */ Channel access$getProcessChannel$p(FastCgiService $this) {
        return $this.getProcessChannel();
    }

    public static final /* synthetic */ void access$setProcessChannel$p(FastCgiService $this, @Nullable Channel channel) {
        $this.setProcessChannel(channel);
    }

    public static final /* synthetic */ void access$handleError(FastCgiService $this, @NotNull FastCgiRequest fastCgiRequest, @Nullable ByteBuf content) {
        $this.handleError(fastCgiRequest, content);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005!19\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0019\u0011\t\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!\n\u0005\u0005\u0003!%Q\"\u0001\r\u00033\rAQ!D\u0001\u0019\f\u0001"}, strings={"Lorg/jetbrains/io/fastCgi/FastCgiService$Companion;", "", "()V", "parseHeaders", "", "response", "Lio/netty/handler/codec/http/HttpResponse;", "buffer", "Lio/netty/buffer/ByteBuf;", "sendBadGateway", "channel", "Lio/netty/channel/Channel;"}, moduleName="built-in-server")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final void sendBadGateway(Channel channel) {
            try {
                if (channel.isActive()) {
                    Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
                }
            }
            catch (Throwable e) {
                NettyUtil.log(e, FastCgiServiceKt.getLOG());
            }
        }

        private final void parseHeaders(HttpResponse response, ByteBuf buffer) {
            StringBuilder builder = new StringBuilder();
            while (buffer.isReadable()) {
                byte b;
                builder.setLength(0);
                String key = null;
                boolean valueExpected = true;
                while ((b = buffer.readByte()) >= 0 && (char)b != '\n') {
                    if ((char)b == '\r') continue;
                    if (valueExpected && (char)b == ':') {
                        valueExpected = false;
                        key = builder.toString();
                        builder.setLength(0);
                        MessageDecoder.skipWhitespace(buffer);
                        continue;
                    }
                    builder.append((char)b);
                }
                if (CollectionsKt.length((CharSequence)builder) == 0) {
                    return;
                }
                if (StringsKt.isNullOrEmpty((String)key)) continue;
                String string = key;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if (StringsKt.startsWith((String)string, (String)"http", (boolean)true)) continue;
                String string2 = key;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                if (StringsKt.startsWith((String)string2, (String)"X-Accel-", (boolean)true)) continue;
                String value = builder.toString();
                String string3 = key;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                if (StringsKt.equals((String)string3, (String)"status", (boolean)true)) {
                    int index = StringsKt.indexOf$default((String)value, (char)' ', (int)0, (boolean)false, (int)6);
                    if (index == -1) {
                        FastCgiServiceKt.getLOG().warn("Cannot parse status: " + value);
                        response.setStatus(HttpResponseStatus.OK);
                        continue;
                    }
                    response.setStatus(HttpResponseStatus.valueOf((int)Integer.parseInt(StringsKt.substring((String)value, (int)0, (int)index))));
                    continue;
                }
                if (StringsKt.startsWith$default((String)key, (String)"http", (boolean)false, (int)2) || StringsKt.startsWith$default((String)key, (String)"HTTP", (boolean)false, (int)2)) continue;
                response.headers().add(key, (Object)value);
            }
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

