/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.checks.ApiDetector;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UastModifier;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class OverrideConcreteDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("OverrideAbstract", "Not overriding abstract methods on older platforms", "To improve the usability of some APIs, some methods that used to be `abstract` have been made concrete by adding default implementations. This means that when compiling with new versions of the SDK, your code does not have to override these methods.\n\nHowever, if your code is also targeting older versions of the platform where these methods were still `abstract`, the code will crash. You must override all methods that used to be abstract in any versions targeted by your application's `minSdkVersion`.", Category.CORRECTNESS, 6, Severity.FATAL, new Implementation(OverrideConcreteDetector.class, Scope.SOURCE_FILE_SCOPE));
    private static final String NOTIFICATION_LISTENER_SERVICE_FQN = "android.service.notification.NotificationListenerService";
    public static final String STATUS_BAR_NOTIFICATION_FQN = "android.service.notification.StatusBarNotification";
    private static final String ON_NOTIFICATION_POSTED = "onNotificationPosted";
    private static final String ON_NOTIFICATION_REMOVED = "onNotificationRemoved";
    private static final int CONCRETE_IN = 21;

    @Override
    public List<String> getApplicableSuperClasses() {
        return Collections.singletonList(NOTIFICATION_LISTENER_SERVICE_FQN);
    }

    @Override
    public void visitClass(UastAndroidContext context, UClass node) {
        String[] methodNames;
        if (node == null) {
            return;
        }
        if (node.hasModifier(UastModifier.ABSTRACT)) {
            return;
        }
        int minSdk = Math.max(context.getLintContext().getProject().getMinSdk(), OverrideConcreteDetector.getTargetApi(node));
        if (minSdk >= 21) {
            return;
        }
        for (String methodName : methodNames = new String[]{ON_NOTIFICATION_POSTED, ON_NOTIFICATION_REMOVED}) {
            boolean found = false;
            List<UFunction> allFunctions = UastUtils.getAllFunctions(node, context);
            for (UFunction method : allFunctions) {
                UClass containingClass;
                if (!method.matchesName(methodName) || (containingClass = UastUtils.getContainingClassOrEmpty(method)).matchesFqName(NOTIFICATION_LISTENER_SERVICE_FQN) || method.hasModifier(UastModifier.ABSTRACT) || method.getValueParameterCount() != 1 || !method.getValueParameters().get(0).getType().matchesFqName(STATUS_BAR_NOTIFICATION_FQN)) continue;
                found = true;
                break;
            }
            if (found) continue;
            String message2 = String.format("Must override `%1$s.%2$s(%3$s)`: Method was abstract until %4$d, and your `minSdkVersion` is %5$d", NOTIFICATION_LISTENER_SERVICE_FQN, methodName, STATUS_BAR_NOTIFICATION_FQN, 21, minSdk);
            context.report(ISSUE, node, context.getLocation(node.getNameElement()), message2);
            break;
        }
    }

    private static int getTargetApi(UClass node) {
        while (node != null) {
            int targetApi = ApiDetector.Companion.getTargetApi(node.getAnnotations());
            if (targetApi != -1) {
                return targetApi;
            }
            node = UastUtils.getContainingClass(node);
        }
        return -1;
    }
}

