/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.uast;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.uast.KotlinAbstractUElement;
import org.jetbrains.kotlin.uast.KotlinInternalUastUtilsKt;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.psi.PsiElementBacked;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0016R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0014\u0010\u001d\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0018R\u0014\u0010\u001e\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018R\u0014\u0010\u001f\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0018R\u0014\u0010 \u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/uast/KotlinUType;", "Lorg/jetbrains/kotlin/uast/KotlinAbstractUElement;", "Lorg/jetbrains/uast/UType;", "Lorg/jetbrains/uast/psi/PsiElementBacked;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lorg/jetbrains/uast/UElement;", "psi", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/uast/UElement;Lcom/intellij/psi/PsiElement;)V", "annotations", "", "Lorg/jetbrains/uast/UAnnotation;", "getAnnotations", "()Ljava/util/List;", "fqName", "", "getFqName", "()Ljava/lang/String;", "isBoolean", "", "()Z", "isByte", "isChar", "isDouble", "isFloat", "isInt", "isLong", "isShort", "name", "getName", "getParent", "()Lorg/jetbrains/uast/UElement;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPsi", "()Lcom/intellij/psi/PsiElement;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "checkType", "fqNameUnsafe", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "resolve", "Lorg/jetbrains/uast/UClass;", "context", "Lorg/jetbrains/uast/UastContext;", "uast-kotlin"})
public final class KotlinUType
extends KotlinAbstractUElement
implements UType,
PsiElementBacked {
    @NotNull
    private final List<UAnnotation> annotations;
    @NotNull
    private final KotlinType type;
    @NotNull
    private final Project project;
    @Nullable
    private final UElement parent;
    @Nullable
    private final PsiElement psi;

    @Override
    @NotNull
    public String getName() {
        return this.type.toString();
    }

    @Override
    @Nullable
    public String getFqName() {
        ClassifierDescriptor classifierDescriptor = this.type.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null && (classifierDescriptor = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor))) != null ? classifierDescriptor.asString() : null;
    }

    @Override
    @Nullable
    public UClass resolve(@NotNull UastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ClassifierDescriptor classifierDescriptor = this.type.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return null;
        }
        ClassifierDescriptor descriptor = classifierDescriptor;
        PsiElement psiElement = KotlinInternalUastUtilsKt.toSource((DeclarationDescriptor)descriptor);
        if (psiElement == null) {
            return null;
        }
        PsiElement sourceElement = psiElement;
        UElement uElement = context.convert(sourceElement);
        if (!(uElement instanceof UClass)) {
            uElement = null;
        }
        return (UClass)uElement;
    }

    @Override
    public boolean isBoolean() {
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._boolean;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._boolean");
        return this.checkType(fqNameUnsafe);
    }

    @Override
    public boolean isInt() {
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._int;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._int");
        return this.checkType(fqNameUnsafe);
    }

    @Override
    public boolean isShort() {
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._short;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._short");
        return this.checkType(fqNameUnsafe);
    }

    @Override
    public boolean isLong() {
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._long;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._long");
        return this.checkType(fqNameUnsafe);
    }

    @Override
    public boolean isFloat() {
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._float;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._float");
        return this.checkType(fqNameUnsafe);
    }

    @Override
    public boolean isDouble() {
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._double;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._double");
        return this.checkType(fqNameUnsafe);
    }

    @Override
    public boolean isChar() {
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._char;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._char");
        return this.checkType(fqNameUnsafe);
    }

    @Override
    public boolean isByte() {
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._byte;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._byte");
        return this.checkType(fqNameUnsafe);
    }

    private final boolean checkType(FqNameUnsafe fqNameUnsafe) {
        ClassifierDescriptor descriptor = this.type.getConstructor().getDeclarationDescriptor();
        return descriptor instanceof ClassDescriptor && Intrinsics.areEqual((Object)descriptor.getName(), (Object)fqNameUnsafe.shortName()) && Intrinsics.areEqual((Object)fqNameUnsafe, (Object)DescriptorUtils.getFqName((DeclarationDescriptor)((DeclarationDescriptor)descriptor)));
    }

    @Override
    @NotNull
    public List<UAnnotation> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public UElement getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public PsiElement getPsi() {
        return this.psi;
    }

    public KotlinUType(@NotNull KotlinType type2, @NotNull Project project, @Nullable UElement parent, @Nullable PsiElement psi) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.type = type2;
        this.project = project;
        this.parent = parent;
        this.psi = psi;
        this.annotations = CollectionsKt.emptyList();
    }

    public /* synthetic */ KotlinUType(KotlinType kotlinType, Project project, UElement uElement, PsiElement psiElement, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            psiElement = null;
        }
        this(kotlinType, project, uElement, psiElement);
    }

    @Override
    public boolean isValid() {
        return PsiElementBacked.DefaultImpls.isValid(this);
    }

    @Override
    public void accept(@NotNull UastVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull((Object)visitor2, (String)"visitor");
        UType.DefaultImpls.accept(this, visitor2);
    }

    @Override
    @NotNull
    public String logString() {
        return UType.DefaultImpls.logString(this);
    }

    @Override
    @NotNull
    public String renderString() {
        return UType.DefaultImpls.renderString(this);
    }

    @Override
    @NotNull
    public UClass resolveOrEmpty(@NotNull UastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return UType.DefaultImpls.resolveOrEmpty(this, context);
    }

    @Override
    public boolean matchesName(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return UType.DefaultImpls.matchesName(this, name2);
    }

    @Override
    public boolean matchesFqName(@NotNull String fqName) {
        Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
        return UType.DefaultImpls.matchesFqName(this, fqName);
    }

    @Override
    @Nullable
    public UClass resolveClass(@NotNull UastContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return UType.DefaultImpls.resolveClass(this, context);
    }
}

