/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import com.intellij.junit5.JUnit5TestExecutionListener;
import com.intellij.junit5.JUnit5TestRunnerUtil;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherFactory;

public class JUnit5IdeaTestRunner
implements IdeaTestRunner {
    private JUnit5TestExecutionListener myListener;
    private TestPlan myTestPlan;

    public int startRunnerWithArgs(String[] args, ArrayList listeners, String name, int count, boolean sendTree) {
        Launcher launcher = LauncherFactory.create();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{this.myListener});
        String[] packageNameRef = new String[1];
        LauncherDiscoveryRequest discoveryRequest = JUnit5TestRunnerUtil.buildRequest(args, packageNameRef);
        this.myTestPlan = launcher.discover(discoveryRequest);
        this.myListener.sendTree(this.myTestPlan, packageNameRef[0]);
        launcher.execute(discoveryRequest);
        return 0;
    }

    public void setStreams(Object segmentedOut, Object segmentedErr, int lastIdx) {
        this.myListener = new JUnit5TestExecutionListener(System.out);
    }

    public OutputObjectRegistry getRegistry() {
        return null;
    }

    public Object getTestToStart(String[] args, String name) {
        LauncherDiscoveryRequest discoveryRequest = JUnit5TestRunnerUtil.buildRequest(args, new String[1]);
        Launcher launcher = LauncherFactory.create();
        this.myTestPlan = launcher.discover(discoveryRequest);
        Set roots = this.myTestPlan.getRoots();
        return roots.isEmpty() ? null : roots.iterator().next();
    }

    public List getChildTests(Object description) {
        return new ArrayList(this.myTestPlan.getChildren((TestIdentifier)description));
    }

    public String getStartDescription(Object child) {
        TestIdentifier testIdentifier = (TestIdentifier)child;
        String className = JUnit5TestExecutionListener.getClassName(testIdentifier);
        String methodName = JUnit5TestExecutionListener.getMethodName(testIdentifier);
        if (methodName != null) {
            return className + "#" + methodName;
        }
        return className != null ? className : testIdentifier.getDisplayName();
    }

    public String getTestClassName(Object child) {
        return child.toString();
    }
}

