/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.JBLoadingPanelWrapper;
import com.android.tools.idea.editors.gfxtrace.UiErrorCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.TreeController;
import com.android.tools.idea.editors.gfxtrace.service.ErrDataUnavailable;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.FieldPath;
import com.android.tools.idea.editors.gfxtrace.service.path.MapIndexPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.service.path.StatePath;
import com.android.tools.rpclib.futures.FutureController;
import com.android.tools.rpclib.futures.SingleInFlight;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Map;
import com.android.tools.rpclib.schema.Type;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class StateController
extends TreeController {
    @NotNull
    private static final Logger LOG = Logger.getInstance(StateController.class);
    @NotNull
    private static final TypedValue ROOT_TYPE = new TypedValue(null, "state");
    @NotNull
    private static final Object[] NO_SELECTION = new Object[0];
    private final PathStore<StatePath> myStatePath;
    private final StateTreeModel myModel;
    private final SingleInFlight myStateRequestController;
    private Object[] lastSelection;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new StateController((GfxTraceEditor)editor).myPanel;
    }

    private StateController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/StateController", "<init>"));
        }
        super(editor, "Select a frame or command");
        this.myStatePath = new PathStore();
        this.myModel = new StateTreeModel(new Node(ROOT_TYPE, null));
        this.myStateRequestController = new SingleInFlight((SingleInFlight.Listener)new JBLoadingPanelWrapper(this.myLoadingPanel));
        this.lastSelection = NO_SELECTION;
        this.myPanel.setBorder(BorderFactory.createTitledBorder(this.myScrollPane.getBorder(), "GPU State"));
        this.myScrollPane.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.setModel(this.myModel);
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        boolean updateState = this.myStatePath.updateIfNotNull(AtomPath.stateAfter(event.findAtomPath()));
        if (updateState && this.myStatePath.getPath() != null) {
            ListenableFuture<Object> future = this.myEditor.getClient().get(this.myStatePath.getPath());
            Rpc.listen(future, (Logger)LOG, (FutureController)this.myStateRequestController, (Rpc.Callback)new UiErrorCallback<Object, Node, String>(){

                @Override
                protected UiErrorCallback.ResultOrError<Node, String> onRpcThread(Rpc.Result<Object> result) throws RpcException, ExecutionException {
                    try {
                        return this.success(StateController.convert(new TypedValue(null, "state"), new TypedValue(null, result.get())));
                    }
                    catch (ErrDataUnavailable e) {
                        return this.error(e.getMessage());
                    }
                }

                @Override
                protected void onUiThreadSuccess(Node root) {
                    if (StateController.this.getModel() != StateController.this.myModel) {
                        StateController.this.setModel(StateController.this.myModel);
                    }
                    StateController.this.myModel.setRoot(root);
                    if (StateController.this.lastSelection.length > 0) {
                        StateController.this.select(StateController.this.lastSelection);
                        StateController.access$202(StateController.this, NO_SELECTION);
                    }
                }

                @Override
                protected void onUiThreadError(String error) {
                    StateController.this.myTree.getEmptyText().setText(error);
                    StateController.this.clear();
                }
            });
        }
        if (event.findStatePath() != null) {
            Object[] selection = StateController.getStatePath(event.path);
            if (this.getModel() == null || ((Node)this.myModel.getRoot()).isLeaf()) {
                this.lastSelection = selection;
            } else {
                this.select(selection);
                this.lastSelection = NO_SELECTION;
            }
        }
    }

    private static Object[] getStatePath(Path path) {
        LinkedList result = Lists.newLinkedList();
        while (path != null) {
            if (path instanceof FieldPath) {
                result.add(0, ((FieldPath)path).getName());
            } else {
                if (!(path instanceof MapIndexPath)) break;
                result.add(0, ((MapIndexPath)path).getKey());
            }
            path = path.getParent();
        }
        return result.toArray(new Object[result.size()]);
    }

    private void select(Object[] nodePath) {
        Node node = (Node)this.myModel.getRoot();
        TreePath treePath = new TreePath(node);
        for (int i = 0; i < nodePath.length && !node.isLeaf() && (node = node.findChild(nodePath[i])) != null; ++i) {
            treePath = treePath.pathByAddingChild(node);
        }
        this.myTree.expandPath(node == null || node.isLeaf() ? treePath.getParentPath() : treePath);
        this.myTree.setSelectionPath(treePath);
        this.myTree.scrollPathToVisible(treePath);
    }

    private static Node convert(TypedValue key, TypedValue value) {
        Node result;
        block4: {
            result = new Node(key, value);
            if (!(value.value instanceof Dynamic) && !(value.type instanceof Map)) break block4;
            if (value.value instanceof Dynamic) {
                Dynamic dynamic = (Dynamic)value.value;
                for (int i = 0; i < dynamic.getFieldCount(); ++i) {
                    Field field = dynamic.getFieldInfo(i);
                    result.addChild(StateController.convert(new TypedValue(null, field.getDeclared()), new TypedValue(field.getType(), dynamic.getFieldValue(i))));
                }
            } else {
                java.util.Map map = (java.util.Map)value.value;
                Type keyType = ((Map)value.type).getKeyType();
                Type valueType = ((Map)value.type).getValueType();
                for (Map.Entry e : map.entrySet()) {
                    result.addChild(StateController.convert(new TypedValue(keyType, e.getKey()), new TypedValue(valueType, e.getValue())));
                }
            }
        }
        return result;
    }

    static /* synthetic */ Object[] access$202(StateController x0, Object[] x1) {
        x0.lastSelection = x1;
        return x1;
    }

    private static class StateTreeModel
    implements TreeModel {
        private final Listeners listeners = new Listeners();
        private Node root;

        public StateTreeModel(Node root) {
            this.root = root;
        }

        public void setRoot(Node state) {
            if (this.root.isLeaf()) {
                this.root = state;
                this.listeners.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
            } else {
                this.root.merge(state, Lists.newArrayList(), this.listeners);
            }
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public int getChildCount(Object parent) {
            return ((Node)parent).getChildCount();
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((Node)parent).getChild(index);
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((Node)node).isLeaf();
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (!(parent instanceof Node) || child == null) {
                return -1;
            }
            return ((Node)parent).getChildIndex(child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        private static class Listeners
        extends ArrayList<TreeModelListener>
        implements TreeModelListener {
            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                for (TreeModelListener listener : this.toArray(new TreeModelListener[this.size()])) {
                    listener.treeNodesChanged(e);
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                for (TreeModelListener listener : this.toArray(new TreeModelListener[this.size()])) {
                    listener.treeNodesInserted(e);
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                for (TreeModelListener listener : this.toArray(new TreeModelListener[this.size()])) {
                    listener.treeNodesRemoved(e);
                }
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                for (TreeModelListener listener : this.toArray(new TreeModelListener[this.size()])) {
                    listener.treeStructureChanged(e);
                }
            }
        }
    }

    public static class Node {
        public final TypedValue key;
        public TypedValue value;
        private final List<Node> childrenByIndex = Lists.newArrayList();
        private final HashMap<TypedValue, Node> childrenByKey = Maps.newHashMap();

        public Node(TypedValue key, TypedValue value) {
            this.key = key;
            this.value = value;
        }

        public void addChild(Node node) {
            this.childrenByIndex.add(node);
            this.childrenByKey.put(node.key, node);
        }

        public void merge(Node other, List<Object> path, TreeModelListener listener) {
            Node child2;
            int i;
            IntArrayList changedIndecies = new IntArrayList(Math.max(this.getChildCount(), other.getChildCount()));
            ArrayList changedChildren = Lists.newArrayListWithCapacity((int)Math.max(this.getChildCount(), other.getChildCount()));
            path.add(this);
            for (i = 0; i < this.childrenByIndex.size(); ++i) {
                child2 = this.childrenByIndex.get(i);
                if (other.childrenByKey.containsKey(child2.key)) continue;
                changedIndecies.add(i + changedIndecies.size());
                changedChildren.add(child2);
                this.childrenByIndex.remove(i);
                this.childrenByKey.remove(child2.key);
                --i;
            }
            if (!changedIndecies.isEmpty()) {
                listener.treeNodesRemoved(new TreeModelEvent((Object)this, path.toArray(), changedIndecies.toArray(), changedChildren.toArray()));
                changedIndecies.clear();
                changedChildren.clear();
            }
            for (i = 0; i < other.childrenByIndex.size(); ++i) {
                child2 = other.childrenByIndex.get(i);
                if (this.childrenByKey.containsKey(child2.key)) continue;
                changedIndecies.add(this.childrenByIndex.size());
                changedChildren.add(child2);
                this.addChild(child2);
            }
            if (!changedIndecies.isEmpty()) {
                listener.treeNodesInserted(new TreeModelEvent((Object)this, path.toArray(), changedIndecies.toArray(), changedChildren.toArray()));
                changedIndecies.clear();
                changedChildren.clear();
            }
            for (Node child2 : this.childrenByIndex) {
                child2.merge(other.childrenByKey.get(child2.key), path, listener);
            }
            if (this.isLeaf() && !Objects.equal((Object)this.value, (Object)other.value)) {
                this.value = other.value;
                listener.treeNodesChanged(new TreeModelEvent((Object)this, path.toArray()));
            } else {
                this.value = other.value;
            }
            path.remove(path.size() - 1);
        }

        public int getChildCount() {
            return this.childrenByIndex.size();
        }

        public Node getChild(int index) {
            return this.childrenByIndex.get(index);
        }

        public int getChildIndex(Object child) {
            return this.childrenByIndex.indexOf(child);
        }

        public boolean isLeaf() {
            return this.childrenByIndex.isEmpty();
        }

        public Node findChild(Object key) {
            for (Node child : this.childrenByIndex) {
                if (!Objects.equal((Object)key, (Object)child.key.value)) continue;
                return child;
            }
            return null;
        }
    }

    public static class TypedValue {
        public final Type type;
        public final Object value;

        public TypedValue(Type type, Object value) {
            this.type = type;
            this.value = value instanceof Integer ? Long.valueOf(((Integer)value).longValue()) : value;
        }

        public int hashCode() {
            return (this.type == null ? 0 : this.type.hashCode()) ^ this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TypedValue)) {
                return false;
            }
            TypedValue other = (TypedValue)obj;
            return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.value, (Object)other.value);
        }
    }
}

