/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.tools.idea.editors.navigation.NavigationEditor;
import com.android.utils.SdkUtils;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NavigationEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    public static final String ID = "navigationeditor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/navigation/NavigationEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/navigation/NavigationEditorProvider", "accept"));
        }
        return SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)"nvg.xml");
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/navigation/NavigationEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/navigation/NavigationEditorProvider", "createEditor"));
        }
        NavigationEditor navigationEditor = new NavigationEditor(project, file);
        if (navigationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/NavigationEditorProvider", "createEditor"));
        }
        return navigationEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/NavigationEditorProvider", "getEditorTypeId"));
        }
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/NavigationEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

