/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class TemplateParameterStep
extends TemplateWizardStep {
    private static final Logger LOG = Logger.getInstance(TemplateParameterStep.class);
    private JPanel myParamContainer;
    private JPanel myContainer;
    private JLabel myDescription;
    private JLabel myError;
    @VisibleForTesting
    JLabel myPreview;
    private JComponent myPreferredFocusComponent;
    @VisibleForTesting
    String myCurrentThumb;

    public TemplateParameterStep(TemplateWizardState state, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener) {
        super(state, project, module, sidePanelIcon, updateListener);
        this.$$$setupUI$$$();
    }

    @Override
    public void _init() {
        this.myParamContainer.removeAll();
        this.myPreferredFocusComponent = null;
        int row = 0;
        Collection<Parameter> parameters = this.myTemplateState.getTemplateMetadata().getParameters();
        this.myParamContainer.setLayout((LayoutManager)new GridLayoutManager(parameters.size() + 1, 3));
        String packageName = null;
        if (this.myTemplateState.hasAttr("packageName")) {
            packageName = this.myTemplateState.getString("packageName");
        }
        GridConstraints c = new GridConstraints();
        c.setVSizePolicy(0);
        c.setAnchor(8);
        c.setFill(1);
        for (Parameter parameter : parameters) {
            if (this.myTemplateState.myHidden.contains(parameter.id)) continue;
            JLabel label = new JLabel(parameter.name);
            this.registerLabel(parameter.id, label);
            c.setHSizePolicy(2);
            c.setColumn(0);
            c.setColSpan(1);
            c.setRow(row++);
            String value = this.myTemplateState.get(parameter.id) != null ? this.myTemplateState.get(parameter.id) : parameter.initial;
            this.myTemplateState.put(parameter.id, value);
            switch (parameter.type) {
                case SEPARATOR: {
                    c.setColSpan(3);
                    JSeparator separator = new JSeparator(0);
                    this.myParamContainer.add((Component)separator, c);
                    break;
                }
                case BOOLEAN: {
                    c.setColumn(1);
                    JCheckBox checkBox = new JCheckBox(parameter.name);
                    this.register(parameter.id, checkBox);
                    this.myParamContainer.add((Component)checkBox, c);
                    if (this.myPreferredFocusComponent != null) break;
                    this.myPreferredFocusComponent = checkBox;
                    break;
                }
                case ENUM: {
                    this.myParamContainer.add((Component)label, c);
                    JComboBox comboBox = new JComboBox();
                    c.setColumn(1);
                    TemplateParameterStep.populateComboBox(comboBox, parameter);
                    this.register(parameter.id, comboBox);
                    this.myParamContainer.add(comboBox, c);
                    if (this.myPreferredFocusComponent != null) break;
                    this.myPreferredFocusComponent = comboBox;
                    break;
                }
                case STRING: {
                    this.myParamContainer.add((Component)label, c);
                    c.setHSizePolicy(4);
                    JTextField textField = new JTextField();
                    c.setColumn(1);
                    c.setColSpan(2);
                    this.register(parameter.id, textField);
                    this.myParamContainer.add((Component)textField, c);
                    if (this.myPreferredFocusComponent != null) break;
                    this.myPreferredFocusComponent = textField;
                    textField.selectAll();
                }
            }
            this.updateVisibility(parameter);
        }
        this.update();
        this.deduplicateSuggestions(packageName);
        c.setFill(1);
        c.setHSizePolicy(4);
        c.setVSizePolicy(4);
        c.setRow(row);
        c.setRowSpan(1);
        c.setColSpan(1);
        c.setColumn(2);
        Spacer spacer = new Spacer();
        this.myParamContainer.add((Component)spacer, c);
        this.setDescriptionHtml(this.myTemplateState.getTemplateMetadata().getDescription());
    }

    private void deduplicateSuggestions(@Nullable String packageName) {
        if (this.myProject == null || this.myTemplateState.getTemplateMetadata() == null) {
            return;
        }
        SourceProvider provider = this.myTemplateState.getSourceProvider();
        for (String paramName : this.myParamFields.keySet()) {
            Parameter parameter = this.myTemplateState.hasTemplate() ? this.myTemplateState.getTemplateMetadata().getParameter(paramName) : null;
            if (parameter == null || parameter.type != Parameter.Type.STRING) continue;
            JComponent component = (JComponent)this.myParamFields.get((Object)paramName);
            Set<Object> relatedValues = this.getRelatedValues(parameter);
            if (!parameter.constraints.contains((Object)Parameter.Constraint.UNIQUE) || parameter.uniquenessSatisfied(this.myProject, this.myModule, provider, packageName, this.myTemplateState.getString(parameter.id), relatedValues)) continue;
            int i = 2;
            String originalValue = this.myTemplateState.getString(parameter.id);
            while (!parameter.uniquenessSatisfied(this.myProject, this.myModule, provider, packageName, originalValue + Integer.toString(i), relatedValues)) {
                ++i;
            }
            String derivedValue = String.format("%s%d", originalValue, i);
            this.myTemplateState.put(parameter.id, derivedValue);
            if (component instanceof JTextField) {
                ((JTextField)component).setText(derivedValue);
            }
            this.myTemplateState.myModified.remove(paramName);
        }
    }

    @Nullable
    private Set<Object> getRelatedValues(@NotNull Parameter param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/android/tools/idea/npw/TemplateParameterStep", "getRelatedValues"));
        }
        TemplateMetadata metadata = this.myTemplateState.getTemplateMetadata();
        if (metadata == null) {
            return null;
        }
        HashSet relatedValues = Sets.newHashSet();
        for (Parameter related : metadata.getRelatedParams(param)) {
            if (related.id == null) continue;
            relatedValues.add(this.myTemplateState.get(related.id));
        }
        return relatedValues;
    }

    @Override
    protected void deriveValues() {
        super.deriveValues();
        String thumb = this.myTemplateState.getTemplateMetadata().getThumbnailPath(this.myTemplateState);
        if (thumb == null) {
            this.myPreview.setIcon(AndroidIcons.Wizards.DefaultTemplate256);
        } else if (!thumb.isEmpty() && !thumb.equals(this.myCurrentThumb)) {
            File file = new File(this.myTemplateState.getTemplate().getRootPath(), thumb.replace('/', File.separatorChar));
            try {
                byte[] bytes = Files.toByteArray((File)file);
                ImageIcon previewImage = new ImageIcon(bytes);
                this.myPreview.setIcon(new ImageIcon(previewImage.getImage().getScaledInstance(256, 256, 4)));
                this.myCurrentThumb = thumb;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        HashSet layoutNames = Sets.newHashSet();
        Collection<Parameter> parameters = this.myTemplateState.getTemplateMetadata().getParameters();
        for (Parameter parameter : parameters) {
            if (!parameter.constraints.contains((Object)Parameter.Constraint.UNIQUE)) continue;
            String value = this.myTemplateState.getString(parameter.id);
            if (parameter.constraints.contains((Object)Parameter.Constraint.LAYOUT) && layoutNames.contains(value)) {
                this.setErrorHtml(String.format("Layout name %s is already in use. Please choose a unique name.", value));
                return false;
            }
            layoutNames.add(value);
        }
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this.myContainer;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusComponent;
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JLabel jLabel = this.myDescription;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateParameterStep", "getDescription"));
        }
        return jLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateParameterStep", "getError"));
        }
        return jLabel;
    }

    @Override
    public boolean isStepVisible() {
        boolean hasVisibleParameter = false;
        if (this.myTemplateState.hasTemplate()) {
            Collection<Parameter> parameters = this.myTemplateState.getTemplateMetadata().getParameters();
            for (Parameter parameter : parameters) {
                if (this.myTemplateState.myHidden.contains(parameter.id)) continue;
                hasVisibleParameter = true;
                break;
            }
        }
        return hasVisibleParameter && this.myVisible;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        JPanel jPanel2;
        this.myContainer = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myParamContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 7, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, new Dimension(-1, 100), null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Description", 0, 0, null, null));
        this.myDescription = jLabel3 = new JLabel();
        jLabel3.setText("");
        jLabel3.setVerticalAlignment(1);
        ((Component)jLabel3).setBackground(new Color(-1118482));
        jLabel3.setVerticalTextPosition(1);
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 3, null, null, null));
        this.myError = jLabel2 = new JLabel();
        jLabel2.setText("");
        jLabel2.setVerticalAlignment(3);
        ((Component)jLabel2).setBackground(new Color(-1118482));
        jLabel2.setVerticalTextPosition(3);
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 0, 3, 6, 6, null, null, null));
        this.myPreview = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 4, 0, 1, 0, new Dimension(256, -1), new Dimension(256, -1), new Dimension(256, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }
}

