/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.AssetStudioAssetGenerator;
import com.android.tools.idea.npw.ChooseOutputResDirStep;
import com.android.tools.idea.npw.VectorAssetSetStep;
import com.android.tools.idea.wizard.template.TemplateWizard;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.JButton;
import org.jetbrains.annotations.Nullable;

public class VectorAssetStudioWizard
extends TemplateWizard
implements TemplateWizardStep.UpdateListener {
    protected Module myModule;
    protected VirtualFile myTargetFile;
    protected TemplateWizardState myWizardState = new TemplateWizardState();
    protected ChooseOutputResDirStep myOutputStep;
    protected VectorAssetSetStep myIconStep;
    private static final String helpPage = "http://developer.android.com/tools/help/vector-asset-studio.html";

    public VectorAssetStudioWizard(@Nullable Project project, @Nullable Module module, @Nullable VirtualFile targetFile) {
        super("Vector Asset Studio", project);
        this.myModule = module;
        this.myTargetFile = targetFile;
        this.getWindow().setMinimumSize((Dimension)JBUI.size((int)700, (int)700));
        this.init();
    }

    @Override
    protected void init() {
        this.myIconStep = new VectorAssetSetStep(this.myWizardState, this.myProject, this.myModule, null, this, this.myTargetFile);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myIconStep);
        this.myOutputStep = new ChooseOutputResDirStep(this.myWizardState, this.myProject, null, TemplateWizardStep.NONE, this.myModule, this.myTargetFile);
        this.addStep((Step)this.myIconStep);
        this.addStep((Step)this.myOutputStep);
        this.myWizardState.put("sourceType", (Object)AssetStudioAssetGenerator.SourceType.VECTORDRAWABLE);
        JButton helpButton = this.getHelpButton();
        if (Desktop.isDesktopSupported()) {
            helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        URI link = new URI(VectorAssetStudioWizard.helpPage);
                        Desktop.getDesktop().browse(link);
                    }
                    catch (Exception e1) {
                        DialogBuilder builder = new DialogBuilder(VectorAssetStudioWizard.this.myProject);
                        builder.setTitle("Error");
                        builder.setErrorText("Can't show http://developer.android.com/tools/help/vector-asset-studio.html");
                        builder.show();
                    }
                }
            });
        } else {
            helpButton.hide();
        }
        this.getNextButton().disable();
        super.init();
    }

    @Override
    public void update() {
        super.update();
        if (this.myOutputStep != null) {
            this.myOutputStep.updateStep();
        }
    }

    public void createAssets() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                VectorAssetStudioWizard.this.myIconStep.createAssets(null);
            }
        });
    }
}

