/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.tools.idea.rendering.FlagManager;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Locale {
    private static final LocaleQualifier ANY_QUALIFIER = new LocaleQualifier("__");
    public static final Locale ANY = new Locale(ANY_QUALIFIER);
    @NotNull
    public final LocaleQualifier qualifier;
    public static final Comparator<Locale> LANGUAGE_NAME_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String name2;
            String language1 = locale1.qualifier.getLanguage();
            String language2 = locale2.qualifier.getLanguage();
            if (locale1.qualifier.hasFakeValue()) {
                return locale2.qualifier.hasFakeValue() ? 0 : -1;
            }
            if (locale2.qualifier.hasFakeValue()) {
                return 1;
            }
            String name1 = LocaleManager.getLanguageName((String)language1);
            int compare = StringUtil.compare((String)name1, (String)(name2 = LocaleManager.getLanguageName((String)language2)), (boolean)false);
            if (compare == 0) {
                return REGION_NAME_COMPARATOR.compare(locale1, locale2);
            }
            return compare;
        }
    };
    public static final Comparator<Locale> LANGUAGE_CODE_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String language1 = locale1.qualifier.getLanguage();
            String language2 = locale2.qualifier.getLanguage();
            if (locale1.qualifier.hasFakeValue()) {
                return locale2.qualifier.hasFakeValue() ? 0 : -1;
            }
            if (locale2.qualifier.hasFakeValue()) {
                return 1;
            }
            int compare = StringUtil.compare((String)language1, (String)language2, (boolean)false);
            if (compare == 0) {
                return REGION_CODE_COMPARATOR.compare(locale1, locale2);
            }
            return compare;
        }
    };
    public static final Comparator<Locale> REGION_NAME_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String region1 = locale1.qualifier.getRegion();
            String region2 = locale2.qualifier.getRegion();
            if (region1 == null) {
                return region2 == null ? 0 : -1;
            }
            if (region2 == null) {
                return 1;
            }
            String regionName1 = LocaleManager.getRegionName((String)region1);
            String regionName2 = LocaleManager.getRegionName((String)region2);
            return StringUtil.compare((String)regionName1, (String)regionName2, (boolean)false);
        }
    };
    public static final Comparator<Locale> REGION_CODE_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String region1 = locale1.qualifier.getRegion();
            String region2 = locale2.qualifier.getRegion();
            if (region1 == null) {
                return region2 == null ? 0 : -1;
            }
            if (region2 == null) {
                return 1;
            }
            return StringUtil.compare((String)region1, (String)region2, (boolean)false);
        }
    };

    private Locale(@NotNull LocaleQualifier locale) {
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/rendering/Locale", "<init>"));
        }
        this.qualifier = locale;
    }

    @NotNull
    public static Locale create(@NotNull LocaleQualifier locale) {
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/rendering/Locale", "create"));
        }
        Locale locale2 = new Locale(locale);
        if (locale2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/Locale", "create"));
        }
        return locale2;
    }

    public static Locale create(FolderConfiguration folder) {
        LocaleQualifier locale = folder.getLocaleQualifier();
        if (locale == null) {
            return ANY;
        }
        return new Locale(locale);
    }

    @NotNull
    public static Locale create(@NotNull String localeString) {
        if (localeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localeString", "com/android/tools/idea/rendering/Locale", "create"));
        }
        LocaleQualifier qualifier = LocaleQualifier.getQualifier((String)localeString);
        if (qualifier != null) {
            Locale locale = new Locale(qualifier);
            if (locale == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/Locale", "create"));
            }
            return locale;
        }
        Locale locale = ANY;
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/Locale", "create"));
        }
        return locale;
    }

    @NotNull
    public Icon getFlagImage() {
        String languageCode;
        String string = languageCode = this.qualifier.hasLanguage() ? this.qualifier.getLanguage() : null;
        if (languageCode == null) {
            Icon icon = AndroidIcons.EmptyFlag;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/Locale", "getFlagImage"));
            }
            return icon;
        }
        String regionCode = this.hasRegion() ? this.qualifier.getRegion() : null;
        FlagManager icons = FlagManager.get();
        Icon image = icons.getFlag(languageCode, regionCode);
        if (image == null) {
            image = AndroidIcons.EmptyFlag;
        }
        Icon icon = image;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/Locale", "getFlagImage"));
        }
        return icon;
    }

    public boolean hasLanguage() {
        return !this.qualifier.hasFakeValue();
    }

    public boolean hasRegion() {
        return this.qualifier.getRegion() != null && !"__".equals(this.qualifier.getRegion());
    }

    public String toLocaleId() {
        return this.qualifier == ANY_QUALIFIER ? "" : this.qualifier.getTag();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.qualifier.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Locale other = (Locale)obj;
        return this.qualifier.equals((Object)other.qualifier);
    }

    public String toString() {
        return this.qualifier.getTag();
    }
}

