/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ManualVariance;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.VarianceConflictDiagnosticData;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.typeBinding.TypeArgumentBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u001cJ\u001c\u0010 \u001a\u00020\u000e*\u00020!2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0002J#\u0010$\u001a\u0004\u0018\u00010\u000e*\u00020%2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010&\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010'J\"\u0010$\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020#H\u0002J\u001a\u0010$\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010&\u001a\u00020#H\u0002J\f\u0010,\u001a\u00020#*\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/resolve/VarianceCheckerCore;", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "diagnosticSink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "manualVariance", "Lorg/jetbrains/kotlin/resolve/ManualVariance;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Lorg/jetbrains/kotlin/resolve/ManualVariance;)V", "check", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkCallableDeclaration", "", "trace", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkClassHeader", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "checkClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkClasses", "checkMember", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkMembers", "isIrrelevant", "recordPrivateToThisIfNeeded", "checkTypeParameters", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "typePosition", "Lorg/jetbrains/kotlin/types/Variance;", "checkTypePosition", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "position", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/types/Variance;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/resolve/typeBinding/TypeBinding;", "Lcom/intellij/psi/PsiElement;", "containingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "varianceWithManual", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Companion", "frontend"})
public final class VarianceCheckerCore {
    private final BindingContext context;
    private final DiagnosticSink diagnosticSink;
    private final ManualVariance manualVariance;
    public static final Companion Companion = new Companion(null);

    public final void check(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        this.checkClasses(c);
        this.checkMembers(c);
    }

    public final boolean checkClassOrObject(@NotNull KtClassOrObject klass2) {
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        if (klass2 instanceof KtClass && !this.checkClassHeader((KtClass)klass2)) {
            return false;
        }
        for (KtDeclaration member : CollectionsKt.plus((Collection)klass2.getDeclarations(), (Iterable)klass2.getPrimaryConstructorParameters())) {
            CallableMemberDescriptor descriptor2;
            DeclarationDescriptor declarationDescriptor;
            KtDeclaration ktDeclaration = member;
            if (!(ktDeclaration instanceof KtCallableDeclaration)) {
                ktDeclaration = null;
            }
            if ((KtCallableDeclaration)ktDeclaration == null) {
                continue;
            }
            KtDeclaration ktDeclaration2 = member;
            if (!((ktDeclaration2 instanceof KtParameter ? (DeclarationDescriptor)this.context.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, member) : (declarationDescriptor = ktDeclaration2 instanceof KtCallableDeclaration ? this.context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, member) : (DeclarationDescriptor)null)) instanceof CallableMemberDescriptor)) {
                declarationDescriptor = null;
            }
            if ((CallableMemberDescriptor)declarationDescriptor == null) {
                continue;
            }
            if (this.checkMember((KtCallableDeclaration)member, descriptor2)) continue;
            return false;
        }
        return true;
    }

    private final void checkClasses(TopDownAnalysisContext c) {
        Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> map2 = c.getDeclaredClasses();
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        for (KtClassOrObject jetClassOrObject : map2.keySet()) {
            if (!(jetClassOrObject instanceof KtClass)) continue;
            this.checkClassHeader((KtClass)jetClassOrObject);
        }
    }

    private final boolean checkClassHeader(KtClass klass2) {
        boolean noError = true;
        for (KtSuperTypeListEntry specifier : klass2.getSuperTypeListEntries()) {
            KtTypeReference ktTypeReference = specifier.getTypeReference();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, this.context, Variance.OUT_VARIANCE) : null);
        }
        return noError & this.checkTypeParameters(klass2, this.context, Variance.OUT_VARIANCE);
    }

    private final void checkMembers(TopDownAnalysisContext c) {
        Map<KtCallableDeclaration, CallableMemberDescriptor> map2 = c.getMembers();
        Iterator<Map.Entry<KtCallableDeclaration, CallableMemberDescriptor>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry;
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry2 = entry = iterator2.next();
            KtCallableDeclaration declaration = entry2.getKey();
            Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry3 = entry;
            CallableMemberDescriptor descriptor2 = entry3.getValue();
            KtCallableDeclaration ktCallableDeclaration = declaration;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktCallableDeclaration, (String)"declaration");
            CallableMemberDescriptor callableMemberDescriptor = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"descriptor");
            this.checkMember(ktCallableDeclaration, callableMemberDescriptor);
        }
    }

    private final boolean checkMember(KtCallableDeclaration member, CallableMemberDescriptor descriptor2) {
        return Visibilities.isPrivate(descriptor2.getVisibility()) || this.checkCallableDeclaration(this.context, member, descriptor2);
    }

    private final Variance varianceWithManual(@NotNull TypeParameterDescriptor $receiver) {
        Variance variance;
        if (this.manualVariance != null && Intrinsics.areEqual((Object)$receiver, (Object)this.manualVariance.getDescriptor())) {
            variance = this.manualVariance.getVariance();
        } else {
            Variance variance2 = $receiver.getVariance();
            variance = variance2;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance2), (String)"variance");
        }
        return variance;
    }

    public final void recordPrivateToThisIfNeeded(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (this.isIrrelevant(descriptor2) || Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)Visibilities.PRIVATE) ^ true) {
            return;
        }
        PsiElement psiElement = KotlinSourceElementKt.getPsi(descriptor2.getSource());
        if (!(psiElement instanceof KtCallableDeclaration)) {
            psiElement = null;
        }
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement;
        if (ktCallableDeclaration == null) {
            return;
        }
        KtCallableDeclaration psiElement2 = ktCallableDeclaration;
        if (!this.checkCallableDeclaration(this.context, psiElement2, descriptor2)) {
            VarianceCheckerCore.Companion.recordPrivateToThis(descriptor2);
        }
    }

    private final boolean checkCallableDeclaration(BindingContext trace, KtCallableDeclaration declaration, CallableDescriptor descriptor2) {
        if (this.isIrrelevant(descriptor2)) {
            return true;
        }
        boolean noError = true;
        noError &= this.checkTypeParameters(declaration, trace, Variance.IN_VARIANCE);
        KtTypeReference ktTypeReference = declaration.getReceiverTypeReference();
        noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, Variance.IN_VARIANCE) : null);
        for (KtParameter parameter : declaration.getValueParameters()) {
            KtTypeReference ktTypeReference2 = parameter.getTypeReference();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference2 != null ? this.checkTypePosition(ktTypeReference2, trace, Variance.IN_VARIANCE) : null);
        }
        Variance returnTypePosition = descriptor2 instanceof VariableDescriptor && ((VariableDescriptor)descriptor2).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        TypeBinding<PsiElement> typeBinding = TypeBindingKt.createTypeBindingForReturnType(declaration, trace);
        noError = VarianceCheckerCore.Companion.and(noError, typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, returnTypePosition)) : null);
        return noError;
    }

    private final boolean checkTypeParameters(@NotNull KtTypeParameterListOwner $receiver, BindingContext trace, Variance typePosition) {
        boolean noError = true;
        for (KtTypeParameter typeParameter : $receiver.getTypeParameters()) {
            KtTypeReference ktTypeReference = typeParameter.getExtendsBound();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, typePosition) : null);
        }
        for (KtTypeConstraint typeConstraint : $receiver.getTypeConstraints()) {
            KtTypeReference ktTypeReference = typeConstraint.getBoundTypeReference();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, typePosition) : null);
        }
        return noError;
    }

    private final Boolean checkTypePosition(@NotNull KtTypeReference $receiver, BindingContext trace, Variance position2) {
        TypeBinding<KtTypeElement> typeBinding = TypeBindingKt.createTypeBinding($receiver, trace);
        return typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, position2)) : null;
    }

    private final boolean checkTypePosition(@NotNull TypeBinding<? extends PsiElement> $receiver, Variance position2) {
        return this.checkTypePosition($receiver, $receiver.getKotlinType(), position2);
    }

    private final boolean checkTypePosition(@NotNull TypeBinding<? extends PsiElement> $receiver, KotlinType containingType, Variance position2) {
        ClassifierDescriptor classifierDescriptor = $receiver.getKotlinType().getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            Variance declarationVariance = this.varianceWithManual((TypeParameterDescriptor)classifierDescriptor);
            if (!declarationVariance.allowsPosition(position2)) {
                Annotations annotations2 = $receiver.getKotlinType().getAnnotations();
                FqName fqName2 = KotlinBuiltIns.FQ_NAMES.unsafeVariance;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.unsafeVariance");
                if (!annotations2.hasAnnotation(fqName2)) {
                    this.diagnosticSink.report(Errors.TYPE_VARIANCE_CONFLICT.on($receiver.getPsiElement(), new VarianceConflictDiagnosticData(containingType, (TypeParameterDescriptor)classifierDescriptor, position2)));
                }
            }
            return declarationVariance.allowsPosition(position2);
        }
        boolean noError = true;
        for (TypeArgumentBinding<? extends PsiElement> argumentBinding : $receiver.getArgumentBindings()) {
            Variance newPosition;
            Variance variance;
            TypeCheckingProcedure.EnrichedProjectionKind projectionKind;
            TypeCheckingProcedure.EnrichedProjectionKind enrichedProjectionKind;
            if (argumentBinding == null || argumentBinding.getTypeParameterDescriptor() == null) continue;
            TypeParameterDescriptor typeParameterDescriptor = argumentBinding.getTypeParameterDescriptor();
            if (typeParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            if (TypeCheckingProcedure.getEffectiveProjectionKind(typeParameterDescriptor, argumentBinding.getTypeProjection()) == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual((Object)((Object)(enrichedProjectionKind = projectionKind)), (Object)((Object)TypeCheckingProcedure.EnrichedProjectionKind.OUT))) {
                variance = position2;
            } else if (Intrinsics.areEqual((Object)((Object)enrichedProjectionKind), (Object)((Object)TypeCheckingProcedure.EnrichedProjectionKind.IN))) {
                variance = position2.opposite();
            } else if (Intrinsics.areEqual((Object)((Object)enrichedProjectionKind), (Object)((Object)TypeCheckingProcedure.EnrichedProjectionKind.INV))) {
                variance = Variance.INVARIANT;
            } else if (Intrinsics.areEqual((Object)((Object)enrichedProjectionKind), (Object)((Object)TypeCheckingProcedure.EnrichedProjectionKind.STAR))) {
                variance = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if ((newPosition = variance) == null) continue;
            noError &= this.checkTypePosition(argumentBinding.getTypeBinding(), containingType, newPosition);
        }
        return noError;
    }

    private final boolean isIrrelevant(CallableDescriptor descriptor2) {
        boolean bl;
        block3: {
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            if (classDescriptor == null) {
                return true;
            }
            ClassDescriptor containingClass = classDescriptor;
            Iterable $receiver$iv = containingClass.getTypeConstructor().getParameters();
            for (Object element$iv : $receiver$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                if (Intrinsics.areEqual((Object)((Object)this.varianceWithManual(it)), (Object)((Object)Variance.INVARIANT))) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    public VarianceCheckerCore(@NotNull BindingContext context, @NotNull DiagnosticSink diagnosticSink, @Nullable ManualVariance manualVariance) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticSink, (String)"diagnosticSink");
        this.context = context;
        this.diagnosticSink = diagnosticSink;
        this.manualVariance = manualVariance;
    }

    public /* synthetic */ VarianceCheckerCore(BindingContext bindingContext2, DiagnosticSink diagnosticSink, ManualVariance manualVariance, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            manualVariance = null;
        }
        this(bindingContext2, diagnosticSink, manualVariance);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u00020\b*\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0082\u0004\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/VarianceCheckerCore$Companion;", "", "()V", "recordPrivateToThis", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "and", "", "other", "(ZLjava/lang/Boolean;)Z", "frontend"})
    public static final class Companion {
        private final void recordPrivateToThis(CallableMemberDescriptor descriptor2) {
            CallableMemberDescriptor callableMemberDescriptor = descriptor2;
            if (callableMemberDescriptor instanceof FunctionDescriptorImpl) {
                ((FunctionDescriptorImpl)descriptor2).setVisibility(Visibilities.PRIVATE_TO_THIS);
            } else if (callableMemberDescriptor instanceof PropertyDescriptorImpl) {
                ((PropertyDescriptorImpl)descriptor2).setVisibility(Visibilities.PRIVATE_TO_THIS);
                Iterator<PropertyAccessorDescriptor> iterator2 = ((PropertyDescriptorImpl)descriptor2).getAccessors().iterator();
                while (iterator2.hasNext()) {
                    PropertyAccessorDescriptor accessor;
                    PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = iterator2.next();
                    if (propertyAccessorDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl");
                    }
                    ((PropertyAccessorDescriptorImpl)propertyAccessorDescriptor).setVisibility(Visibilities.PRIVATE_TO_THIS);
                }
            } else {
                throw (Throwable)new IllegalStateException("Unexpected descriptor type: " + descriptor2.getClass().getName());
            }
        }

        private final boolean and(boolean $receiver, Boolean other) {
            return other == null ? $receiver : $receiver & other;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

