/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.descriptor;

import java.util.Optional;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.descriptor.JavaClassSource;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.vintage.engine.descriptor.RunnerRequest;
import org.junit.vintage.engine.descriptor.VintageTestDescriptor;

@API(value=API.Usage.Internal)
public class RunnerTestDescriptor
extends VintageTestDescriptor {
    private final Runner runner;
    private final Class<?> testClass;

    public RunnerTestDescriptor(TestDescriptor parent, Class<?> testClass, Runner runner) {
        super(parent, "runner", testClass.getName(), runner.getDescription(), testClass.getName(), Optional.of(new JavaClassSource(testClass)));
        this.testClass = testClass;
        this.runner = runner;
    }

    public Runner getRunner() {
        return this.runner;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Request toRequest() {
        return new RunnerRequest(this.runner);
    }
}

