/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.runner;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.JavaClassSource;
import org.junit.platform.engine.support.descriptor.JavaMethodSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.runner.UseTechnicalNames;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

class JUnitPlatformTestTree {
    private final Map<TestIdentifier, Description> descriptions = new HashMap<TestIdentifier, Description>();
    private final TestPlan plan;
    private final Function<TestIdentifier, String> nameExtractor;
    private final Description suiteDescription;

    JUnitPlatformTestTree(TestPlan plan, Class<?> testClass) {
        this.plan = plan;
        this.nameExtractor = JUnitPlatformTestTree.useTechnicalNames(testClass) ? this::getTechnicalName : TestIdentifier::getDisplayName;
        this.suiteDescription = this.generateSuiteDescription(plan, testClass);
    }

    private static boolean useTechnicalNames(Class<?> testClass) {
        return testClass.isAnnotationPresent(UseTechnicalNames.class);
    }

    Description getSuiteDescription() {
        return this.suiteDescription;
    }

    Description getDescription(TestIdentifier identifier) {
        return this.descriptions.get(identifier);
    }

    private Description generateSuiteDescription(TestPlan testPlan, Class<?> testClass) {
        Description suiteDescription = Description.createSuiteDescription((String)testClass.getName(), (Annotation[])new Annotation[0]);
        this.buildDescriptionTree(suiteDescription, testPlan);
        return suiteDescription;
    }

    private void buildDescriptionTree(Description suiteDescription, TestPlan testPlan) {
        testPlan.getRoots().forEach(testIdentifier -> this.buildDescription((TestIdentifier)testIdentifier, suiteDescription, testPlan));
    }

    void addDynamicDescription(TestIdentifier newIdentifier, String parentId) {
        Description parent = this.getDescription(this.plan.getTestIdentifier(parentId));
        this.plan.add(newIdentifier);
        this.buildDescription(newIdentifier, parent, this.plan);
    }

    private void buildDescription(TestIdentifier identifier, Description parent, TestPlan testPlan) {
        Description newDescription = this.createJUnit4Description(identifier, testPlan);
        parent.addChild(newDescription);
        this.descriptions.put(identifier, newDescription);
        testPlan.getChildren(identifier).forEach(testIdentifier -> this.buildDescription((TestIdentifier)testIdentifier, newDescription, testPlan));
    }

    private Description createJUnit4Description(TestIdentifier identifier, TestPlan testPlan) {
        String name = this.nameExtractor.apply(identifier);
        if (identifier.isTest()) {
            String containerName = testPlan.getParent(identifier).map(this.nameExtractor).orElse("<unrooted>");
            return Description.createTestDescription((String)containerName, (String)name, (Serializable)((Object)identifier.getUniqueId()));
        }
        return Description.createSuiteDescription((String)name, (Serializable)((Object)identifier.getUniqueId()), (Annotation[])new Annotation[0]);
    }

    private String getTechnicalName(TestIdentifier testIdentifier) {
        Optional optionalSource = testIdentifier.getSource();
        if (optionalSource.isPresent()) {
            TestSource source = (TestSource)optionalSource.get();
            if (source instanceof JavaClassSource) {
                return ((JavaClassSource)source).getJavaClass().getName();
            }
            if (source instanceof JavaMethodSource) {
                JavaMethodSource javaMethodSource = (JavaMethodSource)source;
                List parameterTypes = javaMethodSource.getJavaMethodParameterTypes();
                if (parameterTypes.size() == 0) {
                    return javaMethodSource.getJavaMethodName();
                }
                return String.format("%s(%s)", javaMethodSource.getJavaMethodName(), StringUtils.nullSafeToString(Class::getName, (Class[])parameterTypes.toArray(new Class[parameterTypes.size()])));
            }
        }
        return testIdentifier.getDisplayName();
    }

    Set<TestIdentifier> getTestsInSubtree(TestIdentifier ancestor) {
        return this.plan.getDescendants(ancestor).stream().filter(TestIdentifier::isTest).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    Set<TestIdentifier> getFilteredLeaves(Filter filter) {
        Set<TestIdentifier> identifiers = this.applyFilterToDescriptions(filter);
        return this.removeNonLeafIdentifiers(identifiers);
    }

    private Set<TestIdentifier> removeNonLeafIdentifiers(Set<TestIdentifier> identifiers) {
        return identifiers.stream().filter(this.isALeaf(identifiers)).collect(Collectors.toSet());
    }

    private Predicate<? super TestIdentifier> isALeaf(Set<TestIdentifier> identifiers) {
        return testIdentifier -> {
            Set descendants = this.plan.getDescendants(testIdentifier);
            return identifiers.stream().noneMatch(descendants::contains);
        };
    }

    private Set<TestIdentifier> applyFilterToDescriptions(Filter filter) {
        return this.descriptions.entrySet().stream().filter(entry -> filter.shouldRun((Description)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

