/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.FilterUtil;
import org.jetbrains.annotations.NotNull;

public class KeywordLookupItem
extends LookupElement
implements TypedLookupItem {
    private final PsiElement myPosition;
    private final PsiKeyword myKeyword;

    public KeywordLookupItem(PsiKeyword keyword, @NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/lookup/KeywordLookupItem", "<init>"));
        }
        this.myKeyword = keyword;
        this.myPosition = position;
    }

    @NotNull
    public Object getObject() {
        PsiKeyword psiKeyword = this.myKeyword;
        if (psiKeyword == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/KeywordLookupItem", "getObject"));
        }
        return psiKeyword;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myKeyword.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/KeywordLookupItem", "getLookupString"));
        }
        return string;
    }

    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE;
    }

    public boolean equals(Object o) {
        return o instanceof KeywordLookupItem && this.getLookupString().equals(((KeywordLookupItem)o).getLookupString());
    }

    public int hashCode() {
        return this.getLookupString().hashCode();
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.getLookupString());
        presentation.setItemTextBold(true);
    }

    @Override
    public PsiType getType() {
        return FilterUtil.getKeywordItemType(this.myPosition, this.getLookupString());
    }
}

