/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Key;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

abstract class PResults {
    static final PResult Identity = new PResult(){

        public String toString() {
            return "Identity";
        }
    };
    static final PResult Return = new PResult(){

        public String toString() {
            return "Return";
        }
    };
    static final PResult NPE = new PResult(){

        public String toString() {
            return "NPE";
        }
    };

    PResults() {
    }

    static Set<Set<Key>> join(Set<Set<Key>> sop1, Set<Set<Key>> sop2) {
        HashSet<Set<Key>> sop = new HashSet<Set<Key>>();
        sop.addAll(sop1);
        sop.addAll(sop2);
        return sop;
    }

    static Set<Set<Key>> meet(Set<Set<Key>> sop1, Set<Set<Key>> sop2) {
        HashSet<Set<Key>> sop = new HashSet<Set<Key>>();
        for (Set<Key> prod1 : sop1) {
            for (Set<Key> prod2 : sop2) {
                HashSet<Key> prod = new HashSet<Key>();
                prod.addAll(prod1);
                prod.addAll(prod2);
                sop.add(prod);
            }
        }
        return sop;
    }

    static PResult combineNullable(PResult r1, PResult r2) throws AnalyzerException {
        if (Identity == r1) {
            return r2;
        }
        if (Identity == r2) {
            return r1;
        }
        if (Return == r1) {
            return r2;
        }
        if (Return == r2) {
            return r1;
        }
        if (NPE == r1) {
            return NPE;
        }
        if (NPE == r2) {
            return NPE;
        }
        ConditionalNPE cnpe1 = (ConditionalNPE)r1;
        ConditionalNPE cnpe2 = (ConditionalNPE)r2;
        return new ConditionalNPE(PResults.join(cnpe1.sop, cnpe2.sop));
    }

    static PResult join(PResult r1, PResult r2) throws AnalyzerException {
        if (Identity == r1) {
            return r2;
        }
        if (Identity == r2) {
            return r1;
        }
        if (Return == r1) {
            return Return;
        }
        if (Return == r2) {
            return Return;
        }
        if (NPE == r1) {
            return r2;
        }
        if (NPE == r2) {
            return r1;
        }
        ConditionalNPE cnpe1 = (ConditionalNPE)r1;
        ConditionalNPE cnpe2 = (ConditionalNPE)r2;
        return new ConditionalNPE(PResults.join(cnpe1.sop, cnpe2.sop));
    }

    static PResult meet(PResult r1, PResult r2) throws AnalyzerException {
        if (Identity == r1) {
            return r2;
        }
        if (Return == r1) {
            return r2;
        }
        if (Return == r2) {
            return r1;
        }
        if (NPE == r1) {
            return NPE;
        }
        if (NPE == r2) {
            return NPE;
        }
        if (Identity == r2) {
            return Identity;
        }
        ConditionalNPE cnpe1 = (ConditionalNPE)r1;
        ConditionalNPE cnpe2 = (ConditionalNPE)r2;
        return new ConditionalNPE(PResults.meet(cnpe1.sop, cnpe2.sop));
    }

    static final class ConditionalNPE
    implements PResult {
        final Set<Set<Key>> sop;

        public ConditionalNPE(Set<Set<Key>> sop) throws AnalyzerException {
            this.sop = sop;
            ConditionalNPE.checkLimit(sop);
        }

        public ConditionalNPE(Key key2) {
            this.sop = new HashSet<Set<Key>>();
            HashSet<Key> prod = new HashSet<Key>();
            prod.add(key2);
            this.sop.add(prod);
        }

        static void checkLimit(Set<Set<Key>> sop) throws AnalyzerException {
            int size = 0;
            for (Set<Key> keys : sop) {
                size += keys.size();
            }
            if (size > 30) {
                throw new AnalyzerException(null, "Equation size is too big");
            }
        }
    }

    static interface PResult {
    }
}

