/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaExpressionFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory");
    private static final Condition<String> FALSE_GETTERS = DfaExpressionFactory.parseFalseGetters();
    private final DfaValueFactory myFactory;
    private final Map<Integer, PsiVariable> myMockIndices = ContainerUtil.newHashMap();

    private static Condition<String> parseFalseGetters() {
        try {
            String regex = Registry.stringValue((String)"ide.dfa.getters.with.side.effects").trim();
            if (!StringUtil.isEmpty((String)regex)) {
                Pattern pattern = Pattern.compile(regex);
                return s -> pattern.matcher((CharSequence)s).matches();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return Conditions.alwaysFalse();
    }

    public DfaExpressionFactory(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    @Nullable
    public DfaValue getExpressionDfaValue(@Nullable PsiExpression expression) {
        DfaValue qualifier;
        if (expression == null) {
            return null;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return this.getExpressionDfaValue(((PsiParenthesizedExpression)expression).getExpression());
        }
        PsiType type = expression.getType();
        if (expression instanceof PsiArrayAccessExpression) {
            PsiVariable indexVar;
            PsiExpression arrayExpression = ((PsiArrayAccessExpression)expression).getArrayExpression();
            qualifier = this.getExpressionDfaValue(arrayExpression);
            if (qualifier instanceof DfaVariableValue && (indexVar = this.getArrayIndexVariable(((PsiArrayAccessExpression)expression).getIndexExpression())) != null) {
                return this.myFactory.getVarFactory().createVariableValue((PsiModifierListOwner)indexVar, expression.getType(), false, (DfaVariableValue)qualifier);
            }
            if (type != null) {
                return this.myFactory.createTypeValue(type, DfaPsiUtil.getElementNullability(type, null));
            }
        }
        if (expression instanceof PsiMethodCallExpression) {
            return this.createReferenceValue(((PsiMethodCallExpression)expression).getMethodExpression());
        }
        if (expression instanceof PsiReferenceExpression) {
            return this.createReferenceValue((PsiReferenceExpression)expression);
        }
        if (expression instanceof PsiLiteralExpression) {
            return this.myFactory.createLiteralValue((PsiLiteralExpression)expression);
        }
        if (expression instanceof PsiNewExpression || expression instanceof PsiLambdaExpression) {
            return this.myFactory.createTypeValue(expression.getType(), Nullness.NOT_NULL);
        }
        Object value = JavaConstantExpressionEvaluator.computeConstantExpression(expression, false);
        if (value != null && type != null) {
            if (value instanceof String) {
                return this.myFactory.createTypeValue(type, Nullness.NOT_NULL);
            }
            return this.myFactory.getConstFactory().createFromValue(value, type, null);
        }
        if (expression instanceof PsiThisExpression) {
            PsiElement target;
            qualifier = ((PsiThisExpression)expression).getQualifier();
            PsiElement psiElement = target = qualifier == null ? null : qualifier.resolve();
            if (target instanceof PsiClass) {
                return this.myFactory.getVarFactory().createVariableValue((PsiModifierListOwner)target, null, false, null);
            }
        }
        return null;
    }

    private DfaValue createReferenceValue(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory", "createReferenceValue"));
        }
        PsiModifierListOwner var = DfaExpressionFactory.getAccessedVariableOrGetter(refExpr.resolve());
        if (var == null) {
            return null;
        }
        if (!var.hasModifierProperty("volatile")) {
            DfaValue constValue;
            if (var instanceof PsiVariable && var.hasModifierProperty("final") && !PsiUtil.isAccessedForWriting((PsiExpression)refExpr) && (constValue = this.myFactory.getConstFactory().create((PsiVariable)var)) != null) {
                return constValue;
            }
            if (DfaValueFactory.isEffectivelyUnqualified(refExpr)) {
                return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), false, null);
            }
            DfaValue qualifierValue = this.getExpressionDfaValue(refExpr.getQualifierExpression());
            if (qualifierValue instanceof DfaVariableValue) {
                return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), false, (DfaVariableValue)qualifierValue);
            }
        }
        PsiType type = refExpr.getType();
        return this.myFactory.createTypeValue(type, DfaPsiUtil.getElementNullability(type, var));
    }

    @Nullable
    private static PsiModifierListOwner getAccessedVariableOrGetter(PsiElement target) {
        String qName;
        PsiMethod method;
        if (target instanceof PsiVariable) {
            return (PsiVariable)target;
        }
        if (target instanceof PsiMethod && PropertyUtil.isSimplePropertyGetter((PsiMethod)(method = (PsiMethod)target)) && !(method.getReturnType() instanceof PsiPrimitiveType) && ((qName = PsiUtil.getMemberQualifiedName((PsiMember)method)) == null || !FALSE_GETTERS.value((Object)qName))) {
            return method;
        }
        return null;
    }

    @Nullable
    private PsiVariable getArrayIndexVariable(@Nullable PsiExpression indexExpression) {
        Object constant = JavaConstantExpressionEvaluator.computeConstantExpression(indexExpression, false);
        if (constant instanceof Integer && (Integer)constant >= 0) {
            PsiVariable mockVar = this.myMockIndices.get(constant);
            if (mockVar == null) {
                mockVar = JavaPsiFacade.getElementFactory((Project)indexExpression.getProject()).createField("$array$index$" + constant, (PsiType)PsiType.INT);
                this.myMockIndices.put((Integer)constant, mockVar);
            }
            return mockVar;
        }
        return null;
    }
}

