/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offlineViewer.OfflineRefElementNode;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionRVContentProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + InspectionRVContentProvider.class.getName()));
    private final Project myProject;

    public InspectionRVContentProvider(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "<init>"));
        }
        this.myProject = project2;
    }

    public abstract boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2);

    public Iterable<? extends ScopeToolState> getTools(Tools tools) {
        return tools.getTools();
    }

    public boolean hasQuickFixes(InspectionTree tree) {
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths == null) {
            return false;
        }
        for (TreePath selectionPath : treePaths) {
            if (TreeUtil.traverseDepth((TreeNode)((TreeNode)selectionPath.getLastPathComponent()), node -> {
                ProblemDescriptionNode problemDescriptionNode;
                if (!((InspectionTreeNode)node).isValid()) {
                    return true;
                }
                if (node instanceof ProblemDescriptionNode && !(problemDescriptionNode = (ProblemDescriptionNode)node).isQuickFixAppliedFromView()) {
                    CommonProblemDescriptor descriptor = problemDescriptionNode.getDescriptor();
                    QuickFix[] fixes = descriptor != null ? descriptor.getFixes() : null;
                    return fixes == null || fixes.length == 0;
                }
                return true;
            })) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public abstract QuickFixAction[] getQuickFixes(@NotNull InspectionToolWrapper var1, @NotNull InspectionTree var2);

    public InspectionNode appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode toolNode, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (toolNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolNode", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "appendToolNodeContent"));
        }
        InspectionToolWrapper wrapper = toolNode.getToolWrapper();
        InspectionToolPresentation presentation = context.getPresentation(wrapper);
        Map<String, Set<RefEntity>> content = presentation.getContent();
        Map<RefEntity, CommonProblemDescriptor[]> problems = presentation.getProblemElements();
        return this.appendToolNodeContent(context, toolNode, parentNode, showStructure, groupBySeverity, content, problems);
    }

    public abstract InspectionNode appendToolNodeContent(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionNode var2, @NotNull InspectionTreeNode var3, boolean var4, boolean var5, @NotNull Map<String, Set<RefEntity>> var6, @NotNull Map<RefEntity, CommonProblemDescriptor[]> var7);

    protected abstract void appendDescriptor(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2, @NotNull UserObjectContainer var3, @NotNull InspectionTreeNode var4, boolean var5);

    public boolean isContentLoaded() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected <T> void buildTree(@NotNull GlobalInspectionContextImpl context, @NotNull Map<String, Set<T>> packageContents, boolean canPackageRepeat, @NotNull InspectionToolWrapper toolWrapper, @NotNull Function<T, UserObjectContainer<T>> computeContainer, boolean showStructure, UnaryOperator<InspectionTreeNode> createdNodesConsumer) {
        Iterator<String> iterator;
        MultiMap packageDescriptors;
        block33: {
            Iterator iterator2;
            HashMap<String, InspectionModuleNode> moduleNodes;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "buildTree"));
            }
            if (packageContents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageContents", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "buildTree"));
            }
            if (toolWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "buildTree"));
            }
            if (computeContainer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computeContainer", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "buildTree"));
            }
            HashMap module2PackageMap = new HashMap();
            boolean supportStructure = showStructure;
            packageDescriptors = new MultiMap();
            iterator = packageContents.keySet().iterator();
            block0: while (true) {
                if (!iterator.hasNext()) {
                    if (supportStructure) {
                        moduleNodes = new HashMap<String, InspectionModuleNode>();
                        iterator2 = module2PackageMap.keySet().iterator();
                        break;
                    }
                    iterator = module2PackageMap.values().iterator();
                    break block33;
                }
                String string = iterator.next();
                Set<T> elements = packageContents.get(string);
                Iterator<T> iterator3 = elements.iterator();
                while (true) {
                    InspectionPackageNode pNode;
                    if (!iterator3.hasNext()) continue block0;
                    T userObject = iterator3.next();
                    UserObjectContainer container = (UserObjectContainer)computeContainer.fun(userObject);
                    supportStructure &= container.supportStructure();
                    String moduleName = showStructure ? container.getModule() : null;
                    HashMap packageNodes = (HashMap)module2PackageMap.get(moduleName);
                    if (packageNodes == null) {
                        packageNodes = new HashMap();
                        module2PackageMap.put(moduleName, packageNodes);
                    }
                    if ((pNode = (InspectionPackageNode)packageNodes.get(string)) == null) {
                        pNode = new InspectionPackageNode(string);
                        packageNodes.put(string, pNode);
                    }
                    packageDescriptors.putValue((Object)pNode, (Object)container);
                }
                break;
            }
            while (iterator2.hasNext()) {
                InspectionModuleNode moduleNode;
                Map packageNodes;
                block35: {
                    block34: {
                        String moduleName = (String)iterator2.next();
                        packageNodes = (Map)module2PackageMap.get(moduleName);
                        moduleNode = (InspectionModuleNode)moduleNodes.get(moduleName);
                        if (moduleNode != null) break block34;
                        if (moduleName != null) {
                            Module module2 = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleName);
                            if (module2 == null) continue;
                            moduleNode = new InspectionModuleNode(module2);
                            moduleNodes.put(moduleName, moduleNode);
                            moduleNode = (InspectionModuleNode)createdNodesConsumer.apply(moduleNode);
                            break block35;
                        } else {
                            for (InspectionPackageNode packageNode : packageNodes.values()) {
                                createdNodesConsumer.apply(packageNode);
                                for (Object container : packageDescriptors.get((Object)packageNode)) {
                                    this.appendDescriptor(context, toolWrapper, (UserObjectContainer)container, packageNode, canPackageRepeat);
                                }
                            }
                            continue;
                        }
                    }
                    moduleNode = (InspectionModuleNode)createdNodesConsumer.apply(moduleNode);
                }
                for (InspectionPackageNode packageNode : packageNodes.values()) {
                    if (packageNode.getPackageName() != null) {
                        Object container;
                        Collection objectContainers = packageDescriptors.get((Object)packageNode);
                        packageNode = (InspectionPackageNode)InspectionRVContentProvider.merge(packageNode, moduleNode, true);
                        container = objectContainers.iterator();
                        while (container.hasNext()) {
                            UserObjectContainer container2 = (UserObjectContainer)container.next();
                            this.appendDescriptor(context, toolWrapper, container2, packageNode, canPackageRepeat);
                        }
                        continue;
                    }
                    for (Object container : packageDescriptors.get((Object)packageNode)) {
                        this.appendDescriptor(context, toolWrapper, (UserObjectContainer)container, moduleNode, canPackageRepeat);
                    }
                }
            }
            return;
        }
        while (iterator.hasNext()) {
            Map map = (Map)((Object)iterator.next());
            block9: for (InspectionPackageNode pNode : map.values()) {
                for (UserObjectContainer container : packageDescriptors.get((Object)pNode)) {
                    this.appendDescriptor(context, toolWrapper, container, pNode, canPackageRepeat);
                }
                int count = pNode.getChildCount();
                ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(count);
                for (int i = 0; i < count; ++i) {
                    childNodes.add(pNode.getChildAt(i));
                }
                for (TreeNode childNode : childNodes) {
                    if (childNode instanceof ProblemDescriptionNode) {
                        createdNodesConsumer.apply(pNode);
                        continue block9;
                    }
                    LOG.assertTrue(childNode instanceof RefElementNode, (Object)childNode.getClass().getName());
                    RefElementNode elementNode = (RefElementNode)childNode;
                    LinkedHashSet<RefElementNode> parentNodes = new LinkedHashSet<RefElementNode>();
                    if (pNode.getPackageName() != null) {
                        parentNodes.add(elementNode);
                    } else {
                        boolean hasElementNodeUnder = true;
                        for (int e = 0; e < elementNode.getChildCount(); ++e) {
                            TreeNode grandChildNode = elementNode.getChildAt(e);
                            if (grandChildNode instanceof ProblemDescriptionNode) {
                                hasElementNodeUnder = false;
                                break;
                            }
                            LOG.assertTrue(grandChildNode instanceof RefElementNode);
                            parentNodes.add((RefElementNode)grandChildNode);
                        }
                        if (!hasElementNodeUnder) {
                            createdNodesConsumer.apply(elementNode);
                            continue;
                        }
                    }
                    for (RefElementNode parentNode : parentNodes) {
                        final ArrayList nodes = new ArrayList();
                        TreeUtil.traverse((TreeNode)parentNode, (TreeUtil.Traverse)new TreeUtil.Traverse(){

                            public boolean accept(Object node) {
                                if (node instanceof ProblemDescriptionNode) {
                                    nodes.add((ProblemDescriptionNode)node);
                                }
                                return true;
                            }
                        });
                        if (nodes.isEmpty()) continue;
                        parentNode.removeAllChildren();
                        for (ProblemDescriptionNode node : nodes) {
                            parentNode.add(node);
                        }
                    }
                    for (RefElementNode node : parentNodes) {
                        createdNodesConsumer.apply(node);
                    }
                }
            }
        }
    }

    @NotNull
    protected static RefElementNode addNodeToParent(@NotNull UserObjectContainer container, @NotNull InspectionToolPresentation presentation, InspectionTreeNode parentNode) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "addNodeToParent"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "addNodeToParent"));
        }
        final RefElementNode nodeToBeAdded = container.createNode(presentation);
        final Ref firstLevel = new Ref((Object)true);
        RefElementNode prevNode = null;
        final Ref result2 = new Ref();
        while (true) {
            UserObjectContainer owner;
            RefElementNode currentNode = (Boolean)firstLevel.get() != false ? nodeToBeAdded : container.createNode(presentation);
            final UserObjectContainer finalContainer = container;
            final RefElementNode finalPrevNode = prevNode;
            TreeUtil.traverseDepth((TreeNode)parentNode, (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    if (node instanceof RefElementNode) {
                        Object object;
                        RefElementNode refElementNode = (RefElementNode)node;
                        Object userObject = finalContainer.getUserObject();
                        Object object2 = object = node instanceof OfflineRefElementNode ? ((OfflineRefElementNode)refElementNode).getOfflineDescriptor() : refElementNode.getUserObject();
                        if ((object == null || userObject.getClass().equals(object.getClass())) && finalContainer.areEqual(object, userObject)) {
                            if (((Boolean)firstLevel.get()).booleanValue()) {
                                result2.set((Object)refElementNode);
                                return false;
                            }
                            refElementNode.insertByOrder(finalPrevNode, false);
                            result2.set((Object)nodeToBeAdded);
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (!result2.isNull()) {
                RefElementNode refElementNode = (RefElementNode)result2.get();
                if (refElementNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "addNodeToParent"));
                }
                return refElementNode;
            }
            if (!((Boolean)firstLevel.get()).booleanValue()) {
                currentNode.insertByOrder(prevNode, false);
            }
            if ((owner = container.getOwner()) == null) {
                parentNode.insertByOrder(currentNode, false);
                RefElementNode refElementNode = nodeToBeAdded;
                if (refElementNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "addNodeToParent"));
                }
                return refElementNode;
            }
            container = owner;
            prevNode = currentNode;
            firstLevel.set((Object)false);
        }
    }

    public static InspectionTreeNode merge(InspectionTreeNode child, InspectionTreeNode parent, boolean merge) {
        if (merge) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                InspectionTreeNode current = (InspectionTreeNode)parent.getChildAt(i);
                if (child.getClass() != current.getClass()) continue;
                if (current instanceof InspectionPackageNode) {
                    if (((InspectionPackageNode)current).getPackageName().compareTo(((InspectionPackageNode)child).getPackageName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(child, current);
                    return current;
                }
                if (current instanceof RefElementNode) {
                    if (InspectionResultsViewComparator.getInstance().compare(current, child) != 0) continue;
                    InspectionRVContentProvider.processDepth(child, current);
                    return current;
                }
                if (current instanceof InspectionNode) {
                    if (((InspectionNode)current).getToolWrapper().getShortName().compareTo(((InspectionNode)child).getToolWrapper().getShortName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(child, current);
                    return current;
                }
                if (!(current instanceof InspectionModuleNode) || ((InspectionModuleNode)current).getName().compareTo(((InspectionModuleNode)child).getName()) != 0) continue;
                InspectionRVContentProvider.processDepth(child, current);
                return current;
            }
        }
        return parent.insertByOrder(child, false);
    }

    private static void processDepth(InspectionTreeNode child, InspectionTreeNode current) {
        InspectionTreeNode[] children2 = new InspectionTreeNode[child.getChildCount()];
        for (int i = 0; i < children2.length; ++i) {
            children2[i] = (InspectionTreeNode)child.getChildAt(i);
        }
        for (InspectionTreeNode node : children2) {
            InspectionRVContentProvider.merge(node, current, true);
        }
    }

    protected static interface UserObjectContainer<T> {
        @Nullable
        public UserObjectContainer<T> getOwner();

        @NotNull
        public RefElementNode createNode(@NotNull InspectionToolPresentation var1);

        @NotNull
        public T getUserObject();

        @Nullable
        public String getModule();

        public boolean areEqual(T var1, T var2);

        public boolean supportStructure();
    }
}

