/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.impl.UsagePreviewPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ProblemPreviewEditorPresentation {
    private static final int VIEW_ADDITIONAL_OFFSET = 4;
    private static final Logger LOG = Logger.getInstance(ProblemPreviewEditorPresentation.class);
    private final EditorEx myEditor;
    private final InspectionResultsView myView;
    private final SortedSet<PreviewEditorFoldingRegion> myFoldedRegions = new TreeSet<PreviewEditorFoldingRegion>(new Comparator<PreviewEditorFoldingRegion>(){

        @Override
        public int compare(PreviewEditorFoldingRegion r1, PreviewEditorFoldingRegion r2) {
            if (r1 == r2) {
                return 0;
            }
            int diff = r1.startLine - r2.startLine;
            LOG.assertTrue(diff != 0);
            return diff;
        }
    });
    private final DocumentEx myDocument;

    public ProblemPreviewEditorPresentation(EditorEx editor, InspectionResultsView view) {
        this.myEditor = editor;
        this.myView = view;
        this.myDocument = editor.getDocument();
        this.myFoldedRegions.add(new PreviewEditorFoldingRegion(0, this.myDocument.getLineCount()));
        this.appendFoldings(view.getTree().getAllValidSelectedDescriptors());
    }

    private static boolean inRegion(int position, PreviewEditorFoldingRegion range) {
        return range.startLine <= position && range.endLine > position;
    }

    private void appendFoldings(CommonProblemDescriptor[] descriptors) {
        boolean[] isUpdated = new boolean[]{false};
        boolean[] allValid = new boolean[]{true};
        List elements = Arrays.stream(descriptors).filter(ProblemDescriptorBase.class::isInstance).map(ProblemDescriptorBase.class::cast).map(ProblemDescriptorBase::getPsiElement).filter(e -> {
            boolean isValid = e != null && e.isValid();
            allValid[0] = allValid[0] & isValid;
            return isValid;
        }).peek(e -> {
            isUpdated[0] = isUpdated[0] | this.appendFoldings(e.getTextRange());
        }).map(UsageInfo::new).collect(Collectors.toList());
        if (!allValid[0]) {
            return;
        }
        if (isUpdated[0] && descriptors.length > 1) {
            this.updateFoldings();
        }
        PsiDocumentManager.getInstance((Project)this.myView.getProject()).performLaterWhenAllCommitted(() -> {
            if (!this.myEditor.isDisposed()) {
                PsiElement element;
                this.myView.invalidate();
                this.myView.validate();
                UsagePreviewPanel.highlight((List)elements, (Editor)this.myEditor, (Project)this.myView.getProject(), (boolean)false, (int)6000);
                if (elements.size() == 1 && (element = ((UsageInfo)elements.get(0)).getElement()) != null) {
                    DocumentEx document2 = this.myEditor.getDocument();
                    int offset = Math.min(element.getTextRange().getEndOffset() + 4, document2.getLineEndOffset(document2.getLineNumber(element.getTextRange().getEndOffset())));
                    this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(offset), ScrollType.CENTER);
                    return;
                }
                this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(0), ScrollType.CENTER_UP);
            }
        });
    }

    private void updateFoldings() {
        this.myEditor.getFoldingModel().runBatchFoldingOperation(() -> {
            this.myEditor.getFoldingModel().clearFoldRegions();
            this.myEditor.getMarkupModel().removeAllHighlighters();
            for (PreviewEditorFoldingRegion region : this.myFoldedRegions) {
                FoldRegion currentRegion;
                if (region.endLine - region.startLine <= 1 || (currentRegion = FoldingModelSupport.addFolding(this.myEditor, region.startLine, region.endLine, false)) == null) continue;
                DiffDrawUtil.createLineSeparatorHighlighter(this.myEditor, this.myDocument.getLineStartOffset(region.startLine), this.myDocument.getLineEndOffset(region.endLine - 1), () -> currentRegion.isValid() && !currentRegion.isExpanded());
            }
        });
    }

    private boolean appendFoldings(TextRange toShowRange) {
        boolean isUpdated = false;
        int startLine = Math.max(0, this.myDocument.getLineNumber(toShowRange.getStartOffset()) - 1);
        int endLine = Math.min(this.myDocument.getLineCount(), this.myDocument.getLineNumber(toShowRange.getEndOffset()) + 2);
        for (PreviewEditorFoldingRegion range : new ArrayList<PreviewEditorFoldingRegion>(this.myFoldedRegions)) {
            boolean startInRegion = ProblemPreviewEditorPresentation.inRegion(startLine, range);
            boolean endInRegion = ProblemPreviewEditorPresentation.inRegion(endLine, range);
            if (startInRegion && endInRegion) {
                this.myFoldedRegions.remove(range);
                if (range.startLine != startLine) {
                    this.myFoldedRegions.add(new PreviewEditorFoldingRegion(range.startLine, startLine));
                }
                if (endLine != range.endLine) {
                    this.myFoldedRegions.add(new PreviewEditorFoldingRegion(endLine, range.endLine));
                }
                return true;
            }
            if (startInRegion) {
                this.myFoldedRegions.remove(range);
                if (range.startLine != startLine) {
                    this.myFoldedRegions.add(new PreviewEditorFoldingRegion(range.startLine, startLine));
                }
                isUpdated = true;
            }
            if (!endInRegion) continue;
            this.myFoldedRegions.remove(range);
            if (endLine != range.endLine) {
                this.myFoldedRegions.add(new PreviewEditorFoldingRegion(endLine, range.endLine));
            }
            return true;
        }
        return isUpdated;
    }

    private static class PreviewEditorFoldingRegion {
        public final int startLine;
        public final int endLine;

        private PreviewEditorFoldingRegion(int startLine, int endLine) {
            this.startLine = startLine;
            this.endLine = endLine;
        }
    }
}

