/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.CachedInspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.RefElementAndDescriptorAware;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuppressableInspectionTreeNode
extends CachedInspectionTreeNode
implements RefElementAndDescriptorAware {
    private static final Logger LOG = Logger.getInstance(SuppressableInspectionTreeNode.class);
    @NotNull
    private final InspectionResultsView myView;
    private volatile Set<SuppressIntentionAction> myAvailableSuppressActions;
    protected final InspectionToolPresentation myPresentation;

    protected SuppressableInspectionTreeNode(Object userObject, @NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "<init>"));
        }
        super(userObject);
        this.myView = presentation.getContext().getView();
        this.myPresentation = presentation;
    }

    @Override
    @NotNull
    public InspectionToolPresentation getPresentation() {
        InspectionToolPresentation inspectionToolPresentation = this.myPresentation;
        if (inspectionToolPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getPresentation"));
        }
        return inspectionToolPresentation;
    }

    public boolean canSuppress() {
        return this.isLeaf();
    }

    public final boolean isAlreadySuppressedFromView() {
        Object usrObj = this.getUserObject();
        return usrObj != null && this.myView.getSuppressedNodes(this.myPresentation.getToolWrapper().getShortName()).contains(usrObj);
    }

    @Override
    @Nullable
    public String getCustomizedTailText() {
        String text = super.getCustomizedTailText();
        if (text != null) {
            return text;
        }
        return this.isAlreadySuppressedFromView() ? "Suppressed" : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<SuppressIntentionAction> getAvailableSuppressActions() {
        Set<SuppressIntentionAction> actions = this.myAvailableSuppressActions;
        if (actions == null) {
            SuppressableInspectionTreeNode suppressableInspectionTreeNode = this;
            synchronized (suppressableInspectionTreeNode) {
                actions = this.myAvailableSuppressActions;
                if (actions == null) {
                    RefEntity element = this.getElement();
                    actions = element == null ? this.getSuppressActions() : this.getOnlyAvailableSuppressActions(element.getRefManager().getProject());
                    this.myAvailableSuppressActions = actions;
                }
            }
        }
        Set<SuppressIntentionAction> set = actions;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getAvailableSuppressActions"));
        }
        return set;
    }

    @Override
    protected void init(Project project2) {
        super.init(project2);
        this.myAvailableSuppressActions = this.getOnlyAvailableSuppressActions(project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropCache(Project project2) {
        super.dropCache(project2);
        if (this.isValid()) {
            SuppressableInspectionTreeNode suppressableInspectionTreeNode = this;
            synchronized (suppressableInspectionTreeNode) {
                this.myAvailableSuppressActions = this.getOnlyAvailableSuppressActions(project2);
            }
        }
    }

    @NotNull
    public final Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        CommonProblemDescriptor descriptor = this.getDescriptor();
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : (refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null);
        Pair pair = Pair.create((Object)element, (Object)descriptor);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getSuppressContent"));
        }
        return pair;
    }

    @NotNull
    private Set<SuppressIntentionAction> getOnlyAvailableSuppressActions(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getOnlyAvailableSuppressActions"));
        }
        Set<SuppressIntentionAction> actions = this.getSuppressActions();
        if (actions.isEmpty()) {
            Set<SuppressIntentionAction> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getOnlyAvailableSuppressActions"));
            }
            return set;
        }
        Pair<PsiElement, CommonProblemDescriptor> suppress = this.getSuppressContent();
        PsiElement suppressElement = (PsiElement)suppress.getFirst();
        if (suppressElement == null) {
            Set<SuppressIntentionAction> set = actions;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getOnlyAvailableSuppressActions"));
            }
            return set;
        }
        Set availableActions = null;
        for (SuppressIntentionAction action : actions) {
            if (!action.isAvailable(project2, null, suppressElement)) continue;
            if (availableActions == null) {
                availableActions = new THashSet(actions.size());
            }
            availableActions.add(action);
        }
        Set<Object> set = availableActions == null ? Collections.emptySet() : availableActions;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getOnlyAvailableSuppressActions"));
        }
        return set;
    }

    @NotNull
    private Set<SuppressIntentionAction> getSuppressActions() {
        Set<SuppressIntentionAction> set = this.myView.getSuppressActions(this.myPresentation.getToolWrapper());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getSuppressActions"));
        }
        return set;
    }
}

