/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.javac;

import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfigurable;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavacCompiler
implements BackendCompiler {
    private final Project myProject;

    public JavacCompiler(Project project2) {
        this.myProject = project2;
    }

    @Override
    @NotNull
    @NonNls
    public String getId() {
        if ("Javac" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler", "getId"));
        }
        return "Javac";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        JavacConfigurable javacConfigurable = new JavacConfigurable(JavacConfiguration.getOptions(this.myProject, JavacConfiguration.class));
        if (javacConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler", "createConfigurable"));
        }
        return javacConfigurable;
    }

    @Override
    @NotNull
    public Set<FileType> getCompilableFileTypes() {
        Set<LanguageFileType> set = Collections.singleton(StdFileTypes.JAVA);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler", "getCompilableFileTypes"));
        }
        return set;
    }
}

