/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDebugUIEnvironment
implements DebugUIEnvironment {
    private final ExecutionEnvironment myExecutionEnvironment;
    private final DebugEnvironment myModelEnvironment;

    public DefaultDebugUIEnvironment(@NotNull ExecutionEnvironment environment, RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/debugger/DefaultDebugUIEnvironment", "<init>"));
        }
        this.myExecutionEnvironment = environment;
        this.myModelEnvironment = new DefaultDebugEnvironment(environment, state, remoteConnection, pollConnection);
    }

    @Override
    public DebugEnvironment getEnvironment() {
        return this.myModelEnvironment;
    }

    @Override
    @Nullable
    public RunContentDescriptor getReuseContent() {
        return this.myExecutionEnvironment.getContentToReuse();
    }

    @Override
    public Icon getIcon() {
        return this.getRunProfile().getIcon();
    }

    @Override
    public void initActions(RunContentDescriptor content, DefaultActionGroup actionGroup) {
        Executor executor = this.myExecutionEnvironment.getExecutor();
        actionGroup.add(ActionManager.getInstance().getAction("Rerun"), Constraints.FIRST);
        actionGroup.add((AnAction)new CloseAction(executor, content, this.myExecutionEnvironment.getProject()));
        actionGroup.add((AnAction)new ContextHelpAction(executor.getHelpId()));
    }

    @Override
    @NotNull
    public RunProfile getRunProfile() {
        RunProfile runProfile = this.myExecutionEnvironment.getRunProfile();
        if (runProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/DefaultDebugUIEnvironment", "getRunProfile"));
        }
        return runProfile;
    }
}

