/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugUIEnvironment;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerPanelsManager
implements ProjectComponent {
    private final Project myProject;

    public DebuggerPanelsManager(Project project2) {
        this.myProject = project2;
    }

    private DebuggerStateManager getContextManager() {
        return DebuggerManagerEx.getInstanceEx(this.myProject).getContextManager();
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(@NotNull ExecutionEnvironment environment, RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/debugger/ui/DebuggerPanelsManager", "attachVirtualMachine"));
        }
        return this.attachVirtualMachine(new DefaultDebugUIEnvironment(environment, state, remoteConnection, pollConnection));
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(DebugUIEnvironment environment) throws ExecutionException {
        DebugEnvironment modelEnvironment = environment.getEnvironment();
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(this.myProject).attachVirtualMachine(modelEnvironment);
        if (debuggerSession == null) {
            return null;
        }
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(modelEnvironment.getSessionName(), environment.getReuseContent(), new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session2) {
                if (session2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/ui/DebuggerPanelsManager$1", "start"));
                }
                JavaDebugProcess javaDebugProcess = JavaDebugProcess.create(session2, debuggerSession);
                if (javaDebugProcess == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/DebuggerPanelsManager$1", "start"));
                }
                return javaDebugProcess;
            }
        });
        return debugSession.getRunContentDescriptor();
    }

    public void projectOpened() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/debugger/ui/DebuggerPanelsManager$2", "contentSelected"));
                }
                if (executor == DefaultDebugExecutor.getDebugExecutorInstance()) {
                    DebuggerSession session2;
                    DebuggerSession debuggerSession = session2 = descriptor == null ? null : DebuggerPanelsManager.getSession(DebuggerPanelsManager.this.myProject, descriptor);
                    if (session2 != null) {
                        DebuggerPanelsManager.this.getContextManager().setState(session2.getContextManager().getContext(), session2.getState(), DebuggerSession.Event.CONTEXT, null);
                    } else {
                        DebuggerPanelsManager.this.getContextManager().setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.CONTEXT, null);
                    }
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/debugger/ui/DebuggerPanelsManager$2", "contentRemoved"));
                }
            }
        });
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("DebuggerPanelsManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/DebuggerPanelsManager", "getComponentName"));
        }
        return "DebuggerPanelsManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public static DebuggerPanelsManager getInstance(Project project2) {
        return (DebuggerPanelsManager)project2.getComponent(DebuggerPanelsManager.class);
    }

    private static DebuggerSession getSession(Project project2, RunContentDescriptor descriptor) {
        for (JavaDebugProcess process2 : XDebuggerManager.getInstance((Project)project2).getDebugProcesses(JavaDebugProcess.class)) {
            if (!Comparing.equal((Object)process2.getProcessHandler(), (Object)descriptor.getProcessHandler())) continue;
            return process2.getDebuggerSession();
        }
        return null;
    }
}

