/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import org.jetbrains.annotations.NotNull;

public class MergeConflictType {
    @NotNull
    private final TextDiffType myType;
    private final boolean myLeftChange;
    private final boolean myRightChange;

    public MergeConflictType(@NotNull TextDiffType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/MergeConflictType", "<init>"));
        }
        this(type, true, true);
    }

    public MergeConflictType(@NotNull TextDiffType type, boolean leftChange, boolean rightChange) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/MergeConflictType", "<init>"));
        }
        this.myType = type;
        this.myLeftChange = leftChange;
        this.myRightChange = rightChange;
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = this.myType;
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/MergeConflictType", "getDiffType"));
        }
        return textDiffType;
    }

    public boolean isChange(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/util/MergeConflictType", "isChange"));
        }
        return side.isLeft() ? this.myLeftChange : this.myRightChange;
    }

    public boolean isChange(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/util/MergeConflictType", "isChange"));
        }
        switch (side) {
            case LEFT: {
                return this.myLeftChange;
            }
            case BASE: {
                return true;
            }
            case RIGHT: {
                return this.myRightChange;
            }
        }
        throw new IllegalArgumentException(side.toString());
    }
}

