/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class OutputLineSplitter {
    private static final String TEAMCITY_SERVICE_MESSAGE_PREFIX = "##teamcity[";
    private final boolean myStdinSupportEnabled;
    private final Map<Key, StringBuilder> myBuffers = new THashMap();
    private final List<OutputChunk> myStdOutChunks = new ArrayList<OutputChunk>();

    public OutputLineSplitter(boolean stdinEnabled) {
        this.myBuffers.put(ProcessOutputTypes.SYSTEM, new StringBuilder());
        this.myBuffers.put(ProcessOutputTypes.STDERR, new StringBuilder());
        this.myStdinSupportEnabled = stdinEnabled;
    }

    public void process(String text, Key outputType) {
        int from = 0;
        for (int to = 0; to < text.length(); ++to) {
            if (text.charAt(to) != '\n') continue;
            this.processLine(text.substring(from, to + 1), outputType);
            from = to + 1;
        }
        if (from < text.length()) {
            this.processLine(text.substring(from), outputType);
        }
    }

    private void processLine(String text, Key outputType) {
        if (!this.myBuffers.keySet().contains(outputType)) {
            this.processStdOutConsistently(text, outputType);
        } else {
            StringBuilder buffer = this.myBuffers.get(outputType);
            if (!text.endsWith("\n")) {
                buffer.append(text);
                return;
            }
            if (buffer.length() > 0) {
                buffer.append(text);
                text = buffer.toString();
                buffer.setLength(0);
            }
            this.onLineAvailable(text, outputType, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStdOutConsistently(String text, Key outputType) {
        int textLength = text.length();
        if (textLength == 0) {
            return;
        }
        List<OutputChunk> list = this.myStdOutChunks;
        synchronized (list) {
            this.myStdOutChunks.add(new OutputChunk(outputType, text));
        }
        char lastChar = text.charAt(textLength - 1);
        if (lastChar == '\n' || lastChar == '\r') {
            this.flushStdOutBuffer();
        } else if (this.myStdinSupportEnabled && !this.isMostLikelyServiceMessagePart(text)) {
            this.flushStdOutBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushStdOutBuffer() {
        ArrayList<OutputChunk> chunks = new ArrayList<OutputChunk>();
        OutputChunk lastChunk = null;
        List<OutputChunk> list = this.myStdOutChunks;
        synchronized (list) {
            for (OutputChunk chunk : this.myStdOutChunks) {
                if (lastChunk != null && chunk.getKey() == lastChunk.getKey()) {
                    lastChunk.append(chunk.getText());
                    continue;
                }
                lastChunk = chunk;
                chunks.add(chunk);
            }
            this.myStdOutChunks.clear();
        }
        boolean isTCLikeFakeOutput = chunks.size() == 1;
        for (OutputChunk chunk : chunks) {
            this.onLineAvailable(chunk.getText(), chunk.getKey(), isTCLikeFakeOutput);
        }
    }

    public void flush() {
        this.flushStdOutBuffer();
        for (Map.Entry<Key, StringBuilder> each : this.myBuffers.entrySet()) {
            StringBuilder buffer = each.getValue();
            if (buffer.length() <= 0) continue;
            this.onLineAvailable(buffer.toString(), each.getKey(), false);
            buffer.setLength(0);
        }
    }

    protected boolean isMostLikelyServiceMessagePart(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/sm/runner/OutputLineSplitter", "isMostLikelyServiceMessagePart"));
        }
        return text.startsWith(TEAMCITY_SERVICE_MESSAGE_PREFIX);
    }

    protected abstract void onLineAvailable(@NotNull String var1, @NotNull Key var2, boolean var3);

    private static class OutputChunk {
        private final Key myKey;
        private String myText;

        private OutputChunk(Key key2, String text) {
            this.myKey = key2;
            this.myText = text;
        }

        public Key getKey() {
            return this.myKey;
        }

        public String getText() {
            return this.myText;
        }

        public void append(String text) {
            this.myText = this.myText + text;
        }
    }
}

