/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.AddOccurrenceAction;
import com.intellij.find.editorHeaderActions.FindAllAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.RemoveOccurrenceAction;
import com.intellij.find.editorHeaderActions.RestorePreviousSettingsAction;
import com.intellij.find.editorHeaderActions.SelectAllAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.SwitchToFind;
import com.intellij.find.editorHeaderActions.SwitchToReplace;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAndLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleInCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleInLiteralsOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.TogglePreserveCaseAction;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleSelectionOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.find.impl.livePreview.LivePreviewController;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.DefaultCustomComponentAction;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorSearchSession
implements SearchSession,
DataProvider,
SelectionListener,
SearchResults.SearchResultsListener,
SearchReplaceComponent.Listener {
    public static DataKey<EditorSearchSession> SESSION_KEY = DataKey.create((String)"EditorSearchSession");
    private final Editor myEditor;
    private final LivePreviewController myLivePreviewController;
    private final SearchResults mySearchResults;
    private final FindModel myFindModel;
    private final SearchReplaceComponent myComponent;
    private final LinkLabel<Object> myClickToHighlightLabel;

    public EditorSearchSession(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/EditorSearchSession", "<init>"));
        }
        this(editor, project2, EditorSearchSession.createDefaultFindModel(project2, editor));
    }

    public EditorSearchSession(@NotNull Editor editor, Project project2, FindModel findModel) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/EditorSearchSession", "<init>"));
        }
        this.myClickToHighlightLabel = new LinkLabel("Click to highlight", null, (LinkListener)new LinkListener<Object>(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                EditorSearchSession.this.setMatchesLimit(Integer.MAX_VALUE);
                EditorSearchSession.this.updateResults(true);
            }
        });
        this.myClickToHighlightLabel.setVisible(false);
        this.myFindModel = findModel;
        this.myEditor = editor;
        this.mySearchResults = new SearchResults(this.myEditor, project2);
        this.myLivePreviewController = new LivePreviewController(this.mySearchResults, this);
        this.myComponent = SearchReplaceComponent.buildFor(project2, this.myEditor.getContentComponent()).addPrimarySearchActions(new AnAction[]{new PrevOccurrenceAction(), new NextOccurrenceAction(), new FindAllAction(), new Separator(), new AddOccurrenceAction(), new RemoveOccurrenceAction(), new SelectAllAction(), new Separator()}).addSecondarySearchActions(new AnAction[]{new ToggleInCommentsAction(), new ToggleInLiteralsOnlyAction(), new ToggleExceptCommentsAction(), new ToggleExceptLiteralsAction(), new ToggleExceptCommentsAndLiteralsAction()}).addExtraSearchActions(new AnAction[]{new ToggleMatchCase(), new ToggleRegex(), new ToggleWholeWordsOnlyAction(), new StatusTextAction(), new DefaultCustomComponentAction(this.myClickToHighlightLabel)}).addSearchFieldActions(new RestorePreviousSettingsAction()).addPrimaryReplaceActions(new AnAction[]{new ReplaceAction(), new ReplaceAllAction(), new ExcludeAction()}).addExtraReplaceAction(new AnAction[]{new TogglePreserveCaseAction(), new ToggleSelectionOnlyAction()}).addReplaceFieldActions(new AnAction[]{new PrevOccurrenceAction(false), new NextOccurrenceAction(false)}).withDataProvider(this).withCloseAction(() -> this.close()).withReplaceAction(() -> this.replaceCurrent()).withSecondarySearchActionsIsModifiedGetter(() -> this.myFindModel.getSearchContext() != FindModel.SearchContext.ANY).build();
        this.myComponent.addListener(this);
        new UiNotifyConnector((Component)this.myComponent, new Activatable(){

            public void showNotify() {
                EditorSearchSession.this.initLivePreview();
            }

            public void hideNotify() {
                EditorSearchSession.this.myLivePreviewController.off();
                EditorSearchSession.this.mySearchResults.removeListener(EditorSearchSession.this);
            }
        });
        new SwitchToFind(this.getComponent());
        new SwitchToReplace(this.getComponent());
        this.myFindModel.addObserver(new FindModel.FindModelObserver(){

            public void findModelChanged(FindModel findModel) {
                String stringToFind = EditorSearchSession.this.myFindModel.getStringToFind();
                if (!EditorSearchSession.wholeWordsApplicable(stringToFind)) {
                    EditorSearchSession.this.myFindModel.setWholeWordsOnly(false);
                }
                EditorSearchSession.this.updateUIWithFindModel();
                EditorSearchSession.this.mySearchResults.clear();
                EditorSearchSession.this.updateResults(true);
                FindUtil.updateFindInFileModel(EditorSearchSession.this.getProject(), EditorSearchSession.this.myFindModel);
            }
        });
        this.updateUIWithFindModel();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.initLivePreview();
        }
        this.updateMultiLineStateIfNeed();
    }

    @Nullable
    public static EditorSearchSession get(@Nullable Editor editor) {
        JComponent headerComponent = editor != null ? editor.getHeaderComponent() : null;
        SearchReplaceComponent searchReplaceComponent = (SearchReplaceComponent)ObjectUtils.tryCast((Object)headerComponent, SearchReplaceComponent.class);
        return searchReplaceComponent != null ? (EditorSearchSession)SESSION_KEY.getData((DataProvider)searchReplaceComponent) : null;
    }

    @NotNull
    public static EditorSearchSession start(@NotNull Editor editor, @Nullable Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/EditorSearchSession", "start"));
        }
        EditorSearchSession session2 = new EditorSearchSession(editor, project2);
        editor.setHeaderComponent((JComponent)session2.getComponent());
        EditorSearchSession editorSearchSession = session2;
        if (editorSearchSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/EditorSearchSession", "start"));
        }
        return editorSearchSession;
    }

    @NotNull
    public static EditorSearchSession start(@NotNull Editor editor, @NotNull FindModel findModel, @Nullable Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/EditorSearchSession", "start"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/EditorSearchSession", "start"));
        }
        EditorSearchSession session2 = new EditorSearchSession(editor, project2, findModel);
        editor.setHeaderComponent((JComponent)session2.getComponent());
        EditorSearchSession editorSearchSession = session2;
        if (editorSearchSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/EditorSearchSession", "start"));
        }
        return editorSearchSession;
    }

    @Override
    @NotNull
    public SearchReplaceComponent getComponent() {
        SearchReplaceComponent searchReplaceComponent = this.myComponent;
        if (searchReplaceComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/EditorSearchSession", "getComponent"));
        }
        return searchReplaceComponent;
    }

    public Project getProject() {
        return this.myComponent.getProject();
    }

    private static FindModel createDefaultFindModel(Project project2, Editor editor) {
        String selectedText;
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)project2).getFindInFileModel());
        if (editor.getSelectionModel().hasSelection() && (selectedText = editor.getSelectionModel().getSelectedText()) != null) {
            findModel.setStringToFind(selectedText);
        }
        findModel.setPromptOnReplace(false);
        return findModel;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (SearchSession.KEY.is(dataId)) {
            return this;
        }
        if (SESSION_KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    @Override
    public void searchResultsUpdated(SearchResults sr) {
        if (sr.getFindModel() == null) {
            return;
        }
        if (this.myComponent.getSearchTextComponent().getText().isEmpty()) {
            this.updateUIWithEmptyResults();
        } else {
            int matches = sr.getMatchesCount();
            boolean tooManyMatches = matches > this.mySearchResults.getMatchesLimit();
            this.myComponent.setStatusText(tooManyMatches ? ApplicationBundle.message((String)"editorsearch.toomuch", (Object[])new Object[]{this.mySearchResults.getMatchesLimit()}) : ApplicationBundle.message((String)"editorsearch.matches", (Object[])new Object[]{matches}));
            this.myClickToHighlightLabel.setVisible(tooManyMatches);
            if (!tooManyMatches && matches <= 0) {
                this.myComponent.setNotFoundBackground();
            } else {
                this.myComponent.setRegularBackground();
            }
        }
        this.myComponent.updateActions();
    }

    @Override
    public void cursorMoved() {
        this.myComponent.updateActions();
    }

    @Override
    public void updateFinished() {
    }

    @Override
    public void searchFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        String text = this.myComponent.getSearchTextComponent().getText();
        this.myFindModel.setStringToFind(text);
        if (!StringUtil.isEmpty((String)text)) {
            this.updateResults(true);
        } else {
            this.nothingToSearchFor();
        }
        this.updateMultiLineStateIfNeed();
    }

    private void updateMultiLineStateIfNeed() {
        this.myFindModel.setMultiline(this.myComponent.getSearchTextComponent().getText().contains("\n") || this.myComponent.getReplaceTextComponent().getText().contains("\n"));
    }

    @Override
    public void replaceFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        this.myFindModel.setStringToReplace(this.myComponent.getReplaceTextComponent().getText());
        this.updateMultiLineStateIfNeed();
    }

    @Override
    public void multilineStateChanged() {
        this.myFindModel.setMultiline(this.myComponent.isMultiline());
    }

    @Override
    @NotNull
    public FindModel getFindModel() {
        FindModel findModel = this.myFindModel;
        if (findModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/EditorSearchSession", "getFindModel"));
        }
        return findModel;
    }

    @Override
    public boolean hasMatches() {
        return this.mySearchResults != null && this.mySearchResults.hasMatches();
    }

    @Override
    public void searchForward() {
        this.moveCursor(SearchResults.Direction.DOWN);
        this.addTextToRecent(this.myComponent.getSearchTextComponent());
    }

    @Override
    public void searchBackward() {
        this.moveCursor(SearchResults.Direction.UP);
        this.addTextToRecent(this.myComponent.getSearchTextComponent());
    }

    public void updateUIWithFindModel() {
        this.myComponent.update(this.myFindModel.getStringToFind(), this.myFindModel.getStringToReplace(), this.myFindModel.isReplaceState(), this.myFindModel.isMultiline());
        this.myLivePreviewController.setTrackingSelection(!this.myFindModel.isGlobal());
    }

    private static boolean wholeWordsApplicable(String stringToFind) {
        return !stringToFind.startsWith(" ") && !stringToFind.startsWith("\t") && !stringToFind.endsWith(" ") && !stringToFind.endsWith("\t");
    }

    private void setMatchesLimit(int value) {
        this.mySearchResults.setMatchesLimit(value);
    }

    public void replaceCurrent() {
        if (this.mySearchResults.getCursor() != null) {
            this.myLivePreviewController.performReplace();
        }
    }

    public void addTextToRecent(JTextComponent textField) {
        this.myComponent.addTextToRecent(textField);
    }

    public void selectionChanged(SelectionEvent e) {
        this.updateResults(false);
    }

    private void moveCursor(SearchResults.Direction direction) {
        this.myLivePreviewController.moveCursor(direction);
    }

    @Override
    public void close() {
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.myEditor.getContentComponent(), false);
        this.myLivePreviewController.dispose();
        this.myEditor.setHeaderComponent(null);
    }

    private void initLivePreview() {
        this.myLivePreviewController.on();
        this.myLivePreviewController.setUserActivityDelay(0);
        this.updateResults(false);
        this.myLivePreviewController.setUserActivityDelay(30);
        this.mySearchResults.addListener(this);
    }

    private void updateResults(boolean allowedToChangedEditorSelection) {
        String text = this.myFindModel.getStringToFind();
        if (text.length() == 0) {
            this.nothingToSearchFor();
        } else {
            if (this.myFindModel.isRegularExpressions()) {
                try {
                    Pattern.compile(text);
                }
                catch (Exception e) {
                    this.myComponent.setNotFoundBackground();
                    this.myClickToHighlightLabel.setVisible(false);
                    this.mySearchResults.clear();
                    this.myComponent.setStatusText("Incorrect regular expression");
                    return;
                }
            }
            FindManager findManager = FindManager.getInstance((Project)this.getProject());
            if (allowedToChangedEditorSelection) {
                findManager.setFindWasPerformed();
                FindModel copy = new FindModel();
                copy.copyFrom(this.myFindModel);
                copy.setReplaceState(false);
                findManager.setFindNextModel(copy);
            }
            if (this.myLivePreviewController != null) {
                this.myLivePreviewController.updateInBackground(this.myFindModel, allowedToChangedEditorSelection);
            }
        }
    }

    private void nothingToSearchFor() {
        this.updateUIWithEmptyResults();
        if (this.mySearchResults != null) {
            this.mySearchResults.clear();
        }
    }

    private void updateUIWithEmptyResults() {
        this.myComponent.setRegularBackground();
        this.myComponent.setStatusText("");
        this.myClickToHighlightLabel.setVisible(false);
    }

    public String getTextInField() {
        return this.myComponent.getSearchTextComponent().getText();
    }

    public void setTextInField(String text) {
        this.myComponent.getSearchTextComponent().setText(text);
        this.myFindModel.setStringToFind(text);
    }

    public void selectAllOccurrences() {
        FindUtil.selectSearchResultsInEditor(this.myEditor, this.mySearchResults.getOccurrences().iterator(), -1);
    }

    public void removeOccurrence() {
        this.mySearchResults.prevOccurrence(true);
    }

    public void addNextOccurrence() {
        this.mySearchResults.nextOccurrence(true);
    }

    public void clearUndoInTextFields() {
        this.myComponent.resetUndoRedoActions();
    }

    private class ExcludeAction
    extends ButtonAction {
        public ExcludeAction() {
            super("", 'l');
        }

        @Override
        protected void update(@NotNull JButton button) {
            if (button == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ExcludeAction", "update"));
            }
            FindResult cursor = EditorSearchSession.this.mySearchResults.getCursor();
            button.setEnabled(cursor != null);
            button.setText(cursor != null && EditorSearchSession.this.mySearchResults.isExcluded(cursor) ? "Include" : "Exclude");
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.myLivePreviewController.exclude();
            EditorSearchSession.this.moveCursor(SearchResults.Direction.DOWN);
        }
    }

    private class ReplaceAllAction
    extends ButtonAction {
        public ReplaceAllAction() {
            super("Replace all", 'a');
        }

        @Override
        protected void update(@NotNull JButton button) {
            if (button == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ReplaceAllAction", "update"));
            }
            button.setEnabled(EditorSearchSession.this.mySearchResults.hasMatches());
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.myLivePreviewController.performReplaceAll();
        }
    }

    private class ReplaceAction
    extends ButtonAction {
        public ReplaceAction() {
            super("Replace", 'p');
        }

        @Override
        protected void update(@NotNull JButton button) {
            if (button == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ReplaceAction", "update"));
            }
            button.setEnabled(EditorSearchSession.this.mySearchResults.hasMatches());
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.replaceCurrent();
        }
    }

    private static abstract class ButtonAction
    extends DumbAwareAction
    implements CustomComponentAction,
    ActionListener {
        private final String myTitle;
        private final char myMnemonic;

        protected ButtonAction(@NotNull String title, char mnemonic) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/find/EditorSearchSession$ButtonAction", "<init>"));
            }
            this.myTitle = title;
            this.myMnemonic = mnemonic;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            JButton button = new JButton(this.myTitle);
            button.setFocusable(false);
            if (!UISettings.getInstance().DISABLE_MNEMONICS_IN_CONTROLS) {
                button.setMnemonic(this.myMnemonic);
            }
            button.addActionListener(this);
            return button;
        }

        public final void update(AnActionEvent e) {
            JButton button = (JButton)e.getPresentation().getClientProperty("customComponent");
            if (button != null) {
                this.update(button);
            }
        }

        public final void actionPerformed(AnActionEvent e) {
            this.onClick();
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.onClick();
        }

        protected abstract void update(@NotNull JButton var1);

        protected abstract void onClick();
    }
}

