/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FindUsagesAction
extends AnAction {
    public FindUsagesAction() {
        this.setInjectedContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        UsageTarget[] usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY);
        if (usageTargets == null) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project2, editor, (PsiElementProcessor<PsiElement>)((PsiElementProcessor)element -> {
                this.startFindUsages(element);
                return false;
            }));
        } else {
            UsageTarget target = usageTargets[0];
            if (target instanceof PsiElementUsageTarget) {
                PsiElement element2 = ((PsiElementUsageTarget)target).getElement();
                if (element2 != null) {
                    this.startFindUsages(element2);
                }
            } else {
                target.findUsages();
            }
        }
    }

    protected void startFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/actions/FindUsagesAction", "startFindUsages"));
        }
        FindManager.getInstance((Project)element.getProject()).findUsages(element);
    }

    public void update(AnActionEvent event) {
        FindUsagesInFileAction.updateFindUsagesAction(event);
    }

    static void chooseAmbiguousTargetAndPerform(@NotNull Project project2, Editor editor, @NotNull PsiElementProcessor<PsiElement> processor2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/actions/FindUsagesAction", "chooseAmbiguousTargetAndPerform"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/actions/FindUsagesAction", "chooseAmbiguousTargetAndPerform"));
        }
        if (editor == null) {
            Messages.showMessageDialog((Project)project2, (String)FindBundle.message("find.no.usages.at.cursor.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        } else {
            int offset = editor.getCaretModel().getOffset();
            boolean chosen = GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, processor2, FindBundle.message("find.usages.ambiguous.title", new Object[0]), null);
            if (!chosen) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (editor.isDisposed() || !editor.getComponent().isShowing()) {
                        return;
                    }
                    HintManager.getInstance().showErrorHint(editor, FindBundle.message("find.no.usages.at.cursor.error", new Object[0]));
                }, project2.getDisposed());
            }
        }
    }

    public static class ShowSettingsAndFindUsages
    extends FindUsagesAction {
        @Override
        protected void startFindUsages(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/actions/FindUsagesAction$ShowSettingsAndFindUsages", "startFindUsages"));
            }
            FindManager.getInstance((Project)element.getProject()).findUsages(element, true);
        }
    }
}

