/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH$J\b\u0010\t\u001a\u00020\nH$J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/actions/EditCustomSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "file", "Ljava/io/File;", "template", "", "update", "platform-impl"})
public abstract class EditCustomSettingsAction
extends DumbAwareAction {
    @Nullable
    protected abstract File file();

    @NotNull
    protected abstract String template();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        e.getPresentation().setEnabled(e.getProject() != null && this.file() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile vFile;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        File file2 = this.file();
        if (file2 == null) {
            return;
        }
        File file3 = file2;
        if (!file3.exists()) {
            int result2;
            String message = IdeBundle.message((String)"edit.custom.settings.confirm", (Object[])new Object[]{FileUtil.getLocationRelativeToUserHome((String)file3.getPath())});
            String string = e.getPresentation().getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((result2 = Messages.showYesNoDialog((Project)project3, (String)message, (String)string, (Icon)Messages.getQuestionIcon())) == 1) {
                return;
            }
            FileUtil.writeToFile((File)file3, (String)this.template());
        }
        if ((vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file3)) != null) {
            vFile.refresh(false, false);
            new OpenFileDescriptor(project3, vFile, (int)vFile.getLength()).navigate(true);
        }
    }
}

