/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ChooseComponentsToExportDialog;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.ide.actions.ImportSettingsActionKt;
import com.intellij.ide.actions.ImportSettingsFilenameFilter;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathKt;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.zip.ZipException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\r0\rH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/actions/ImportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doImport", "saveFile", "Ljava/io/File;", "getRelativeNamesToExtract", "", "", "chosenComponents", "Lcom/intellij/ide/actions/ExportableItem;", "presentableFileName", "file", "promptLocationMessage", "kotlin.jvm.PlatformType", "configuration-store-impl"})
final class ImportSettingsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        ChooseComponentsToExportDialog.chooseSettingsFile(PathManager.getConfigPath(), component, IdeBundle.message((String)"title.import.file.location", (Object[])new Object[0]), IdeBundle.message((String)"prompt.choose.import.file.path", (Object[])new Object[0])).done((Consumer)new Consumer<String>(this){
            final /* synthetic */ ImportSettingsAction this$0;

            public final void consume(String it) {
                File saveFile = new File(it);
                try {
                    ImportSettingsAction.access$doImport(this.this$0, saveFile);
                }
                catch (ZipException e1) {
                    Messages.showErrorDialog((String)IdeBundle.message((String)"error.reading.settings.file", (Object[])new Object[]{ImportSettingsAction.access$presentableFileName(this.this$0, saveFile), e1.getMessage(), ImportSettingsAction.access$promptLocationMessage(this.this$0)}), (String)IdeBundle.message((String)"title.invalid.file", (Object[])new Object[0]));
                }
                catch (IOException e1) {
                    Messages.showErrorDialog((String)IdeBundle.message((String)"error.reading.settings.file.2", (Object[])new Object[]{ImportSettingsAction.access$presentableFileName(this.this$0, saveFile), e1.getMessage()}), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]));
                }
            }
            {
                this.this$0 = importSettingsAction;
            }
        });
    }

    private final void doImport(File saveFile) {
        String key2;
        if (!saveFile.exists()) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.find.file", (Object[])new Object[]{this.presentableFileName(saveFile)}), (String)IdeBundle.message((String)"title.file.not.found", (Object[])new Object[0]));
            return;
        }
        File file2 = saveFile;
        Set<String> relativePaths = ImportSettingsActionKt.getPaths(new FileInputStream(file2));
        if (!relativePaths.contains("IntelliJ IDEA Global Settings")) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.file.contains.no.settings.to.import", (Object[])new Object[]{this.presentableFileName(saveFile), this.promptLocationMessage()}), (String)IdeBundle.message((String)"title.invalid.file", (Object[])new Object[0]));
            return;
        }
        String configPath = FileUtil.toSystemIndependentName((String)PathManager.getConfigPath());
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(ExportSettingsActionKt.getExportableComponentsMap$default(false, true, null, relativePaths, 4, null), false, IdeBundle.message((String)"title.select.components.to.import", (Object[])new Object[0]), IdeBundle.message((String)"prompt.check.components.to.import", (Object[])new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        File tempFile2 = new File(PathManager.getPluginTempPath(), saveFile.getName());
        FileUtil.copy((File)saveFile, (File)tempFile2);
        Set<ExportableItem> set = dialog.getExportableComponents();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"dialog.exportableComponents");
        ImportSettingsFilenameFilter filenameFilter = new ImportSettingsFilenameFilter(this.getRelativeNamesToExtract(set));
        StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.UnzipCommand(tempFile2, new File(configPath), (FilenameFilter)filenameFilter)));
        StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.DeleteCommand(tempFile2)));
        UpdateSettings.getInstance().forceCheckForUpdateAfterRestart();
        String string = key2 = ApplicationManager.getApplication().isRestartCapable() ? "message.settings.imported.successfully.restart" : "message.settings.imported.successfully";
        if (Messages.showOkCancelDialog((String)IdeBundle.message((String)key2, (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), ApplicationNamesInfo.getInstance().getFullProductName()}), (String)IdeBundle.message((String)"title.restart.needed", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
            }
            ((ApplicationEx)application).restart(true);
        }
    }

    private final Set<String> getRelativeNamesToExtract(Set<ExportableItem> chosenComponents) {
        THashSet result2 = new THashSet();
        Path root = Paths.get(PathManager.getConfigPath(), new String[0]);
        for (ExportableItem chosenComponent : chosenComponents) {
            for (Path exportFile : chosenComponent.getFiles()) {
                result2.add((Object)PathKt.getSystemIndependentPath(root.relativize(exportFile)));
            }
        }
        result2.add((Object)"installed.txt");
        return (Set)result2;
    }

    private final String presentableFileName(File file2) {
        return "'" + FileUtil.toSystemDependentName((String)file2.getPath()) + "'";
    }

    private final String promptLocationMessage() {
        return IdeBundle.message((String)"message.please.ensure.correct.settings", (Object[])new Object[0]);
    }

    public static final /* synthetic */ void access$doImport(ImportSettingsAction $this, @NotNull File saveFile) {
        $this.doImport(saveFile);
    }

    @NotNull
    public static final /* synthetic */ String access$presentableFileName(ImportSettingsAction $this, @NotNull File file2) {
        return $this.presentableFileName(file2);
    }

    public static final /* synthetic */ String access$promptLocationMessage(ImportSettingsAction $this) {
        return $this.promptLocationMessage();
    }
}

