/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.ide.commander.TopLevelNode;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.Alarm;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListSelectionModel;

public abstract class AbstractListBuilder {
    protected final Project myProject;
    protected final JList myList;
    protected final Model myModel;
    protected final AbstractTreeStructure myTreeStructure;
    private final Comparator myComparator;
    protected JLabel myParentTitle = null;
    private boolean myIsDisposed;
    private AbstractTreeNode myCurrentParent = null;
    private final AbstractTreeNode myShownRoot;

    public AbstractListBuilder(Project project2, JList list, Model model, AbstractTreeStructure treeStructure, Comparator comparator2, boolean showRoot) {
        this.myProject = project2;
        this.myList = list;
        this.myModel = model;
        this.myTreeStructure = treeStructure;
        this.myComparator = comparator2;
        Object rootElement = this.myTreeStructure.getRootElement();
        Object[] rootChildren = this.myTreeStructure.getChildElements(rootElement);
        this.myShownRoot = !showRoot && rootChildren.length == 1 && this.shouldEnterSingleTopLevelElement(rootChildren[0]) ? (AbstractTreeNode)rootChildren[0] : (AbstractTreeNode)rootElement;
    }

    protected abstract boolean shouldEnterSingleTopLevelElement(Object var1);

    public final void setParentTitle(JLabel parentTitle) {
        this.myParentTitle = parentTitle;
    }

    public final void drillDown() {
        Object value = this.getSelectedValue();
        if (value instanceof AbstractTreeNode) {
            try {
                AbstractTreeNode node = (AbstractTreeNode)value;
                this.buildList(node);
                this.ensureSelectionExist();
            }
            finally {
                this.updateParentTitle();
            }
        } else {
            this.goUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void goUp() {
        if (this.myCurrentParent == this.myShownRoot.getParent()) {
            return;
        }
        AbstractTreeNode element = this.myCurrentParent.getParent();
        if (element == null) {
            return;
        }
        try {
            AbstractTreeNode oldParent = this.myCurrentParent;
            this.buildList(element);
            for (int i = 0; i < this.myModel.getSize(); ++i) {
                NodeDescriptor desc;
                Object elem;
                if (!(this.myModel.getElementAt(i) instanceof NodeDescriptor) || !oldParent.equals(elem = (desc = (NodeDescriptor)this.myModel.getElementAt(i)).getElement())) continue;
                this.selectItem(i);
                break;
            }
        }
        finally {
            this.updateParentTitle();
        }
    }

    protected Object getSelectedValue() {
        return this.myList.getSelectedValue();
    }

    protected void selectItem(int i) {
        ScrollingUtil.selectItem((JList)this.myList, (int)i);
    }

    protected void ensureSelectionExist() {
        ScrollingUtil.ensureSelectionExists((JList)this.myList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void selectElement(Object element, VirtualFile virtualFile) {
        if (element == null) {
            return;
        }
        try {
            AbstractTreeNode node = this.goDownToElement(element, virtualFile);
            if (node == null) {
                return;
            }
            AbstractTreeNode parentElement = node.getParent();
            if (parentElement == null) {
                return;
            }
            this.buildList(parentElement);
            for (int i = 0; i < this.myModel.getSize(); ++i) {
                if (!(this.myModel.getElementAt(i) instanceof AbstractTreeNode)) continue;
                AbstractTreeNode desc = (AbstractTreeNode)this.myModel.getElementAt(i);
                if (desc.getValue() instanceof StructureViewTreeElement) {
                    StructureViewTreeElement treeelement = (StructureViewTreeElement)desc.getValue();
                    if (!element.equals(treeelement.getValue())) continue;
                    this.selectItem(i);
                } else {
                    if (!element.equals(desc.getValue())) continue;
                    this.selectItem(i);
                }
                break;
            }
        }
        finally {
            this.updateParentTitle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterElement(PsiElement element, VirtualFile file2) {
        try {
            AbstractTreeNode lastPathNode = this.goDownToElement(element, file2);
            if (lastPathNode == null) {
                return;
            }
            this.buildList(lastPathNode);
            this.ensureSelectionExist();
        }
        finally {
            this.updateParentTitle();
        }
    }

    private AbstractTreeNode goDownToElement(Object element, VirtualFile file2) {
        return this.goDownToNode((AbstractTreeNode)this.myTreeStructure.getRootElement(), element, file2);
    }

    public final void enterElement(AbstractTreeNode element) {
        try {
            this.buildList(element);
            this.ensureSelectionExist();
        }
        finally {
            this.updateParentTitle();
        }
    }

    private AbstractTreeNode goDownToNode(AbstractTreeNode lastPathNode, Object lastPathElement, VirtualFile file2) {
        if (file2 == null) {
            return lastPathNode;
        }
        AbstractTreeNode found = lastPathNode;
        while (found != null && !this.nodeIsAcceptableForElement(lastPathNode, lastPathElement)) {
            found = this.findInChildren(lastPathNode, file2, lastPathElement);
            if (found == null) continue;
            lastPathNode = found;
        }
        return lastPathNode;
    }

    private AbstractTreeNode findInChildren(AbstractTreeNode rootElement, VirtualFile file2, Object element) {
        Object[] childElements = this.getChildren(rootElement);
        List<AbstractTreeNode> nodes = this.getAllAcceptableNodes(childElements, file2);
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        if (nodes.isEmpty()) {
            return null;
        }
        if (file2.isDirectory()) {
            return nodes.get(0);
        }
        return this.performDeepSearch(nodes.toArray(), element, (Set<AbstractTreeNode>)new THashSet());
    }

    private AbstractTreeNode performDeepSearch(Object[] nodes, Object element, Set<AbstractTreeNode> visited) {
        for (Object node1 : nodes) {
            AbstractTreeNode nodeResult;
            AbstractTreeNode node = (AbstractTreeNode)node1;
            if (this.nodeIsAcceptableForElement(node, element)) {
                return node;
            }
            Object[] children2 = this.getChildren(node);
            if (!visited.add(node) || (nodeResult = this.performDeepSearch(children2, element, visited)) == null) continue;
            return nodeResult;
        }
        return null;
    }

    protected abstract boolean nodeIsAcceptableForElement(AbstractTreeNode var1, Object var2);

    protected abstract List<AbstractTreeNode> getAllAcceptableNodes(Object[] var1, VirtualFile var2);

    public void dispose() {
        this.myIsDisposed = true;
    }

    private void buildList(AbstractTreeNode parentElement) {
        this.myCurrentParent = parentElement;
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        alarm.addRequest(() -> this.myList.setCursor(Cursor.getPredefinedCursor(3)), 200);
        Object[] children2 = this.getChildren(parentElement);
        this.myModel.removeAllElements();
        if (this.shouldAddTopElement()) {
            this.myModel.addElement((Object)new TopLevelNode(this.myProject, parentElement.getValue()));
        }
        for (Object aChildren : children2) {
            AbstractTreeNode child = (AbstractTreeNode)aChildren;
            child.update();
        }
        if (this.myComparator != null) {
            Arrays.sort(children2, this.myComparator);
        }
        for (Object aChildren : children2) {
            this.myModel.addElement(aChildren);
        }
        int n = alarm.cancelAllRequests();
        if (n == 0) {
            alarm.addRequest(() -> this.myList.setCursor(Cursor.getDefaultCursor()), 0);
        }
    }

    protected boolean shouldAddTopElement() {
        return !this.myShownRoot.equals((Object)this.myCurrentParent);
    }

    private Object[] getChildren(AbstractTreeNode parentElement) {
        if (parentElement == null) {
            return new Object[]{this.myTreeStructure.getRootElement()};
        }
        return this.myTreeStructure.getChildElements((Object)parentElement);
    }

    protected final void updateList() {
        if (this.myIsDisposed || this.myCurrentParent == null) {
            return;
        }
        if (this.myTreeStructure.hasSomethingToCommit()) {
            this.myTreeStructure.commit();
        }
        AbstractTreeNode parentDescriptor = this.myCurrentParent;
        while (true) {
            parentDescriptor.update();
            if (parentDescriptor.getValue() != null) break;
            parentDescriptor = parentDescriptor.getParent();
        }
        Object[] children2 = this.getChildren(parentDescriptor);
        HashMap elementToIndexMap = new HashMap();
        for (int i = 0; i < children2.length; ++i) {
            elementToIndexMap.put(children2[i], (Object)i);
        }
        ArrayList<NodeDescriptor> resultDescriptors = new ArrayList<NodeDescriptor>();
        Object[] listChildren = this.myModel.toArray();
        for (Object child : listChildren) {
            Integer index;
            if (!(child instanceof NodeDescriptor)) continue;
            NodeDescriptor descriptor = (NodeDescriptor)child;
            descriptor.update();
            Object newElement = descriptor.getElement();
            Integer n = index = newElement != null ? (Integer)elementToIndexMap.get(newElement) : null;
            if (index == null) continue;
            resultDescriptors.add(descriptor);
            descriptor.setIndex(index.intValue());
            elementToIndexMap.remove(newElement);
        }
        for (Object child : elementToIndexMap.keySet()) {
            Integer index = (Integer)elementToIndexMap.get(child);
            if (index == null) continue;
            NodeDescriptor childDescr = this.myTreeStructure.createDescriptor(child, (NodeDescriptor)parentDescriptor);
            childDescr.setIndex(index.intValue());
            childDescr.update();
            resultDescriptors.add(childDescr);
        }
        SelectionInfo selection = this.storeSelection();
        if (this.myComparator != null) {
            Collections.sort(resultDescriptors, this.myComparator);
        } else {
            Collections.sort(resultDescriptors, IndexComparator.INSTANCE);
        }
        if (this.shouldAddTopElement()) {
            ArrayList<TopLevelNode> elems = new ArrayList<TopLevelNode>();
            elems.add(new TopLevelNode(this.myProject, parentDescriptor.getValue()));
            elems.addAll(resultDescriptors);
            this.myModel.replaceElements(elems);
        } else {
            this.myModel.replaceElements(resultDescriptors);
        }
        this.restoreSelection(selection);
        this.updateParentTitle();
    }

    private SelectionInfo storeSelection() {
        ListSelectionModel selectionModel = this.myList.getSelectionModel();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        int[] selectedIndices = this.myList.getSelectedIndices();
        int leadSelectionIndex = selectionModel.getLeadSelectionIndex();
        Object leadSelection = null;
        for (int index : selectedIndices) {
            if (index >= this.myList.getModel().getSize()) continue;
            Object o = this.myModel.getElementAt(index);
            selectedObjects.add(o);
            if (index != leadSelectionIndex) continue;
            leadSelection = o;
        }
        return new SelectionInfo(selectedObjects, leadSelectionIndex, leadSelection);
    }

    private void restoreSelection(SelectionInfo selection) {
        ArrayList<Object> selectedObjects = selection.mySelectedObjects;
        ListSelectionModel selectionModel = this.myList.getSelectionModel();
        selectionModel.clearSelection();
        if (!selectedObjects.isEmpty()) {
            int leadIndex = -1;
            for (int i = 0; i < selectedObjects.size(); ++i) {
                Object o = selectedObjects.get(i);
                int index = this.myModel.indexOf(o);
                if (index <= -1) continue;
                selectionModel.addSelectionInterval(index, index);
                if (o != selection.myLeadSelection) continue;
                leadIndex = index;
            }
            if (selectionModel.getMinSelectionIndex() == -1) {
                int toSelect = Math.min(selection.myLeadSelectionIndex, this.myModel.getSize() - 1);
                if (toSelect >= 0) {
                    this.myList.setSelectedIndex(toSelect);
                }
            } else if (leadIndex != -1) {
                selectionModel.setLeadSelectionIndex(leadIndex);
            }
        }
    }

    public final AbstractTreeNode getParentNode() {
        return this.myCurrentParent;
    }

    protected abstract void updateParentTitle();

    public final void buildRoot() {
        this.buildList(this.myShownRoot);
    }

    private static final class SelectionInfo {
        public final ArrayList<Object> mySelectedObjects;
        public final Object myLeadSelection;
        public final int myLeadSelectionIndex;

        public SelectionInfo(ArrayList<Object> selectedObjects, int leadSelectionIndex, Object leadSelection) {
            this.myLeadSelection = leadSelection;
            this.myLeadSelectionIndex = leadSelectionIndex;
            this.mySelectedObjects = selectedObjects;
        }
    }

    public static interface Model {
        public void removeAllElements();

        public void addElement(Object var1);

        public void replaceElements(List var1);

        public Object[] toArray();

        public int indexOf(Object var1);

        public int getSize();

        public Object getElementAt(int var1);
    }
}

